/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bcGz
 */

package
{
    import flash.display.*;
    import flash.system.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 461, height = 461)]
    public class Instance extends Sprite
    {
        public function Instance()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        protected function _init() :void
        {
            graphics.clear     ();
            graphics.lineStyle (1);
            graphics.drawRect  (0, 0, 460, 460);
        }
        
        private function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            _init(); 
            
            NodeBuffer.gridParent = this;
            NodeBuffer.buildContext(this);
            NodeBuffer.initGame();
        }
    }
}

import flash.display.*;
import flash.system.*;
import flash.events.*;
import flash.geom.*;

class NodeBuffer
{
    public static var dialogNode :DialogNode;
    public static var nodeDelegate :Object;
    public static var gridParent :Object;
    public static var gridArray :Array = [];
    public static var sizeArray :Array = [];
    
    public static var snakePos :Point;
    public static var snakeApple :Point;
    public static var snakeLength :Number;
    
    public static var TYPE_EMPTY :Number = 0x000000;
    public static var TYPE_SNAKE :Number = 0xFF00FF;
    public static var TYPE_DART :Number = 0x00FF00;
    public static var TYPE_FIRE :Number = 0xFF0000;
    public static var TYPE_ICE  :Number = 0x0000FF;
    
    public static function buildContext($context:Object) :void
    {
        for (var $x:Number = 0; $x < 23; $x++)
        {
            gridArray[$x] = [];
                
            for (var $y:Number = 0; $y < 23; $y++)
            {
                gridArray[$x][$y] = new Node($x, $y, 20);
                $context.addChild(gridArray[$x][$y]);
            }
        }       
        
        dialogNode = new DialogNode();
        $context.addChild(dialogNode);
    }
     
    public static function nodeDialog($caller:Object) :void
    {
        if (nodeDelegate != null)
        {
            if (($caller != nodeDelegate) || ($caller == DialogNode))
            {
                dialogNode.hideDialog();              
                
                nodeDelegate.alpha = 0.5;
                nodeDelegate = null;
            }
        }else{
            nodeDelegate = $caller;
            nodeDelegate.alpha = 0.75;
            
            dialogNode.showDialog(nodeDelegate);
        }
    }
    
    public static function initGame() :void
    {
        if (gridParent) {gridParent.addEventListener(Event.ENTER_FRAME, onEnterFrame)}    
    }
    
    public static function generateSnake($length:Number = 5) :void
    {
        //gridArray[snakePos.x][snakePos.y].type = TYPE_SNAKE;
    }
    
    private static function onEnterFrame($e:Event) :void
    {
        generateSnake();
        
        //addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
    
    public static function addedToStage($e:Event) :void
    {
        //removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        //removeEventListener(Event.ENTER_FRAME, onEnterFrame);
        //removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        //removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        //removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        TYPE_SNAKE = 0x000000;
        TYPE_EMPTY = 0xFFFFFF;
        TYPE_FIRE = 0x00FFFF;
        TYPE_DART = 0x00FF00;
        TYPE_ICE = 0x0000FF;
        
    }

    
    public static function sign($num:Number) :Number
    {return ($num > 0) ? 1 : (($num < 0) ? -1 : 0)}
}

class Apple extends Sprite
{
    public function Apple()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }

    public function _init() :void
    {
        graphics.clear     ();
        graphics.beginFill (0, 0.9);
        graphics.drawRect  (0, 0, 20, 20);
        graphics.endFill   ();
        
        graphics.moveTo(40, 50);
        graphics.lineTo((x + width), (y + height));
        graphics.lineTo(40, 50);
        graphics.lineTo((x + width) + x, (y + height) + y);
        graphics.curveTo(40, 50, 232.5, 232.5);
        
        graphics.beginFill (0, 0.9);
        graphics.drawRect  (1, 1, 20, 20);
        graphics.endFill   ();
    }
        
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        _init();
    }
}

class Node extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _color :Number;
    protected var _alpha :Number;
    
    private var bDialog :Boolean;
    
    public function Node($x:Number, $y:Number, $scale:Number)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = (($x * $scale) + 1);
        _y = (($y * $scale) + 1);
        _width = _height = ($scale - 1);
        _color = 0;
        _alpha = 0.5;
        
        bDialog = false;
    }
    
    protected function _init() :void
    {
        graphics.clear     ();
        graphics.beginFill (type, alpha);
        graphics.drawRect  (x, y, scale, scale);
    }
    
    private function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _init();
        
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    private function onMouseOver($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
        if (NodeBuffer.nodeDelegate != this)
           {alpha = 0.25}
    }
    
    private function onMouseOut($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
        if (NodeBuffer.nodeDelegate != this)
           {alpha = 0.5}
    }
    
    private function onMouseDown($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
    }
    
    private function onMouseUp($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        dialogNode();
    }
    
    private function dialogNode() :void
    {
        NodeBuffer.nodeDialog(this);
    }
    
    public function get type() :Number
    { return _color }
    public function get scale() :Number
    { return _width }
    public function set type($:Number) :void
    { _color = $; _init(); }
    public function set scale($:Number) :void
    { _width = _height = $; _init(); }
    
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get alpha() :Number
    { return _alpha }
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
    public override function set alpha($:Number) :void
    { _alpha = $; _init(); }
}

class DialogNode extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _width :Number;
    protected var _height :Number;
    protected var _color :Number;
    protected var _alpha :Number;
    
    private var optionAlpha :Number;
    private var optionEnum :Number;
    private var optionDart :Sprite;
    private var optionFire :Sprite;
    private var optionIce :Sprite;
    
    public function DialogNode()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = 0;
        _y = 0;
        _width = 0;
        _height = 0;
        _alpha = 0;
        _color = 0;
        
        optionAlpha = 0;
        optionEnum = 4;
        optionDart = new Sprite;
        optionFire = new Sprite;
        optionIce = new Sprite;
    }
    
    public function _init() :void
    {
        graphics.clear     ();
        graphics.beginFill (color, alpha);
        graphics.drawRect  (x, y, width, height);
        graphics.endFill   ();
        
        optionDart.graphics.clear     ();
        optionDart.graphics.beginFill (0x00FF00, optionAlpha);
        optionDart.graphics.drawRect  ((x + (width / 8)), (y + (height / 2) - 9.5), 19, 19);
        optionDart.graphics.endFill   ();
        
        optionFire.graphics.clear     ();
        optionFire.graphics.beginFill (0xFF0000, optionAlpha);
        optionFire.graphics.drawRect  ((x + (width / 2) - 9.5), (y + (height / 2) - 9.5), 19, 19);
        optionFire.graphics.endFill   ();
        
        optionIce.graphics.clear     ();
        optionIce.graphics.beginFill (0x6666FF, optionAlpha);
        optionIce.graphics.drawRect  ((x + (width * 0.875) - 19), (y + (height / 2) - 9.5), 19, 19);
        optionIce.graphics.endFill   ();
        
        optionIce.graphics.clear     ();
        optionIce.graphics.beginFill (0x0000FF, optionAlpha);
        optionIce.graphics.drawRect  ((x + (width * 0.875) - 19), (y + (height / 2) - 9.5), 19, 19);
        optionIce.graphics.endFill   ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(optionDart);
        addChild(optionFire);
        addChild(optionIce);
        
        _init();
        
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
    }
    
    public function showDialog($target:Object) :void
    {
        x = ($target.x - (50 - ($target.scale / 2)));
        y = ($target.y - 100.5);
        width = 100;
        height = 80;
        alpha = optionAlpha = 0.75;
    }
    
    public function hideDialog() :void
    {
        width = height = 0;
        alpha = optionAlpha = 0;
    }
    
    public function onMouseOver($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);  
        
        if  ($e.target != optionDart.parent)
            {$e.target.alpha = 0.5}
    }

    public function onMouseOut($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);    
        
        if  ($e.target != optionDart.parent)
            {$e.target.alpha = 1}
    }
    
    private var mouseObject :Object;
    
    public function onMouseDown($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_UP, onMouseUp);     
        
        if  ($e.target != this)
            {mouseObject = $e.target}
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        if  ($e.target == mouseObject)
            {transformNode($e.target)}
    }
    
    public function transformNode($target:Object) :void
    {
        switch ($target)
        {
            case (optionDart):
                NodeBuffer.nodeDelegate.type = NodeBuffer.TYPE_DART;
            break;
            
            case (optionFire):
                NodeBuffer.nodeDelegate.type = NodeBuffer.TYPE_FIRE;
            break;
            
            case (optionIce):
                NodeBuffer.nodeDelegate.type = NodeBuffer.TYPE_ICE;
            break;
        }
        
        NodeBuffer.nodeDialog(this);
    }
     
    public function get color() :Number
    { return _color }
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _width }
    public override function get height() :Number
    { return _height }
    public override function get alpha() :Number
    { return _alpha }
    
    public function set color($:Number) :void
    { _color = $; _init(); }
    public override function set x($:Number) :void
    { _x = $; _init(); }
    public override function set y($:Number) :void
    { _y = $; _init(); }
    public override function set width($:Number) :void
    { _width = $; _init(); }
    public override function set height($:Number) :void
    { _height = $; _init(); }
    public override function set alpha($:Number) :void
    { _alpha = $; _init(); }
}