/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bboQ
 */

package
{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
 
	public class Main extends Sprite
	{
		private var bd:BitmapData;
		private var maskbd:BitmapData;
		private var temp:BitmapData;
		private var image:BitmapData;
		private var count:int = 0;
 
		public function Main()
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.INIT, initHandler);
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/2/28/28ab/28ab32110250938b9e1f0d3a0c0854fc5abaab1d"), new LoaderContext(true));
		}
 
		private function initHandler(event:Event):void
		{
			var loader:Loader = event.currentTarget.loader;
			var scale:Number = (loader.width > loader.height) ? stage.stageWidth / loader.width : stage.stageHeight / loader.height;
			var matrix:Matrix = new Matrix();
			matrix.scale(scale, scale);
			image = new BitmapData(loader.width, loader.height, true, 0x0);
			image.draw(loader, matrix);
 
			maskbd = new BitmapData(loader.width, loader.height, true, 0x0);
			maskbd.perlinNoise(maskbd.width, maskbd.height, 5, int.MAX_VALUE * Math.random(), false, false, 4);
 
			temp = new BitmapData(loader.width, loader.height, true, 0x0);
 
			bd = new BitmapData(loader.width, loader.height, true, 0x0);
			addChild(new Bitmap(bd));
 
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			temp.fillRect(temp.rect, 0x0); 
			temp.threshold(maskbd, maskbd.rect, new Point(), "<=", count, 0xFF000000, 0xFF);
			bd.copyPixels(image, image.rect, new Point(), temp, new Point());
 
			if (count++ == 0xCC)
			{
				count = 0;
				bd.fillRect(bd.rect, 0xFFFFFF);
			}
		}
	}
}
