/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bbZQ
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	/**
	 * H2O
	 * ...
	 * @author _s
	 */
	public class Main extends Sprite 
	{
		
		public var atoms:Vector.<Atom> = new Vector.<Atom>();
		
		[SWF(width="465", height="465", frameRate="40")]
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			this.x = this.stage.stageWidth/2;
			this.y = this.stage.stageHeight/2;
			
			this.create();
			this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
		}
		
		private function create():void
		{
			
			for (var i:int = 0; i < 100; i++) 
			{
				var a:Atom = new Atom();
				a.x = Math.random() * 200 - 100 ;
				a.y = Math.random() * 200 - 100 ;
				a.z = Math.random() * 200 - 100;
				a.vx = Math.random() * 2 - 1;
				a.vy = Math.random() * 2 - 1;
				a.vz = Math.random() * 2 - 1;
				a.rotationX = Math.random() * 90 - 45;
				a.rotationY = Math.random() * 90 - 45;
				a.rotationZ = Math.random() * 90 - 45;
				this.addChild(a);
				this.atoms[i] = a;
			}
			
		}
		
		private function enterFrameHandler(event:Event):void
		{
			this.move();
			this.moveCenter();
			this.check();
			
			this.rotationY += 0.5;
			this.rotationX += 0.2;
			this.rotationZ += 0.05;
		}
		
		private function check():void
		{
			for (var i:int = 0; i < this.atoms.length-1; i++) 
			{
				var a1:Atom = this.atoms[i];
				for (var j:int = i+1; j < this.atoms.length; j++) 
				{
					var a2:Atom = this.atoms[j];
					var dist:Number = Math.sqrt(a1.x * a1.x + a1.y * a1.y + a1.z * a1.z);
					if (dist < 20) this.chemistry(a1, a2);
				}
			}
		}
		
		public function chemistry(a1:Atom , a2:Atom):void
		{
			if ((a1.state == Atom.H) && (a2.state == Atom.H))
			{
				a1.change(Atom.H2);
				a2.change(Atom.H2);
			}
			else if (
				(a1.state == Atom.O) && (a2.state == Atom.H2) ||
				(a1.state == Atom.H2) && (a2.state == Atom.O)
			)
			{
				a1.change(Atom.H2O);
				a2.change(Atom.H2O);
			}
		}
		
		private function move():void
		{
			for (var i:int = 0; i < this.atoms.length; i++) 
			{
				var a:Atom = this.atoms[i];
				a.x += a.vx;
				a.y += a.vy;
				a.z += a.vz;
				a.filters = [new BlurFilter(Math.abs(a.z/20),Math.abs(a.z/20))];
			}
		}
		
		private function moveCenter():void
		{
			for (var i:int = 0; i < this.atoms.length; i++) 
			{
				var a:Atom = this.atoms[i];
				if (Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z) > 500)
				{
					a.vx -= a.x / 500;
					a.vy -= a.y / 500;
					a.vz -= a.z / 500;
				}
			}
		}
	}
	
}
import flash.display.Sprite;
import flash.text.TextField;

class Atom extends Sprite
{
	
	public var mass:Number = 1;
	public var vx:Number = 0;
	public var vy:Number = 0;
	public var vz:Number = 0;
	
	public static const H:String = "H";
	public static const H2:String = "H2";
	public static const O:String = "O";
	public static const H2O:String = "H2O";
	
	public var state:String = "";
	private var t:TextField = new TextField();
	
	public function Atom() 
	{
		super();
		
		this.addChild(this.t);
		this.init();
	}
	
	private function init():void
	{
		
		if (Math.random() > 0.5) this.change(H)
		else this.change(O);
		this.t.width = t.textWidth + 5;
		this.t.height = t.textHeight + 5;
	}
	
	public function change(state:String):void
	{
		switch (state) 
		{
			case H:
				this.t.htmlText = '<font size="20" color="#66CC22">' + H +'</font>';
				this.state = H;
				break;
			case H2:
				this.t.htmlText = '<font size="20" color="#9966BB">' + H2 +'</font>';
				this.state = H2;
				break;
			case O:
				this.t.htmlText = '<font size="20" color="#6699BB">'+ O +'</font>';
				this.state = O;
				break;
			case H2O:
				this.t.htmlText = '<font size="20" color="#3333BB">'+ H2O +'</font>';
				this.state = H2O;
				break;
		}
		this.t.width = t.textWidth + 5;
		this.t.height = t.textHeight + 5;
	}
	
}

