/**
 * Copyright 7kamura ( http://wonderfl.net/user/7kamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bbRJ
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    // アニメーション用の設定
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="10")]
    public class Main extends Sprite {
    		private var bmd:BitmapData;
    		private var tfld:TextField;
    		private var frameCount:int;
    		private var source:Sprite;
        public function Main() {
        		if(stage)
        			init();
        		else
        			addEventListener(Event.ADDED_TO_STAGE, init);
        }
        public function init(e:Event = null):void {
        		removeEventListener(Event.ADDED_TO_STAGE, init);
        		
        		source = new Sprite();
        		
        		tfld = new TextField();
        		tfld.background = true;
        		tfld.backgroundColor = 0x000000;
        		tfld.autoSize = TextFieldAutoSize.LEFT;
        		tfld.height = 20;
        		tfld.text = "http://twitter.com/gakuweb";
        		var tfmt:TextFormat = new TextFormat();
        		tfmt.size = 15;
        		tfmt.color = 0x0000FF;
        		tfmt.letterSpacing = 1;
     		tfld.setTextFormat(tfmt);
        		        		
        		// source.addChild(tfld);
        		
        		// 文字のピクセルが入ったbitmapDataを用意
        		bmd = new BitmapData(tfld.width, tfld.height);
        		bmd.draw(tfld);
        		// アンチエイリアスにより薄くなっている部分は表示しないように閾値(今回は0x000040以上で表示)を決める
        		for(var y:int; y<bmd.height; y++) {
        			for (var x:int; x<bmd.width; x++) {
        				var color:uint = bmd.getPixel(x,y);
        				if(color >= 0x000040)
        					bmd.setPixel(x,y,0xFF);
        				else
        					bmd.setPixel(x,y,0x00);
        			}
        		}
        		
        		// とりあえずテキストフィールドを画面上に表示する
        		addChild(source);
        		
        		frameCount = -31;
        		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        public function enterFrameHandler(e:Event):void {
        		// 端まで行ったらframeCountを初期化
        		frameCount++;
        		if(frameCount > bmd.width )
        			frameCount = -45;
        		
        		graphics.clear();
        		
        		for(var y:int=0; y<21; y++) {
        			for(var x:int=0; x<45; x++) {
        				var pixel:int;
        				if(x + frameCount < 0 || x + frameCount > bmd.width-1)
        					pixel = 0;
        				else
        					pixel = bmd.getPixel(x + frameCount, y);
        				
        				// ドットを描写(10, 40)を原点
        				if(pixel != 0)
        					drawDot(10 + x*10, 40 + y*10, 5, 0xF00000, 0x800000);
        				else
        					drawDot(10 + x*10, 40 + y*10, 5, 0x600000, 0x400000);
        			}
        		}	
        }
        
        public function drawDot(x:int, y:int, size:int, colorLight:int, colorDark:int):void {
        		var colors:Array = [colorLight, colorDark];
            var alphas:Array = [1.0, 1.0];
            var ratios:Array = [0, 255];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(size * 2, 
                                     size * 2, 
                                     0,
                                     x - size,
                                     y - size);
            
            graphics.lineStyle();
            graphics.beginGradientFill(GradientType.RADIAL, 
                                        colors,
                                        alphas,
                                        ratios,
                                        matrix);
            graphics.drawCircle(x, y, size);
            graphics.endFill(); 
        }
    }
}