/**
 * Copyright kaiho ( http://wonderfl.net/user/kaiho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/baf5
 */

/*
 * 昔ながらの車よけGameをイメージ
 * ・スコアは走った時間で増えていく
 * ・POWER０　で終了
 * ・壁接触　－５
 * ・その他の車接触　接触の仕方によって変わる
 */
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.DisplayObject;
	import flash.text.TextField;
	
	[SWF(width=400, height=400, backgroundColor=0x888888, frameRate=50)]
	
	public class Main extends Sprite 
	{
		
		//画面サイズ
		private var W:Number = 400;
		private var H:Number = 400;
		
		//マイカー
		private var myCar:car;
		private var carHandring:Number = 5;//マウス追っかけ速度
		private var myCarX:Number = W / 2;//初期表示位置(X軸)
		private var myCarY:Number = (H / 10) * 9;//初期表示位置(Y軸)
		private var myCarRote:Number = 0;
		private var myCarRflg:Boolean = false;
		private var myCarPower:Number = 50;//耐久性
		
		//スコア表示テキスト
		private var scoreText:TextField;
		private var SCORE:String = "SCORE　：　";
		private var s:Number = 0;
		
		//耐久性表示テキスト
		private var bodyText:TextField;
		private var POWER:String = "POWER　：　";
		
		//その他の車
		private var atherCar:car;
		private var atherCarX:Number = W / 2;//初期表示位置(X軸)
		private var atherCarSpeed:Number = 10;//
		private var hitR:Number = 45;
		
		//壁
		private var wallL:wall;//壁：左側
		private var wallR:wall;//壁：右側
		private var wallW:Number = 75;
		private var wallC:uint = 0xaaaaaa;
		
		private var wLine:whiteLine;//中央白線
		private var wlWid:Number = 4;
		private var wlHei:Number = 100;
		private var wlSpeed:Number = 30;//白線の速度
		
		public function Main():void 
		{
			makingWall();
			makingLine();
			makingMyCar();
			makingAther();
			makeText();
		}
		
		//マイカー
		private function makingMyCar():void {
			myCar = new car(this, myCarX, myCarY);
			
			stage.addEventListener(Event.ENTER_FRAME, drivingCar);
			
			stage.addChild(myCar);
			
		}
		
		//他車
		private function makingAther():void {
			atherCar = new car(this, myCarX, 0);
			
			stage.addEventListener(Event.ENTER_FRAME, drivingAtherCar);
			
			stage.addChild(atherCar);
		}
		
		//壁
		private function makingWall():void {
			wallL = new wall(0, wallW, H, wallC);
			wallR = new wall(W - wallW, wallW, H, wallC);
			
			stage.addChild(wallL);
			stage.addChild(wallR);
		}
		
		//中央白線
		private function makingLine():void {
			wLine = new whiteLine(myCarX, wlWid, wlHei, wlSpeed , H);
			
			stage.addEventListener(Event.ENTER_FRAME, flowLine);
			stage.addChild(wLine);
			
		}
		
		//テキスト
		private function makeText():void {
			//スコアテキスト
			scoreText = new TextField();
			scoreText.text = SCORE + s;
			stage.addChild(scoreText);
			
			//耐久性テキスト
			bodyText = new TextField();
			bodyText.text = POWER + myCarPower;
			bodyText.y = 30;
			stage.addChild(bodyText);
		}
		
		public function drivingCar(event:Event):void {
			
			if (mouseX > myCar.x) {
				myCar.x += carHandring;
				
				//車位置微調整
				if (mouseX < myCar.x) {
					myCar.x = mouseX;
				}
			} else if(mouseX < myCar.x) {
				myCar.x -= carHandring;
				
				//車位置微調整
				if (mouseX > myCar.x) {
					myCar.x = mouseX;
				}
			} 
			
			checkWall();
			
		} 
		
		private function drivingAtherCar(event:Event):void {
			atherCar.y += atherCarSpeed;
			
			if (atherCar.hitTestObject(myCar)) {
				bodyText.text = POWER + --myCarPower;
				
				if (myCarPower < 0) {
					bodyText.text = POWER + "0";
					stopCar();
				}
				myCarRote = hitR;
				stage.addEventListener(Event.ENTER_FRAME, hitCar);
			}
			
			nextCar();
		}
		
		private function flowLine(event:Event):void {
			wLine.flow();
			scoreText.text = SCORE + ++s;
		}
		
        private function checkWall():void{
			//壁接触チェック
			if (myCar.hitTestObject(wallL) || myCar.hitTestObject(wallR)) {
				myCarPower = myCarPower - 5;
				
				stage.addEventListener(Event.ENTER_FRAME, hitWall);
				stage.removeEventListener(Event.ENTER_FRAME, drivingCar);
				
				if (myCarPower < 0) {
					myCarPower = 0
					stopCar();
				}
				
				bodyText.text = POWER + myCarPower;
			}
        }
		
		private function nextCar():void {
			if (atherCar.y + 30 > H) {
				atherCar.y = -50;
				atherCar.x = (Math.random() * (W - 200)) + 100;
			}
			
			if (Math.random() * 10 > 8) {
				atherCar.scaleY = -1;
				atherCarSpeed = 50;
			} else {
				atherCar.scaleY = 1;
				atherCarSpeed = 10;
			}
			
		}
		
		private function hitCar(event:Event):void {
			myCar.rotation = myCarRote;
			if (myCarRflg) {
				myCarRote = Math.abs(myCarRote) - 1;
				myCarRflg = false;
			} else {
				myCarRote = (Math.abs(myCarRote) - 1) * - 1;
				myCarRflg = true;
			}
			
			if (myCarRote == 0) {
				stage.removeEventListener(Event.ENTER_FRAME, hitCar);
			}
		}
		
		private function hitWall(event:Event):void {
			
			if (myCar.x < (W / 2)) {
				myCar.x += 5;
			} else {
				myCar.x -= 5
			}
			
			if (Math.abs(myCar.x - (W / 2)) < 50) {
				stage.addEventListener(Event.ENTER_FRAME, drivingCar);
				stage.removeEventListener(Event.ENTER_FRAME, hitWall);
			}
		}
		
		private function stopCar():void {
			stage.removeEventListener(Event.ENTER_FRAME, drivingCar);
			stage.removeEventListener(Event.ENTER_FRAME, drivingAtherCar);
			stage.removeEventListener(Event.ENTER_FRAME, flowLine);
			stage.removeEventListener(Event.ENTER_FRAME, hitWall);
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Sprite

import flash.events.Event;

class car extends Sprite {
	
	private var f:Main;
	
	private var color:uint = 0x0;
	
	public var w:Number = 20;
	
	public function car(f:Main, x:Number, y:Number) {
		this.f = f;
		this.x = x;
		this.y = y;
		
		makeCar();
		
	}
	
	//車もどき
	private function makeCar():void {
		graphics.lineStyle(1, color, 1);
		graphics.beginFill(color);
		graphics.moveTo(-10, -20);
		graphics.lineTo(10, -20);
		graphics.lineTo(10, -10);
		graphics.lineTo(15, -10);
		graphics.lineTo(15, -5);
		graphics.lineTo(10, -5);
		graphics.lineTo(10, 13);
		graphics.lineTo(15, 13);
		graphics.lineTo(15, 18);
		graphics.lineTo(10, 18);
		graphics.lineTo(10, 20);
		graphics.lineTo(-10, 20);
		graphics.lineTo(-10, 18);
		graphics.lineTo(-15, 18);
		graphics.lineTo(-15, 13);
		graphics.lineTo(-10, 13);
		graphics.lineTo(-10, -5);
		graphics.lineTo(-15, -5);
		graphics.lineTo(-15, -10);
		graphics.lineTo(-10, -10);
		graphics.lineTo(-10, -20);
		graphics.endFill();
	}
	
}

class wall extends Shape {
	
	private var wallHei:Number;
	private var wallWid:Number;
	
	private var wColor:Number;
	
	public function wall(x:Number, w:Number, h:Number, c:uint) {
		this.x = x;
		wallWid = w;
		wallHei = h;
		wColor = c;
		
		makeWall();
	}
	
	private function makeWall():void {
		graphics.lineStyle(1, wColor, 1);
		graphics.beginFill(wColor);
		graphics.lineTo(wallWid, 0);
		graphics.lineTo(wallWid, wallHei);
		graphics.lineTo(0, wallHei);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//中央白線Class
class whiteLine extends Shape {
	
	private var ay:Number;
	
	private var lineW:Number;
	private var lineH:Number;
	private var lineEnd:Number;
	
	private var lColor:uint = 0xFFFFFF;
	
	public function whiteLine(x:Number, w:Number, h:Number, ay:Number, le:Number) {
		this.x = x
		this.ay = ay;
		this.lineW = w;
		this.lineH = h;
		this.lineEnd = le;
		
		makeLine();
		
	}
	
	private function makeLine():void {
		graphics.lineStyle(1, lColor, 1);
		graphics.beginFill(lColor);
		graphics.moveTo((lineW/2)*-1, 0);
		graphics.lineTo((lineW/2)*-1, lineH * -1);
		graphics.lineTo((lineW/2), lineH * -1);
		graphics.lineTo((lineW/2), 0);
		graphics.lineTo((lineW/2)*-1, 0);
		graphics.endFill();
	}
	
	public function flow():void {
		y += ay;
		nextFlow();
	}
	
	private function nextFlow():void {
		if (y - lineH > lineEnd) {
			y = 0;
		}
	}
}