/**
 * Copyright Abarrow ( http://wonderfl.net/user/Abarrow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/baXa
 */

package {
    import com.bit101.components.*;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.text.TextField;


    public class PixelBitmap extends Sprite {
        
        private const _url:String = "http://farm4.static.flickr.com/3216/2751164680_bc66bfbda9.jpg";           
        private var push:PushButton;
        private var _loader:Loader;             
      
        public function PixelBitmap()
        {

            configureAssets();
        }

        private function configureAssets():void{
            _loader=new Loader();            
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);

            var request:URLRequest = new URLRequest(_url);

            _loader.load(request, new LoaderContext(true));
            _loader.name = 'test';                   
            addChild(_loader);
            push=new PushButton(this, 10, 10, 'Encode')        
        }

        private function completeHandler(event:Event):void {          
             var source:Bitmap = Bitmap(LoaderInfo(event.target).content);
             var bit:BitmapData=new BitmapData(source.width, source.height, true, 0x00000000);
             bit.draw(source);
             var hold:Bitmap=new Bitmap(bit);
             hold.visible=false;
             addChild(hold);
             addChild(push);
             push.addEventListener(MouseEvent.CLICK,function(event:MouseEvent):void{if(!hold.visible){push.label='Decode';}else{push.label='Encode';}_loader.visible=hold.visible;hold.visible=!hold.visible}); 
             //procecess the image
             for(var ex:int=0;ex<bit.width;ex++){
                for(var ey:int=0;ey<bit.width;ey++){
                    bit.setPixel32(ex, ey, bit.getPixel32(ex, ey)<<5);
                }
             }
         }
         public function parseColor(r:uint, g:uint, b:uint, a:int=-1):uint{
            if(a==-1){
                return parseInt("0x"+hexChannel(r)+hexChannel(g)+hexChannel(b));
            }else{
                return parseInt("0x"+hexChannel(a)+hexChannel(r)+hexChannel(g)+hexChannel(b));
            }
         }
         public function hexChannel(cha:uint):String{
            if(cha>255){
                return 'ff';
            }else{
                var str:String=cha.toString(16);
                if(str.length==1){
                    return '0'+str;
                }else{
                    return str;
                }
            }
         }
    }
}
