/**
 * Copyright Kow ( http://wonderfl.net/user/Kow )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ba9a
 */

// forked from rettuce's metaball
package
{    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.events.MouseEvent;
    import flash.events.ProgressEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.ui.Mouse;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author rettuce
     * 
     */
//    [SWF(width = 800, height = 600, backgroundColor = 0x000000, frameRate = 30)]
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    public class Main extends Sprite
    {
        private var W:Number, H:Number, W2:Number, H2:Number;
        private var CENTER:Point;
        private var _wonderflBG:Sprite;
        
        public function Main(){
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init );
        }        
        private function init(e:Event = null ):void{
            removeEventListener(Event.ADDED_TO_STAGE, init );
            setStage();
            
            // metaball
            ballSet();
            
            loaderInfo.addEventListener(Event.UNLOAD, function(e:Event):void {
                stage.removeEventListener(Event.RESIZE, resizeEvent);
                loaderInfo.removeEventListener(Event.UNLOAD, arguments.callee );
            });
        }        
                
        
        
        /* MetaBall */
        //////////////////////////////////////////////////////////////////
        
        private var REICON_NUM:int = 20;
        private var _ballArr:Array = [];
        private function ballSet():void
        {
            for (var i:int = 0; i < REICON_NUM; i++){
                var r:Reicon = addChild(new Reicon) as Reicon;
                r.x = stage.stageWidth  * Math.random();
                r.y = stage.stageHeight * Math.random();
                r.ballInit();
                r._vx = Math.random() * 6-3;
                r._vy = Math.random() * 6-3;
                _ballArr[i] = r;
            }
            addEventListener(Event.ENTER_FRAME, enterframeHandler)
        }
        
        private var _vx:Number=0, _vy:Number=0;
        private function enterframeHandler(e:Event):void
        {
            for(var i:int =0; i<_ballArr.length; i++){
                var b:Reicon = _ballArr[i];
                _vx*=0.5;
                _vy*=0.5;                
                b.x += b._vx;
                b.y += b._vy;
                b.radius = mouseX;
                
                if(b.x > stage.stageWidth+b.width){
                    b.x = -b.width;
                }else if( b.x <= -b.width ){
                    b.x = stage.stageWidth + b.width;
                }
                
                if( b.y > stage.stageHeight + b.height ){
                    b.y = -b.height;
                }else if( b.y <= -b.height){
                    b.y = stage.stageHeight + b.height;
                }
            }          
        }
       
        
        
        /* Error Handler */
        //////////////////////////////////////////////////////////////////
        
        private function errorHandler(e:IOErrorEvent):void
        {
            trace( e );
        }
        
        
        /* stage set */
        //////////////////////////////////////////////////////////////////
        
        private function setStage():void
        {
            _wonderflBG = addChild( new Sprite ) as Sprite;
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener(Event.RESIZE, resizeEvent);
            resizeHandler();
        }
        private function resizeEvent(e:Event = null):void
        {
            resizeHandler();
        }        
        public function resizeHandler():void
        {
            W = stage.stageWidth;
            H = stage.stageHeight;
            W2 = int(W>>1);
            H2 = int(H>>1);
            CENTER = new Point(W2, H2);           
            _wonderflBG.graphics.clear();
            _wonderflBG.graphics.beginFill(0x000000);
            _wonderflBG.graphics.drawRect(0,0,W,H);           
        }
        
    }
}

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.BlurFilter;
    
class Reicon extends Sprite
{
        private var _base:Sprite;
        private var _balls:Vector.<Ball> = new Vector.<Ball>();
        
        private var NUM:int = 4;
        public var radius:Number = 50;
        public var _vx:Number=0, _vy:Number=0;
               
        public function Reicon()
        {
            super();
            _base = addChild( new Sprite ) as Sprite;
        }
        
        public function ballInit():void
        {
            var c:Number =  0xFFFFFF*Math.random();
            for(var i:int=0; i<NUM; i++ ){
                _balls[i] = _base.addChild(new Ball(c)) as Ball;
                _balls[i].speed = Math.random()*3 - 1.5;
                _balls[i].angle = Math.random();
                //_balls[i].radius = _balls[i].defRadius = Math.random() * _radius+50;
            }
            
            addEventListener(Event.ENTER_FRAME, move );
//            stage.addEventListener( MouseEvent.CLICK, allPan );
        }
        private function move(e:Event):void {
            for(var i:int=0; i<NUM; i++ ){
                var b:Ball = _balls[i];
                b.x = Math.cos( b.angle * Math.PI/180 ) * b.radius;
                b.y = Math.sin( b.angle * Math.PI/180 ) * b.radius;
                b.radius = radius;
                b.angle += b.speed;
            }
        }
        private function allPan(e:MouseEvent):void{
            for(var i:int=0; i<NUM; i++ ){
//                if(Math.random()>0.7)_balls[i].pan();
                _balls[i].pan();
            }
        }        
        
    }


import caurina.transitions.Tweener;

import flash.display.BlendMode;
import flash.display.Sprite;
import flash.filters.BlurFilter;

class Ball extends Sprite
{
    public var speed:Number = 0;
    public var angle:Number = 0;
    public var radius:Number = 0;
    public var defRadius:Number = 0;
    
    public function Ball($c:Number){
        graphics.beginFill($c);    // 0xF80000 6726655 // 0xE10051 0xFFFF30 0x00C5D4 0xBF3BEA
        graphics.drawCircle(0,0,70*Math.random()+30);
        graphics.endFill();
        var blur:BlurFilter = new BlurFilter(30,30,5);
        filters = [blur];
        blendMode = BlendMode.ADD;
    }
    
    public function pan():void{
        scaleX = scaleY = 1.2;
        Tweener.addTween( this,{ scaleX:1, scaleY:1, time:0.3, transition:'easeOutQuad' });
    }
    
}


