/**
 * Copyright xoul ( http://wonderfl.net/user/xoul )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bZT7n
 */

package
{
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;    
    
    public class Fountain extends Sprite
    {
        private static const MAX_WATER_DROPS : int = 200;
        private static const GRAVITY : Number = 9.8;
        private static const MAX_POWER : Number = 60;
        
        private var _canvas : BitmapData;
        private var _waterDrops : Vector.<Object>;
        
        private var _alphaTransform : ColorTransform;
        private var _blurFilter : BlurFilter;
        private var _zeroPoint : Point;
        
        public function Fountain()
        {
            _canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0 );
            addChild( new Bitmap( _canvas ) );
            
            _waterDrops = new Vector.<Object>( MAX_WATER_DROPS, true );
            
            for( var i : int = 0; i < MAX_WATER_DROPS; ++i )
            {
                var waterDrop : Object = {};
                waterDrop.x = stage.stageWidth / 2;
                waterDrop.y = stage.stageHeight;
                waterDrop.dx = 0;
                waterDrop.lastX = waterDrop.x;
                waterDrop.lastY = waterDrop.y;
                waterDrop.shooted = false;
                waterDrop.color = Math.random() * ( 0x00CCFF - 0x00CCCC ) + 0x00CCCC;
                waterDrop.power = 0;
                _waterDrops[i] = waterDrop;
            }
            
            _alphaTransform = new ColorTransform( 1, 1, 1, .9 );
            _blurFilter = new BlurFilter( 2, 2, 1 );
            _zeroPoint = new Point;
            
            addEventListener( Event.ENTER_FRAME, onEnterFrame );
        }
        
        private function onEnterFrame( e : Event ) : void
        {
            _canvas.lock();
            
            _canvas.colorTransform( _canvas.rect, _alphaTransform );
            
            var waterDrop : Object;
            
            for( var i : int = 0; i < MAX_WATER_DROPS; ++i )
            {
                waterDrop = _waterDrops[i];
                if( waterDrop.shooted )
                {
                    waterDrop.lastX = waterDrop.x;
                    waterDrop.lastY = waterDrop.y;
                    waterDrop.power -= GRAVITY;
                    waterDrop.x += waterDrop.dx;
                    waterDrop.y -= waterDrop.power;
                    drawLine( waterDrop.lastX, waterDrop.lastY, waterDrop.x, waterDrop.y, waterDrop.color );
                    if( waterDrop.y > stage.stageHeight )
                    {
                        waterDrop.x = stage.stageWidth / 2;
                        waterDrop.y = stage.stageHeight;
                        waterDrop.shooted = false;
                    }
                }
                else
                {
                    shoot( i );
                }

            }
            
            _canvas.applyFilter( _canvas, _canvas.rect, _zeroPoint, _blurFilter );
            
            _canvas.unlock();
        }
        
        private function shoot( i : int ) : void
        {
            var waterDrop : Object = _waterDrops[i];
            waterDrop.power = Math.random() * MAX_POWER + ( MAX_POWER >> 1 );
            waterDrop.dx = Math.random() * 20 - 10;
            waterDrop.shooted = true;
        }


        
        private function drawLine( startX : Number, startY : Number, endX : Number, endY : Number, color : Number ) : void
        {
            var dx : Number = endX - startX;
            var dy : Number = endY - startY;
            var a : Number;
            var b : Number;
            var tmp : Number;
            var len : Number;
            var i : int;
            
            if( getAbs( dx ) > getAbs( dy ) )
            {
                a = dy / dx;
                b = startY;
                
                if( startX > endX )
                {
                    tmp = startX;
                    startX = endX;
                    endX = tmp;
                    b = endY;
                }
                
                len = endX - startX;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i + startX, i * a + b, color );
                }
            }
            else
            {
                a = dx / dy;
                b = startX;
                
                if( startY > endY )
                {
                    tmp = startY;
                    startY = endY;
                    endY = tmp;
                    b = endX;
                }
                
                len = endY - startY;
                for( i = 0; i < len; ++i )
                {
                    _canvas.setPixel( i * a + b, i + startY, color );
                }
            }
        }
        
        private function getAbs( x : Number ) : Number
        {
            return x < 0 ? -x : x;
        }
    }
}