/**
 * Copyright mirkofresa ( http://wonderfl.net/user/mirkofresa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bZH7
 */

//-default-size 256 256 -default-frame-rate 120 -optimize

package
{
	import flash.display.Bitmap;
	import flash.display.Sprite;
	import flash.display.TextField;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.geom.Matrix;
	import flash.util.getTimer;
	import flash.util.trace;
	import flash.text.TextFormat;
	
	public class Circles extends Sprite
	{
		private const WIDTH: int = 256;
		private const HEIGHT: int = 256;
		private const COUNT: int = 200; // 19900 loops
	
		private const w: int = 256;
		private const h: int = 256;
		
		private var circles: Array;
		private var cSprite: Sprite;
		
		//-- fps
		private var fpsText: TextField;
		private var fr: int;
		private var ms: int;
		
		[Embed(source='pattern.gif')] public var PatternImage: Class;
		
		public function Circles()
		{
			//-- create background
			var pattern: Pattern = new Pattern( WIDTH, HEIGHT, new PatternImage().bitmapData );
			pattern.drawUnify();
			addChild( new Bitmap( pattern ) );
			
			stage.scaleMode = 'noScale';
			stage.addEventListener( Event.ENTER_FRAME, handle );
			
			cSprite = new Sprite();
			addChild( cSprite );
			createCircles();
			
			var ft: TextFormat = new TextFormat();
			ft.size = 10;
			ft.bold = true;
			ft.font = 'Verdana';
			ft.color = 0xcccccc;	
		
			fpsText = new TextField();
			fpsText.autoSize = 'left';
			fpsText.defaultTextFormat = ft;
			addChild( fpsText );
			ms = getTimer();
			fr = 0;
		}
		
		private function createCircles(): void
		{
			circles = new Array();
			
			trace( 'Count:', COUNT, 'will compute', ( COUNT * COUNT - COUNT ) / 2, 'loops' );
		}
		
		private function handle( event: Event ): void
		{
			if( circles.length < COUNT ) // ( ( n * n - n ) / 2 ) loops
			{
				var circle: Circle = new Circle( 4, 0xffffff );

				circle.x = circle.r + Math.random() * ( w - circle.r * 2 );
				circle.y = circle.r;
				
				circle.vx = Math.random() * 1 - .5;
				circle.vy = Math.random() * 1 - .5;
				
				cSprite.addChild( circle );
				circles.push( circle );
			}
			
			//-- check any against any once
			var c0: Circle;
			var c1: Circle;
			
			var x0: Number;
			var y0: Number;
			var x1: Number;
			var y1: Number;
			var dx: Number;
			var dy: Number;
			var dd: Number;
		
			var r0: Number;
			var r1: Number;
			var rr: Number;
			
			var scl: Number;
			var mvx: Number;
			var mvy: Number;
			
			var a: int = circles.length;
			var b: int;
			
			while( --a > -1 )
			{
				c0 = circles[a];
				x0 = c0.x;
				y0 = c0.y;
				r0 = c0.r;
				
				for( b = a - 1 ; b > -1 ; b-- )
				{
					c1 = circles[b];
					x1 = c1.x;
					y1 = c1.y;
					r1 = c1.r;
					
					dx = x1 - x0;
					dy = y1 - y0;
					dd = dx * dx + dy * dy;
					rr = r0 + r1;
					
					if( dd < rr * rr )
					{
						// collision
						dd = Math.sqrt( dd );
						dx /= dd;
						dy /= dd;
						
						c1.x = x0 + dx * rr;
						c1.y = y0 + dy * rr;
				
						scl = ( c1.vx * dx + c1.vy * dy ) - ( c0.vx * dx + c0.vy * dy ) * 1.1; //-- add some energie
					
						mvx = dx * scl;
						mvy = dy * scl;
				
						c1.vx -= mvx;
						c1.vy -= mvy;
						c0.vx += mvx;
						c0.vy += mvy;
					}
				}
			}
			
			//-- move
			var c: Circle;
			var x: Number;
			var y: Number;
			var r: Number;
			
			a = circles.length;
			while( --a > -1 )
			{
				c = circles[a];
				x = c.x;
				y = c.y;
				r = c.r;
				
				c.vx *= .99;
				c.vy *= .99;
				
				x += c.vx;
				y += ( c.vy += .015 );
				
				//-- bounds
				if( x < r )
				{
					x = r;
					c.vx = Math.abs( c.vx ) * .8;
				}
				if( x > w - r )
				{
					x = w - r;
					c.vx = Math.abs( c.vx ) * -.8;
				}
				if( y < r )
				{
					y = r;
					c.vy = Math.abs( c.vy ) * .8;
				}
				if( y > h - r )
				{
					y = h - r;
					c.vy = Math.abs( c.vy ) * -.8;
				}
				
				c.x = x;
				c.y = y;
			}
			
			//-- fps
			fr++;
			if( ms + 1000 < getTimer() )
			{
				fpsText.text = fr.toString();
				fr = 0;
				ms = getTimer();
			}
		}
	}
}