/**
 * Copyright sting ( http://wonderfl.net/user/sting )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bZCx
 */

// forked from nasajun's forked from: TextPlane3DEfect
// forked from Nyarineko's TextPlane3DEfect
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.text.*;
	
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	
	[SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="40")]
	public class textEfect extends BasicView
	{
		private var my3DObject:DisplayObject3D = new DisplayObject3D();
		
		private var MAX_A:Number = 20;
		private var MAX_B:Number = 8;
		private var MAX_W:Number = 40;
		private var MAX_H:Number = 50;
		
		private var bmpArray:Array;
		private var objArray:Array;
		private var bmpZero:BitmapData;
		private var mouseflg:Boolean = false;
		
		public function textEfect():void
		{
			bmpArray = [];
			objArray = [];
			
			camera.zoom = 60;
			camera.z = -1200;
			camera.y = 600;
			camera.rotationX = 20;
			
			for(var num:uint = 0;num < 10;num++){
				var tf:TextField = new TextField();
				var tff:TextFormat = new TextFormat();
				tff.align = TextFormatAlign.CENTER;	// 整列
				tff.size = 50;						// 文字のポイントサイズ
				tff.color = 0xffffff;				// 文字の色
				tf.defaultTextFormat = tff;
				tf.text = num.toString();
				tf.x = 0;
				
				var sp:Sprite = new Sprite();
				sp.graphics.beginFill(num / 10 *  0xff << 16 | num / 10 * 0xff << 8 | num / 10 * 0xff);
				//sp.graphics.beginFill(0xffffff);
				sp.graphics.drawRect(0,0,MAX_W,MAX_H);
				sp.graphics.endFill();
				sp.addChild(tf);
				
				var bmd:BitmapData = new BitmapData(MAX_W,MAX_H,true,0x33ffffff);
				bmd.draw(sp);
				
				bmpArray[num] = bmd;
				trace(bmpArray[num]);
			}
			
			bmpZero = new BitmapData(MAX_W,MAX_H,true,0x00ffffff);
			
			for(var j:uint = 0;j < MAX_B;j++){
				objArray[j] = [];
				for(var i:uint = 0;i < MAX_A;i++){
					var mt:BitmapMaterial = new BitmapMaterial(bmpArray[9]);
					mt.doubleSided = true;
					var o:Plane = new Plane(mt, MAX_W, MAX_H);
					o.x = 160 * Math.cos(Math.PI/180 * (360*(i/MAX_A)));
					o.z = 160 * Math.sin(Math.PI/180 * (360*(i/MAX_A)));
					o.y = (j+2) * 52;
					o.rotationY = 360 * -i / MAX_A - 90;
					objArray[j][i] = o;
					my3DObject.addChild(o);
				}
			}
			stage.addEventListener(MouseEvent.MOUSE_DOWN,downMouse);
			stage.addEventListener(MouseEvent.MOUSE_UP,upMouse);
			scene.addChild(my3DObject);
            // レンダリング
            startRendering();
		}
		
		private function downMouse(e:MouseEvent):void{
			trace(mouseY);
			mouseflg = true;
			my3DObject.x = (mouseX - 230)*2;
			my3DObject.z = - mouseY * 2 + 200;
		}
		
		private function upMouse(e:MouseEvent):void{
			trace(mouseY);
			mouseflg = false;
		}
		
		private function showPlane():void{
			for(var j:uint = 0;j < MAX_B;j++){
				for(var i:uint = 0;i < MAX_A;i++){
					var ran:Number = Math.floor(Math.random()*10);
					if(ran == 9 || objArray[j][i].material.bitmap != bmpZero){
						objArray[j][i].material.bitmap = bmpArray[ran];
					}
				}
			}
		}
		
		private function hidePlane():void{
			for(var j:uint = 0;j < MAX_B;j++){
				for(var i:uint = 0;i < MAX_A;i++){
					var ran:Number = Math.floor(Math.random()*10);
					if(ran == 0 || objArray[j][i].material.bitmap == bmpZero){
						objArray[j][i].material.bitmap = bmpZero;
					}else{
						objArray[j][i].material.bitmap = bmpArray[ran];
					}
				}
			}
		}
		override protected function onRenderTick(event:Event=null):void
		{
			if(mouseflg){
				showPlane();
			}else{
				hidePlane();
			}
			my3DObject.rotationY += 1;
			super.onRenderTick(event);
		}
	}
}