/**
 * Copyright nijitaro ( http://wonderfl.net/user/nijitaro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bZ0N
 */

/**
 * PV3Dで星空
 *
 * [感想]
 * PV3DのParticleFieldを使ってみた。
 * special内にあるクラスは用途が限定されるが
 * PV3Dの楽しさがわかりやすいクラスが揃っている
 *
 * [課題]
 * ただxを増やしているのでカメラがどんどん離れてしまう。
 * 原点を中心にカメラを回したい。
 *
 * - ParticleMaterial
 * - ParticleField
 */
package {
	import flash.events.Event;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.special.ParticleField;
    import org.papervision3d.materials.special.ParticleMaterial;
    [SWF( backgroundColor = "#222222", frameRate = "50" )]

    public class Main extends BasicView
    {
		private var stars:ParticleField;
		public function Main() {
			// マテリアル作成
			var material:ParticleMaterial = new ParticleMaterial( 0xffffcc, 1 );
			// ParticleFieldにマテリアルを貼る
			stars = new ParticleField(material);

			scene.addChild(stars);

			var sphere:Sphere = new Sphere( new WireframeMaterial( 0x66cccc, 0.3 ), 200, 16, 16 );
			scene.addChild(sphere);
					
			// BasicViewはDisplayObject.ZERO(原点)をターゲッティングしているので、
			// 原点を中心にして廻っているような動きをしている。
			// 以下のコメントを外すと、カメラが並行移動する
			//camera.target = null;
			
			startRendering();
		}
        override protected function onRenderTick (event :Event = null):void
        {
        		// カメラをX軸方向に移動
        		camera.x += 1;
        		// SuperクラスのonRenderTick
        		super.onRenderTick(event);
        	}
    }
}