/**
 * Copyright jloa ( http://wonderfl.net/user/jloa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bYuM
 */

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import com.bit101.components.TextArea;
    import com.bit101.components.PushButton;
    import com.bit101.components.Label;
    
    public class HEXTest extends Sprite
    {
        private var inLabel:Label;
        private var outLabel:Label;
        private var inArea:TextArea;
        private var outArea:TextArea;
        private var encodeBtn:PushButton;
        private var decodeBtn:PushButton;
        
        /** HEX delimiter **/
        private var HEXdelim:String = " ";
        /** exmaple string **/
        private var exampleStr:String = "Press the 'encode' button to encode this text to a HEX string, then copy the output result here and press the 'decode' button to restore this message from the HEX string. HEX encode support all languages, as encodes/decodes in utf-8.\n\nHope you might find it useful :)\njloa";
      
        public function HEXTest()
        {
            inLabel = new Label();
            inLabel.text = "Place here any text and press 'encode' / a hex string and press 'decode'";
            addChild(inLabel);
            
            inArea = new TextArea();
            inArea.y = 20;
            inArea.width = stage.stageWidth;
            inArea.height = 150;
            inArea.text = exampleStr;
            addChild(inArea);
            
            encodeBtn = new PushButton();
            encodeBtn.label = "encode";
            encodeBtn.x = stage.stageWidth - encodeBtn.width;
            encodeBtn.y = inArea.y + inArea.height + 10;
            encodeBtn.addEventListener(MouseEvent.CLICK, encodeDecodeClick);
            addChild(encodeBtn);
            
            decodeBtn = new PushButton();
            decodeBtn.label = "decode";
            decodeBtn.x = encodeBtn.x - decodeBtn.width - 5;
            decodeBtn.y = encodeBtn.y;
            decodeBtn.addEventListener(MouseEvent.CLICK, encodeDecodeClick);
            addChild(decodeBtn);
            
            outLabel = new Label();
            outLabel.text = "Here comes the output result:";
            outLabel.y = decodeBtn.y + 40;
            addChild(outLabel);
            
            outArea = new TextArea();
            outArea.y = outLabel.y + 20;
            outArea.width = stage.stageWidth;
            outArea.height = 150;
            addChild(outArea);
        }
        
        private function encodeDecodeClick(event:MouseEvent):void
        {
            var btn:PushButton = PushButton(event.currentTarget);
            if(btn == encodeBtn) outArea.text = HEXUtil.encode(inArea.text, HEXdelim);
            if(btn == decodeBtn) outArea.text = HEXUtil.decode(inArea.text, HEXdelim);
        }
    }
}

/** package com.chargedweb.utils **/

/** fp api **/    
import flash.utils.ByteArray;

 /**
  * <p>HEXUtil class - converts utf8 strings -> hex -> utf8 string</p>
  * @availability     fp9 (flash/flex, as3)
  * @version          1
  * @author           jloa | http://chargedweb.com/labs/
  */
internal class HEXUtil
{
    /**
     * Converts the source utf8 string to a hex equivalent string
     * @see #decode()
     * @example
     * <listing version="3.0">
     * var delim:String = " ";
     * var str:String = "Hello world!"
     * var strHexEnc:String = HEXUtil.encode(str, delim);
     *
     * trace("source:\t\t", str);            // source:     Hello world!
     * trace("encoded:\t", strHexEnc);        // encoded:     48 65 6C 6C 6F 20 77 6F 72 6C 64 21
     * </listing>
     * @param    source:String     source utf8 string to be converted to hex
     * @param    delim:String     hex delimiter @default ""
     * @return    String             the converted hex equivalent
     */
    public static function encode(source:String, delim:String = ""):String
    {
        var ba:ByteArray = new ByteArray();
        ba.writeUTFBytes(source); ba.position = 0;
        var n:int = ba.bytesAvailable;
        var output:String = ""; var char:String;
    
        for(var i:int = 0; i < n; ++i)
        {
            char = ba.readUnsignedByte().toString(16); char = (char.length == 1) ? "0" + char : char;
            output += (delim && i < n-1) ? char + delim : char;
        }
        return output.toUpperCase();
    }
        
    /**
     * Converts a hex string to a utf8 equivalent string
     * @example
     * <listing version="3.0">
     * var delim:String = " ";
     * var str:String = "48 65 6C 6C 6F 20 77 6F 72 6C 64 21"
     * var strHexDec:String = HEXUtil.decode(str, delim);
     *
     * trace("source:\t\t", str);            // source:     48 65 6C 6C 6F 20 77 6F 72 6C 64 21
     * trace("decoded:\t", strHexDec);        // decoded:     Hello world!
     * </listing>
     * @see #encode()
     * @param    hex:String         hex string to be converted to a utf8 string
     * @param    delim:String     hex delimiter @default ""
     * @return    String             converted utf8 equivalent
     */
    public static function decode(source:String, delim:String = ""):String
    {
        if(delim) source = source.split(delim).join("");
        var arr:Array = source.split("");
        var ba:ByteArray = new ByteArray();
        var n:int = arr.length;
 
        if(n%2 != 0) throw new ArgumentError("improper hex string passed '"+source+"' (string length should be even)");
        for(var i:int = 0; i < n; i += 2) ba.writeByte(parseInt(arr[i]+arr[i+1], 16));
        return ba.toString();
    }
}