/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bYtKa
 */





package 
{
    import net.hires.debug.Stats;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite 
    {
        public function FlashTest() 
        {
            stage.frameRate = 60
            addChild(new Stats())
            graphics.beginFill(0x20)                
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight)
            var wire:Shape = addChild(new Shape) as Shape
            var solid:Object = new Object
            solid.verts = new Vector.<Number>
            solid.verts.push(0,1,0,1,0,0,0,0,1,-1,0,0,0,0,-1,0,-1,0)
            solid.indices = new Vector.<int>
            solid.indices.push(0,1,2,0,2,3,0,3,4,0,4,1,5,2,1,5,3,2,5,4,3,5,1,4)
            var drawSolid:Function = function(matrix:Matrix3D,color:uint):void {
                var uvtData:Vector.<Number> = new Vector.<Number>
                var persVerts:Vector.<Number> = new Vector.<Number>
                Utils3D.projectVectors(matrix, solid.verts, persVerts, uvtData)
                persVerts.map(function(item:Number, index:int, vector:Vector.<Number>):void {
                    vector[index] += (index%2==0) ? stage.stageWidth/2 : stage.stageHeight/2
                })
                wire.graphics.lineStyle(0,color)
                wire.graphics.drawTriangles(persVerts, solid.indices, uvtData, 'negative')
            }   
            var radius:int=30        
            var trackCoord:Function = function(theta:Number):Vector3D {
                return  new Vector3D(
                    radius*Math.cos(theta),
                    radius*Math.sin(2*theta),
                    0.1*radius*Math.sin(theta)
                )                
            }
            var markers:Vector.<Vector3D> = new Vector.<Vector3D>
            for(var i:int=0; i<100; i++) {
                markers.push(trackCoord(i/100*2*Math.PI))
            }
            var stars:Vector.<Vector3D> = new Vector.<Vector3D>
            for (i=0; i<200; i++) {
                stars.push(new Vector3D(
                    5*radius*(Math.random()-0.5),
                    5*radius*(Math.random()-0.5),
                    5*radius*(Math.random()-0.5)
                ))
            }
            var pers:PerspectiveProjection = new PerspectiveProjection
            var persMatrix:Matrix3D = pers.toMatrix3D()           
            var theta:Number= 0
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                wire.graphics.clear()                
                var target:Vector3D = trackCoord(theta)
                target.z += 2
                var eye:Vector3D = trackCoord(theta-0.3)
                 eye.z += 5
                var distance:Number = Vector3D.distance(target,eye)         
                var diff:Vector3D = target.subtract(eye)
                var axisVector:Vector3D = Vector3D.Z_AXIS.crossProduct(diff)
                var rotateTheta:Number = -Vector3D.angleBetween(Vector3D.Z_AXIS,diff)*180/Math.PI
                var sceneMatrix:Matrix3D = new Matrix3D
                sceneMatrix.append(persMatrix)
                sceneMatrix.prependRotation(rotateTheta,axisVector)
                sceneMatrix.prependTranslation(-eye.x,-eye.y,-eye.z)                
                var matrix:Matrix3D = new Matrix3D
                var n:int = markers.length
                while (n--) {
                    matrix.identity()
                    matrix.append(sceneMatrix)
                    matrix.prependTranslation(markers[n].x,markers[n].y,markers[n].z)
                    matrix.prependRotation(theta*500,Vector3D.Z_AXIS)
                    if (matrix.transformVector(new Vector3D(0,0,0)).z > distance*0.2) {
                        drawSolid(matrix,0xa00000)
                    }
                }
                n = stars.length
                while (n--) {
                    matrix.identity()
                    matrix.append(sceneMatrix)
                    matrix.prependTranslation(stars[n].x,stars[n].y,stars[n].z)
                    if (matrix.transformVector(new Vector3D(0,0,0)).z > distance*0.2) {
                        drawSolid(matrix,0x707000)
                    }
                }
                matrix.identity()
                matrix.append(sceneMatrix)
                matrix.prependTranslation(target.x,target.y,target.z)
                drawSolid(matrix,0xffffff)
                theta = (theta+0.005) % (2*Math.PI) 
            })
        }
    }
}
