/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bXym
 */

// forked from demouth's クリスマスリース的な何か
package 
{
	import flash.display.*;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.*;
	import flash.sampler.NewObjectSample;
	import flash.utils.getTimer;
	import net.hires.debug.Stats;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
	public class FlashTest extends Sprite
	{
		
		public var numPc:int = 20;
		public var pc:Vector.<Particle> = new Vector.<Particle>();
		public var bitmap:Bitmap = new Bitmap(new BitmapData(465, 465 , true , 0xFFFFFFFF));
		public var shape:Shape = new Shape();
		
		public function FlashTest () 
		{
			super();
			
			if (this.stage) this.init()
			else this.addEventListener(Event.ADDED_TO_STAGE , init);
		}
		
		private function init(event:Event = null):void
		{
			
			this.addChild(this.bitmap);
			this.addChild(new Stats());
			this.shape.filters = [new BlurFilter(10,10,1)];
			
			this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
			
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			
			this.deletePc();
			this.createPc();
			
			this.move();
			this.rendering(this.shape.graphics);
			
			this.bitmap.bitmapData.fillRect(new Rectangle(0, 0, 465, 465), 0xFFFFFFFF);
			var l:int = 8;
			var angle:Number = Math.PI * 2 / l;
			for (var i:int = 0; i < l; i++) 
			{
				this.draw(this.getMatrix(angle * i));
			}
			this.bitmap.bitmapData.threshold(this.bitmap.bitmapData, new Rectangle(0, 0, 465, 465), new Point(0, 0), ">", 0x0000F0F0, 0xFFFFFFFF, 0x00505050, false);
		}
		
		private function draw(matrix:Matrix):void
		{
			this.bitmap.bitmapData.draw(this.shape , matrix);
		}
		
		private function getMatrix(rotate:Number):Matrix
		{
			var mat:Matrix = new Matrix();
			mat.translate(-232, -232);
			mat.rotate(rotate);
			mat.translate(232, 232);
			return mat;
		}
		
		private function rendering(g:Graphics):void
		{
			var g:Graphics = g;
			g.clear();
			
			var l:int = this.pc.length - 1;
			var i:int = 0;
			for (i = 0; i < l; i++) 
			{
				var p:Particle = this.pc[i];
				var radius:Number = ( Math.abs(p.sx) + Math.abs(p.sy) ) * 2 ;
				
				var c:uint = ((getTimer() / 20) % 0x99);
				g.beginFill(c<<16|c<<8|c , 1);
				g.drawCircle(p.x , p.y , radius + 1 );
				g.endFill();
			}
		}
		
		private function move():void
		{
			var l:int = this.pc.length - 1;
			var i:int = 0;
			for (i = 0; i < l; i++) 
			{
				var p:Particle = this.pc[i];
				p.sx += p.ax;
				p.sy += p.ay;
				p.ax = 0;
				p.ay = 0;
				p.x += p.sx;
				p.y += p.sy;
				p.sx *= 0.9;
				p.sy *= 0.9;
				
				if (
					(Math.abs(p.sx) < 2)
					&&
					(Math.abs(p.sy) < 2)
				)
				{
					p.end = true;
				}
			}
		}
		
		private function createPc():void
		{
			var l:int = this.numPc;
			var i:int = 0;
			for (i = this.pc.length; i < l; i++) 
			{
				var p:Particle = new Particle();
				
				var pow:Number = Math.random() * 20;
				var angle:Number = Math.PI * 2 * Math.random();
				var x:Number = Math.sin(angle) * pow;
				var y:Number = Math.cos(angle) * pow;
				
				p.x = this.stage.mouseX;
				p.y = this.stage.mouseY;
				p.ax = x;
				p.ay = y;
				p.sx = 0;
				p.sy = 0;
				
				p.end = false;
				this.pc.push(p);
			}
		}
		
		private function deletePc():void
		{
			var l:int = this.pc.length - 1;
			var i:int = 0;
			for (i = l; i >= 0; i--) 
			{
				var p:Particle = this.pc[i];
				if (p.end)
				{
					this.pc.splice(i, 1);
					p = null;
				}
			}
		}
		
	}

}
class Particle
{
	
	public var x:Number = 0;
	public var y:Number = 0;
	public var ax:Number = 0;
	public var ay:Number = 0;
	public var sx:Number = 0;
	public var sy:Number = 0;
	
	public var end:Boolean = false;
	
}