/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bWaQ
 */

/*
テキストフィールドの内容を、
上：htmlText欄（実体参照、<&>）
中：text欄（プレーン、<&>）
下：encodeURI欄（URLエンコーディング、%3C&%3E）
で表示する。

特別なことは何もしてないけど、ユーティリティとして便利。
昔AS2版を作って重宝してたのに、
ソースを無くしてしまったためWonderflで作り直し。
*/
package {
    import flash.display.Sprite;
    import flash.text.TextFormat;
    import flash.events.MouseEvent;
    import flash.events.*;
    import flash.events.FocusEvent;
    import flash.text.TextField;
    public class Main extends Sprite {
        public function Main() {
            var isKrappo:Boolean = true;
            MakeUI.defaultTextFormat = new TextFormat("_sans", 14);
            
            var HTMLTextField:TextField = MakeUI.newTextField([8,8,stage.stageWidth-16,(stage.stageHeight-8)/3-8],[["htmlText","htmlText欄（実体参照テキストフィールド）"],["border",true],["type","input"],["wordWrap",true],["name","HTMLTextField"],["background",true],["backgroundColor",0xFFDDDD]]);
            stage.addChild(HTMLTextField);
            var PlanedTextField:TextField = MakeUI.newTextField([8,(stage.stageHeight-8)/3+8,stage.stageWidth-16,(stage.stageHeight-8)/3-8,"text欄（プレーンなテキストフィールド）"],[["border",true],["type","input"],["wordWrap",true],["name","PlanedTextField"],["background",true],["backgroundColor",0xDDDDFF]]);
            stage.addChild(PlanedTextField);
            var EncodedTextField:TextField = MakeUI.newTextField([8,2*(stage.stageHeight-8)/3+8,stage.stageWidth-16,(stage.stageHeight-8)/3-8,"encodeURI欄（URLエンコーディングのテキストフィールド）"],[["border",true],["type","input"],["wordWrap",true],["name","EncodedTextField"],["background",true],["backgroundColor",0xDDFFDD]]);
            stage.addChild(EncodedTextField);
            
            
            stage.addEventListener(KeyboardEvent.KEY_UP, KEY_UP);
            function KEY_UP(e:KeyboardEvent):void{
                var str:String;
                var inputedTextFieldName:String = e.target.name;
                if(inputedTextFieldName == "HTMLTextField"){
                    PlanedTextField.htmlText = HTMLTextField.text;
                    EncodedTextField.text = encodeURI(PlanedTextField.text);
                    isKrappo = HTMLTextField.text?false:true;
                }else if(inputedTextFieldName == "PlanedTextField"){
                    str = encodeURI(PlanedTextField.text);
                    if(str){
                        isKrappo = false;
                        EncodedTextField.text = str;
                        str = String(PlanedTextField.htmlText).split(">")[2].substr(0,-6);
                        HTMLTextField.text = str;
                    }else{
                        isKrappo = true;
                        EncodedTextField.text = "";
                        HTMLTextField.text = "";
                    }
                }else if(inputedTextFieldName == "EncodedTextField"){
                    str = decodeURI(EncodedTextField.text);
                    if(str){
                        isKrappo = false;
                        PlanedTextField.text = str;
                        str = String(PlanedTextField.htmlText).split(">")[2].substr(0,-6);
                        HTMLTextField.text = str;
                    }else{
                        isKrappo = true;
                        PlanedTextField.text = "";
                        HTMLTextField.text = "";
                    }
                }
            }
            
            
            //無記入時に記入を誘うための表示
            HTMLTextField.addEventListener(FocusEvent.FOCUS_OUT, FOCUS_OUT);
            PlanedTextField.addEventListener(FocusEvent.FOCUS_OUT, FOCUS_OUT);
            EncodedTextField.addEventListener(FocusEvent.FOCUS_OUT, FOCUS_OUT);
            function FOCUS_OUT(e:FocusEvent):void{
                if(isKrappo){
                    HTMLTextField.text = "htmlText欄（実体参照テキストフィールド）";
                    PlanedTextField.text = "text欄（プレーンなテキストフィールド）";
                    EncodedTextField.text = "encodeURI欄（URLエンコーディングのテキストフィールド）";
                }
            }
            HTMLTextField.addEventListener(FocusEvent.FOCUS_IN, FOCUS_IN);
            PlanedTextField.addEventListener(FocusEvent.FOCUS_IN, FOCUS_IN);
            EncodedTextField.addEventListener(FocusEvent.FOCUS_IN, FOCUS_IN);
            function FOCUS_IN(e:FocusEvent):void{
                if(isKrappo){
                    HTMLTextField.text = "";
                    PlanedTextField.text = "";
                    EncodedTextField.text = "";
                }
            }
            
            
        }
    }
}


/////////////////////////////////////////////////////////////////////////////

import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.BitmapData;
import flash.display.Bitmap;
class MakeUI{
    public static var defaultTextFormat:TextFormat = new TextFormat();
    public static function newShape(x_y_w_h_sh:Array = null,property:Array=null,graphics:Array=null):Shape{
        var i:int;
        var sh:Shape;
        if(x_y_w_h_sh && x_y_w_h_sh[4]){
            sh = x_y_w_h_sh[4];
        }else{
            sh = new Shape();
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[0]) { sh.x = x_y_w_h_sh[0] };
            if (x_y_w_h_sh[1]) { sh.y = x_y_w_h_sh[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sh[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sh.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(x_y_w_h_sh){
            if (x_y_w_h_sh[2]) { sh.width = x_y_w_h_sh[2] };
            if (x_y_w_h_sh[3]) { sh.height = x_y_w_h_sh[3] };
        }
        return sh;
    }
    public static function newSprite(x_y_w_h_sp:Array = null,property:Array=null,graphics:Array=null,addChild:DisplayObject = null):Sprite{
        var i:int;
        var sp:Sprite;
        if(x_y_w_h_sp && x_y_w_h_sp[4]){
            sp = x_y_w_h_sp[4];
        }else{
            sp = new Sprite();
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[0]) { sp.x = x_y_w_h_sp[0] };
            if (x_y_w_h_sp[1]) { sp.y = x_y_w_h_sp[1] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    sp[property[i][0]] = property[i][1];
                }
            }
        }
        if(graphics){
            for (i = 0; i < graphics.length; i++) {
                if(graphics[i] && graphics[i].length > 1){
                    sp.graphics[graphics[i][0]].apply(null, graphics[i][1]);
                }
            }
            
        }
        if(addChild){
            sp.addChild(addChild);
        }
        if(x_y_w_h_sp){
            if (x_y_w_h_sp[2]) { sp.width = x_y_w_h_sp[2] };
            if (x_y_w_h_sp[3]) { sp.height = x_y_w_h_sp[3] };
        }
        return sp;
    }

    public static function newTextField(x_y_w_h_txt_color_alpha:Array = null,property:Array=null,method:Array=null):TextField{
        var i:int;
        var ta:TextField = new TextField();
        ta.defaultTextFormat = defaultTextFormat;
        if(x_y_w_h_txt_color_alpha){
            if (x_y_w_h_txt_color_alpha[0]) { ta.x = x_y_w_h_txt_color_alpha[0] };
            if (x_y_w_h_txt_color_alpha[1]) { ta.y = x_y_w_h_txt_color_alpha[1] };
            if (x_y_w_h_txt_color_alpha[2]) { ta.width = x_y_w_h_txt_color_alpha[2] };
            if (x_y_w_h_txt_color_alpha[3]) { ta.height = x_y_w_h_txt_color_alpha[3] };
            if (x_y_w_h_txt_color_alpha[4]) { ta.text = x_y_w_h_txt_color_alpha[4] };
            if (x_y_w_h_txt_color_alpha[5]) { ta.textColor = x_y_w_h_txt_color_alpha[5] };
            if (x_y_w_h_txt_color_alpha[6]) { ta.alpha = x_y_w_h_txt_color_alpha[6] };
        }
        if(property){
            for (i = 0; i < property.length; i++) {
                if(property[i] && property[i].length > 1){
                    ta[property[i][0]] = property[i][1];
                }
            }
        }
        if(method){
            for (i = 0; i < method.length; i++) {
                if(method[i] && method[i].length > 1){
                    ta[i].apply(null, method[i][1]);
                }
            }
        }
        return ta;
    }
    /*
    //以下はテスト
    public static function pozObject(x:Number=NaN,y:Number=NaN,width:Number=NaN,hight:Number=NaN,obj:Object = null):Object{
        if(x){obj.x = x}
        if(y){obj.y = y}
        return obj;
    }
    public static function newBitmap(x:Number=NaN,y:Number=NaN,width:Number=NaN,hight:Number=NaN,bd:BitmapData = null):Bitmap{
        var b:Bitmap = new Bitmap(bd);
        if(x){b.x = x}
        if(y){b.y = y}
        return b;
    }
    */
}