/**
 * Copyright hacker_qus3vzf3 ( http://wonderfl.net/user/hacker_qus3vzf3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bWQwa
 */

// forked from Saqoosha's Line Wave
// write as3 code here..
package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.geom.Point;
	
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
	
	public class Wave extends Sprite {
		
		private static const ZERO_POINT:Point = new Point();
		
		private static const SCROLL_SPEED:Number = 1.2;
		private static const NOISE_BASE_X:Number = 150;
		private static const NOISE_BASE_Y:Number = 50;
		private static const WAVE_HEIGHT:Number = 40;
		private static const LINE_STEP_X:int = 16;
		private static const LINE_STEP_Y:int = 4;
		
		private var _noise:BitmapData;
		private var _wave:Shape;
		
		private var _scroll:Point = new Point();
		
		public function Wave() {
			this.addEventListener(Event.ADDED_TO_STAGE, this._onAddedToStage);
		}
		
		private function _onAddedToStage(e:Event):void {
			this.stage.quality = StageQuality.LOW;
			
			this._noise = new BitmapData(this.stage.stageWidth, this.stage.stageHeight, false, 0x0);
			this._wave = this.addChild(new Shape()) as Shape;
			
			this.addEventListener(Event.ENTER_FRAME, this._update);
		}
		
		private function _update(e:Event):void {
			this._scroll.x += SCROLL_SPEED;
			this._scroll.y += SCROLL_SPEED;
			this._noise.perlinNoise(NOISE_BASE_X, NOISE_BASE_Y, 2, 123456, true, true, 1, true, [this._scroll]);

			var g:Graphics = this._wave.graphics;
			g.clear();
			g.lineStyle(1, 0xffffff, 0.5);
			
			var px:Number = 0;
			var py:Number = 0;
			g.moveTo(px, py);
			
			while (1) {
				var ly:Number = py + ((this._noise.getPixel(px, py) & 0xff) / 0x80 - 1) * WAVE_HEIGHT;
				if (px == 0) {
					g.moveTo(px, ly);
				} else {
					g.lineTo(px, ly);
				}
				px += LINE_STEP_X;
				if (px >= this._noise.width) {
					px = 0;
					py += LINE_STEP_Y;
					if (py >= this._noise.height) {
						break;
					}
				}
			}
		}
	}
}