/**
 * Copyright autumngoodluck ( http://wonderfl.net/user/autumngoodluck )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bW1E
 */

package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.media.Microphone;
    import flash.media.SoundTransform;
    import flash.utils.Timer;
    
    public class MicTest extends Sprite {
        private var mic:Microphone;
        private var timeLine:int = 0;
        
        public function MicTest() {
            // マイクの初期化
            mic = Microphone.getMicrophone();
            mic.setLoopBack(true);
            mic.gain = 80;
            mic.rate = 11;
            mic.setSilenceLevel(5, 1000);
            
            // ハウリング対策（マイクのボリュームをゼロに設定）
            var trans:SoundTransform = mic.soundTransform;
            trans.volume = 0;
            mic.soundTransform = trans;
            
            // キャンバスの初期化
            initCanvas();

            // タイマイベントを使ってマイクの音量を監視
            var timer:Timer = new Timer(50);
            timer.addEventListener("timer", timerHandler);
            timer.start();
        }
        
        // キャンバスの初期化
        private function initCanvas():void {
            graphics.clear();
            graphics.lineStyle(1, 0x9400D3);
            graphics.moveTo(0, 465 / 2);
        }

        // マイク監視用タイマイベントハンドラ
        private function timerHandler(event:TimerEvent):void {
            graphics.lineTo(timeLine, (465 / 2) - mic.activityLevel);
            if (timeLine > 465) {
                timeLine = 0;
                initCanvas();
            } else {
                timeLine += 2;
            }
        }
    }
}