/**
 * Copyright Kihara ( http://wonderfl.net/user/Kihara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bVOI
 */

/*
シューティングっぽい何か
マウスで微妙に視点が変わります
方向キーで移動、ｚとshiftキーであっちとこっちに行く
ｘで弾が出る
スクリーンを大きくしたほうがいいみたい
*/

package
{

    import caurina.transitions.Tweener;
    
    import fl.transitions.Transition;
    
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.ui.Keyboard;
    
    import frocessing.color.ColorRGB;
    
    import org.flintparticles.common.actions.ColorChange;
    import org.osmf.display.ScaleMode;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.cameras.SpringCamera3D;
    import org.papervision3d.core.clipping.FrustumClipping;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.render.filter.FogFilter;
    import org.papervision3d.core.render.sort.NullSorter;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.special.FogMaterial;
    import org.papervision3d.materials.special.Letter3DMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.render.QuadrantRenderEngine;
    import org.papervision3d.typography.Text3D;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.stats.StatsView;

    [SWF(frameRate="30", width=1000, height=600)]
    public class game2 extends BasicView
    {
        private var bv:BasicView;
        private var plane1:Plane;
        private var plane2:Plane;
        private var paper:PaperPlane;
        private var N:Number=3600;
        private var yk:Number=0, xk:Number=0, cz:Number=-150, rz:Number=0;
        private var p:Plane;
        private var word:Text3D;
        private var default_t:Number=0, tamakazu:Number=0;
        private var array_tama:Vector.<Tama>=new Vector.<Tama>;
        private var upFlag:Boolean, downFlag:Boolean, rightFlag:Boolean, leftFlag:Boolean;
        private var zFlag:Boolean, shiftFlag:Boolean, xFlag:Boolean;
        private var mouse_flag:Boolean=false;
        private const M_tama:Number=64;
        private const T_tama:Number=1024;
        private var count:uint=0;
        private var Shot_t:uint=0;
        
        public function game2()
        {
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            bv=new BasicView(0, 0, true);
            bv.viewport.interactive=true;
            super(0, 0, true, true);
            var stats:StatsView=new StatsView(renderer);
            addChild(stats);
            addChild(bv);

            camera.useCulling = true;
            var fog:FogMaterial=new FogMaterial(0xDDEEFF);
            gamemain();
            menu();
            makeTama();
            renderer.filter=new FogFilter(fog, 5, 1200, 1800);
            //renderer.clipping=new FrustumClipping(FrustumClipping.BOTTOM);
            startRendering();
            stage.addEventListener(KeyboardEvent.KEY_DOWN, key_down);
            stage.addEventListener(KeyboardEvent.KEY_UP, key_up);
            bv.addEventListener(MouseEvent.MOUSE_OVER, mouseup);
            bv.addEventListener(MouseEvent.MOUSE_OUT, outmouse);
            bv.addEventListener(MouseEvent.CLICK, click);
            bv.addEventListener(Event.ENTER_FRAME,menuFrame);
            //addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        public function gamemain():void
        {
            var color:ColorMaterial=new ColorMaterial(0xFAFAFF);
            var wireframe:WireframeMaterial=new WireframeMaterial(0x0044FF);
            var mix:CompositeMaterial=new CompositeMaterial();
            
            mix.addMaterial(wireframe);
            mix.addMaterial(color);
            mix.doubleSided=true;
            wireframe.doubleSided=true;
            color.doubleSided=true;
            plane1=new Plane(wireframe, N, N, 12, 12);
            plane2=new Plane(wireframe, N, N, 12, 12);
            paper=new PaperPlane(mix, 0);
            Init();
            scene.addChild(plane1);
            scene.addChild(plane2);
            scene.addChild(paper);
        }

        public function menu():void
        {
            var fonts:HelveticaBold=new HelveticaBold();
            var mat:Letter3DMaterial=new Letter3DMaterial(0x0000FF, 0.5);
            var pm:ColorMaterial=new ColorMaterial(0x3388FF, 0.5);
            
            pm.interactive=true;
            mat.doubleSided=true;
            pm.doubleSided=true;
            word=new Text3D("START", fonts, mat);
            p=new Plane(pm, 400, 400, 1, 1);
            camera.y = 50;
            bv.scene.addChild(p);
            bv.scene.addChild(word);
            bv.renderer=new QuadrantRenderEngine();
            bv.startRendering();
        }

        public function Init():void
        {
            paper.rotationX=355;
            plane1.rotationX=90;
            plane2.rotationX=90;
            plane1.y=-200;
            plane2.z=N;
            plane2.y=-200;
            upFlag=false;
            downFlag=false;
            rightFlag=false;
            leftFlag=false;
            zFlag=false;
            shiftFlag=false;
            xFlag=false;
        }

        public function outmouse(e:MouseEvent):void
        {
            Tweener.addTween(p, {scaleX: 1, time: 1.0, transition: "easeOutElastic"});
            Tweener.addTween(word, {scaleX: 1, time: 1.0, transition: "easeOutElastic"});
        }

        public function mouseup(e:MouseEvent):void
        {
            Tweener.addTween(p, {scaleX: 2, time: 1.0, transition: "easeOutElastic"});
            Tweener.addTween(word, {scaleX: 2, time: 1.0, transition: "easeOutElastic"});
        }

        public function click(e:MouseEvent):void
        {
            mouse_flag=true;
            default_t=0;
            camera.y=100;
            camera.x=100;
            bv.scene.removeChild(p);
            bv.scene.removeChild(word);
            bv.removeEventListener(Event.ENTER_FRAME,menuFrame);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        public function key_down(e:KeyboardEvent):void
        {
            switch (e.keyCode)
            {
                case Keyboard.UP:
                    upFlag=true;
                    break;
                case Keyboard.DOWN:
                    downFlag=true;
                    break;
                case Keyboard.RIGHT:
                    rz=-45;
                    rightFlag=true;
                    break;
                case Keyboard.LEFT:
                    rz=45;
                    leftFlag=true;
                    break;
                case Keyboard.SHIFT:
                    shiftFlag=true;
                    break;
                case 90: //Z
                    zFlag=true;
                    break;
                case 88: //X
                    xFlag=true;
                    break;
                default:
                    break;
            }
        }

        public function key_up(e:KeyboardEvent):void
        {
            switch (e.keyCode)
            {
                case Keyboard.UP:
                    upFlag=false;
                    break;
                case Keyboard.DOWN:
                    downFlag=false;
                    break;
                case Keyboard.RIGHT:
                    rz=0;
                    rightFlag=false;
                    break;
                case Keyboard.LEFT:
                    rz=0;
                    leftFlag=false;
                    break;
                case Keyboard.SHIFT:
                    shiftFlag=false;
                    break;
                case 90: //Z
                    zFlag=false;
                    break;
                case 88: //X
                    xFlag=false;
                    Shot_t=0;
                    break;
                default:
                    break;
            }
        }

        public function Move():void
        {
            if (upFlag)
            {
                if (paper.y < 500)
                    yk+=10;
            }
            if (downFlag)
            {
                if (paper.y > -100)
                    yk-=10;
            }
            if (rightFlag)
            {
                if (paper.x < 1000)
                    xk+=10;
            }
            if (leftFlag)
            {
                if (paper.x > -1000)
                    xk-=10;
            }
            if (zFlag)
                cz+=10;
            if (shiftFlag)
                cz-=10;
            if (xFlag)
            {
                Shot_t++;
                if (Shot_t % 5 == 0)
                    flagTama();
            }

        }


        public function default_loop():void
        {
            plane1.z-=15;
            plane2.z-=15;
            if (plane1.z < -N)
                plane1.z=plane2.z + N;
            if (plane2.z < -N)
                plane2.z=plane1.z + N;
        }

        public function default_move():void
        {
            var rateX:Number=mouseX / stage.stageWidth;
            var rateY:Number=mouseY / stage.stageHeight;
            var targetX:Number=(-paper.x / 3) + 200 * (rateX - 0.5);
            var targetY:Number=(-paper.y / 3) - 200 * (rateY - 0.5);
            camera.x+=(targetX - camera.x) * 0.3;
            camera.y+=(targetY - camera.y) * 0.3;
            camera.z+=(cz - camera.z) * 0.4;
            
            paper.rotationZ+=(rz - paper.rotationZ) * 0.1;
            paper.y+=(yk - paper.y) * 0.4;
            paper.x+=(xk - paper.x) * 0.4;
        }


        public function makeTama():void
        {
            for (var i:uint=0; i < M_tama; i++)
            {
                var tama:Tama=new Tama(1, false);
                array_tama.push(tama);
            }
        }

        public function flagTama():void
        {
            var k:uint;
            if ((k=searchTama()) != -1)
            {
                scene.addChild(array_tama[k].obj);
                array_tama[k].obj.x=paper.x;
                array_tama[k].obj.y=paper.y;
                array_tama[k].obj.z=paper.z+80;
                array_tama[k].flag=true;
            }

        }

        public function moveTama():void
        {
            for (var i:uint=0; i < array_tama.length; i++)
            {
                if (array_tama[i].flag)
                {
                    array_tama[i].obj.z+=40;
                    if(array_tama[i].obj.z > 1400)
                    array_tama[i].obj.alpha-=0.1;
                    if (array_tama[i].obj.z > 1800)
                    {
                        scene.removeChild(array_tama[i].obj);
                        array_tama[i].flag=false;
                        array_tama[i].obj.alpha=1;
                    }
                }
            }
        }

        public function searchTama():Number
        {
            for (var i:uint=0; i < array_tama.length; i++)
            {
                if (!array_tama[i].flag)
                {
                    return i;
                }
            }
            return -1;
        }

        public function menuFrame(e:Event):void{
            default_t++;
            camera.x=500 * Math.cos(default_t * Math.PI / 180);
            camera.z=500 * Math.sin(default_t * Math.PI / 180);
            word.rotationY+=1;
            word.rotationX+=3;
            word.rotationZ+=2;
            p.rotationX+=2;
            p.rotationZ+=3;
        }
        public function onEnterFrame(e:Event):void
        {
            count++;
            default_loop();
            default_move();
            Move();
            moveTama();
        }
    }
}

import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.filters.DropShadowFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    
    import org.papervision3d.core.effects.BitmapFireEffect;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;

    class Tama extends Sprite
    {
        public var vx:Number,vy:Number,vz:Number,_x:Number,_y:Number,_z:Number;
        public var syurui:Number, flag:Boolean;
        public var obj:DisplayObject3D;
        public function Tama(syurui:Number,flag:Boolean)
        {
            this.flag=flag;
            if(syurui==1)
                syu1();    
        }
        private function syu1():void
        {
            var material:ColorMaterial=new ColorMaterial(0xFFFFFF);
            obj=new Sphere(material,8,4,4);
            obj.useOwnContainer = true;
            obj.filters=[new GlowFilter(0xFFC600,1,10,10,2)];
        }
    }