/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bV0D
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.system.Security;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGTH:int = 465;
        
        private static const WARM_NUM:int = 500;
        
        private var worms:/*Worm*/Array;
        private var wormview:Sprite;
        
        private var image:Image;
        private var bmp:Bitmap;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
       

            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGTH);
            graphics.endFill();
            
            bmp = new Bitmap();
            addChild( bmp );
            image = new Image("http://assets.wonderfl.net/images/related_images/d/d1/d192/d192c263b520f46c3815b03b0bea5421fd8e1d56", LoadedImage );
            
            wormview = new Sprite();
            wormview.visible = false;
            addChild(wormview)
            worms = new Array();
            for ( var i:int = 0; i < WARM_NUM; i++ )
            {
                worms.push( new Worm( Math.random() * WIDTH, Math.random() * HEIGTH ) );
            }
            
        

            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            wormview.graphics.clear();
            for ( var i:int = 0; i < WARM_NUM; i++ )
            {
                worms[i].Move();
                worms[i].Draw( wormview.graphics );
            }
            
        }
        
        public function LoadedImage() : void
        {
            wormview.visible = true;
            bmp.bitmapData = image.image;
            bmp.width = WIDTH;
            bmp.height = HEIGTH;
        }
    }
    
}

import flash.geom.Point;
import flash.display.Graphics;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;
    
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
    
import flash.events.Event;
    
import flash.geom.Matrix;

class Worm
{
    private static const PATH_NUM:int = 5;
    private var path:/*Point*/Array;
    private var target:Point;
    
    private var speed:int;
    
    public function Worm( x:Number, y:Number )
    {
        path = new Array();
        for ( var i:int = 0; i < PATH_NUM; i++ )
        {
            var pos:Point = new Point(x, y);
            path.push( pos );
        }
        
        speed = Math.random() * 5 + 5;
        
        target = new Point();
        target.x = x;
        target.y = y;
        SetTargetPos();
        
        
    }
    
    public function Draw( g:Graphics ) : void
    {
        g.lineStyle( 1, 0x880000 );
        for ( var i:int = 0; i < PATH_NUM; i++ )
        {
            if( i == 0 )    g.moveTo( path[i].x, path[i].y );
            else             g.lineTo( path[i].x, path[i].y );
        }
    }
    
    public function Move() : void
    {
        for ( var i:int = 0; i < PATH_NUM; i++ )
        {
            if ( i == 0 )
            {
                path[i].x += (target.x - path[i].x) / speed;
                path[i].y += (target.y - path[i].y) / speed;
                
                if ( Math.sqrt( (target.x - path[i].x) * (target.x - path[i].x) + (target.y - path[i].y) * (target.y - path[i].y) ) < 0.1 )
                {
                    SetTargetPos();
                }
            }else
            {
                path[i].x += (path[i-1].x - path[i].x) / speed;
                path[i].y += (path[i-1].y - path[i].y) / speed;                
            }
        }
    }
    
    public function SetTargetPos() : void
    {
        var angle:Number = Math.random() * 360;
        var len:Number = Math.random() * 10 + 5;
        var tmpx:Number = target.x + Math.cos( angle * Math.PI / 180 ) * len;
        var tmpy:Number = target.y + Math.sin( angle * Math.PI / 180 ) * len;
                
        if ( tmpx < 0 )    tmpx = 0;
        if ( tmpx >= Main.WIDTH ) tmpx = Main.WIDTH - 1;
        if ( tmpy < 0 ) tmpy = 0;
        if ( tmpy >= Main.HEIGTH ) tmpy = Main.HEIGTH - 1;
        
        target.x = tmpx;
        target.y = tmpy;
    }
}


    
/**
 * イメージ格納クラス
 * @author 
 */
class Image
{
    public static const MAX_W:int = 400;    //    基本サイズ
    public static const MAX_H:int = 300;    //    基本サイズ
    
    public var width:Number = MAX_W;
    public var height:Number = MAX_H;
            
    public    var view:Sprite;
    protected var baseimg:BitmapData;            //元画像データ
    
    private var loader:Loader = null;
    private var loaderinfo:LoaderInfo = null;
    
    private var _loadcallback:Function;
    
    public function Image( path:String, loadcallback:Function = null ) 
    {
         view = new Sprite();
         
         loader = new Loader();
         loaderinfo = loader.contentLoaderInfo;
         loaderinfo.addEventListener( Event.COMPLETE, LoadedImageHandler );             
             loader.load( new URLRequest( path ) );
             
            _loadcallback = loadcallback;
    }
        
    protected function LoadedImageHandler( e:Event ) : void
    {
        loaderinfo.removeEventListener( Event.COMPLETE, LoadedImageHandler );
        
        var scaleX:Number = Math.min( width / loader.width, 1 );
            var scaleY:Number = Math.min( height / loader.height, 1 );
        var scale:Number = ( scaleX < scaleY ) ? scaleX : scaleY;

        width = loader.width * scale;
        height = loader.height * scale;
        
        baseimg = new BitmapData( width, height, true, 0 );
        baseimg.draw( loader, new Matrix(scale, 0, 0, scale, 0, 0) );
        
        loaderinfo = null;
        loader = null;
        
        if ( _loadcallback != null )    _loadcallback();
    }
        
    public function get image():BitmapData { return    baseimg;    }
}

