/**
 * Copyright su8erlemon ( http://wonderfl.net/user/su8erlemon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bUm6
 */

package  {
    import flash.display.Shape;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.display.StageQuality;
    import flash.events.MouseEvent;
    import frocessing.color.ColorHSV;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import frocessing.color.ColorHSL;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.media.Sound;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;
    import flash.media.SoundMixer;
    import flash.media.SoundChannel;
    import flash.system.Security;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]    
    
    public class Main extends MovieClip{

        private const SW:int = 465;
        private const SH:int = 465;
        
        private const SPEED:int = 40;
        
        private var st:Sprite = new Sprite();
        
        private var rl:Number = 0;
        private var rects:Vector.<Shape>;
        private var panels:Vector.<Shape>;
        private var panels_des:Vector.<int>;
        
        private var perse:PerspectiveProjection;
        
        private var ry:int = 0;
        private var rx:int = 0;
        
        private var startTime:Number;
        private var prevBeat:Number;
        
        private var sound:Sound = new Sound();
        
        private var spectBytes:ByteArray = new ByteArray();
        private var spectrum:Vector.<Number> = new Vector.<Number>(512, true);
        private var spectrumAverage:Number = 0.0;
        
        public function Main() {
            Security.loadPolicyFile('http://su8erlemon.com/crossdomain.xml');
            sound.addEventListener(Event.COMPLETE, soundLoadCompleteHandler);
            sound.load(new URLRequest('http://su8erlemon.com/lab/music/music.mp3'));
            
        }
        
        private function soundLoadCompleteHandler(e:Event):void{
            sound.removeEventListener(Event.COMPLETE, soundLoadCompleteHandler);
            init();
        }
        
        private function init():void{
            stage.quality = StageQuality.LOW;
            rects = new Vector.<Shape>(30,true);
            panels = new Vector.<Shape>;
            panels_des = new Vector.<int>;
            
            perse = root.transform.perspectiveProjection;        
            perse.fieldOfView =65;
            
            var r:int=0;
            var wh:int=0;
            var color:ColorHSV
            var col:int = 0
             
            for(var i:int = 0 ;i < 30;i++){
                var rect:Shape = new Shape();
                color = new ColorHSV(Math.random()*360,0.88,0.9);
                rect.graphics.beginFill(color.value,1);
                rect.graphics.drawRect(-50,-50,100,100);
                rect.graphics.endFill();
                
                rect.z = -100 + i*50;
                rects[i] = rect;
            }
            
            for(var k:int = 29;k>=0;k--){
                st.addChild(rects[k]);
            }
            
            st.graphics.beginFill(0x00ff00,0);
            st.graphics.drawRect(-SW/2,-SH/2,465,465);
            st.graphics.endFill();
            st.x = SW/2;
            st.y = SH/2;            
            
            addChild(st);
            
            startTime = getTimer();
            prevBeat = 0.0;
            
            addEventListener(Event.ENTER_FRAME,loop);
            
            var sc:SoundChannel = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
        }
        
        private function soundCompleteHandler(e:Event):void{
            var sc:SoundChannel = e.target as SoundChannel;
            
            sc.removeEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            sc.stop();
            sc = sound.play();
            sc.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
            
            prevBeat = 0.0;
            startTime = getTimer();
        }
        
        private function panelPulse(n:uint):void{
            var rr:int = n + int((spectrumAverage)*2);
            var r:int=0;
            var wh:int=0;
            var color:ColorHSV

            for(var i:int = 0;i<rr;i++){
                    r = 1+Math.random() * 4;
                    wh = r*100;
                    color = new ColorHSV(Math.random()*360,0.9,0.9);
                    
                    ry = (int(Math.random()*10)*120-600)*n/3;
                    rx = (int(Math.random()*10)*100-500)*n/3;
                    
                    var ry_abs:int = ( ry ^ ( ry >> 31 ) ) - ( ry >> 31 );
                    var rx_abs:int = ( rx ^ ( rx >> 31 ) ) - ( rx >> 31 );
                    wh = 400 - (ry_abs+rx_abs)/4;
    
                    panels_des.push(ry);
                    
                    var panel:Shape = new Shape();
                    panel.graphics.beginFill(color.value);
                    panel.graphics.drawRect(-wh/2,-wh,wh,wh);
                    panel.graphics.endFill();
            
                    panels.push(panel);
                    
                    st.addChild(panel);
            
                    panel.y = 2000;
                    panel.x = rx;
                    panel.z = -100;
            }
        }

    
        private function loop(e:Event):void{            
            computeSpectrum();
            
            rl += 0.003;
            
            for(var i:int = 0 ;i < 30;i++){
                rects[i].z += SPEED;
                rects[i].rotationX = rects[i].rotationX*0.3;
                rects[i].rotationY = rects[i].rotationY*0.3;
                rects[i].alpha = -int(rects[i].z/50)*0.1+2.9;
            
                if(rects[i].z > 1400){
                    st.setChildIndex(rects[i],st.numChildren-1);
                    rects[i].z = rects[i].z - 1500;
                    rects[i].alpha = 1;
                    rects[i].rotationX = Math.random()*90;
                    rects[i].rotationY = Math.random()*90;
                }                
            }
            
            var l:Number = panels.length;
            for(var n:int = 0 ;n < l;n++){
                panels[n].z += SPEED;
                var v:Number = panels[n].z/200;
                if(v>1)v=1;
                
                panels[n].y += (panels_des[n] - panels[n].y)/(3-v);
                panels[n].alpha = -int(panels[n].z/50)*0.2+5.8;
            
                if(panels[n].z > 1600){
                    if(st.contains(panels[n])){
                        l = l-1;        
                        st.removeChild(panels[n]);
                        panels.splice(n,1);
                        panels_des.splice(n,1);
                    }
                }
            }
            
            st.rotationY = Math.sin(rl)*20;
            st.rotationX = Math.sin(rl*3)*20;
            
            var interval:uint = ( 60 * 1000)/148;
            var current:Number = getTimer() - startTime;
            var beat:uint = int(current/interval*2);
            
            if(int(beat*0.5) != int(prevBeat*0.5))panelPulse(2);
            if(int(0.125+beat*0.125) != int(0.125+prevBeat*0.125))panelPulse(3);
            if(int(0.125-beat*0.125) != int(0.125-prevBeat*0.125))panelPulse(3);
        
            prevBeat = beat;
        }
        
        private function computeSpectrum():void{
            var bytes:ByteArray = spectBytes;
            bytes.position = 0;
            
            SoundMixer.computeSpectrum(bytes, false);
            
            var total:Number = 0;
            var plus:Number = 0;
            var pc:uint = 0;
            var minus:Number = 0;
            var mc:uint = 0;
            var numbers:Vector.<Number> = spectrum;
            for (var i:uint = 0; i < 512; ++i) {
                var n:Number = bytes.readFloat() * 2.0;
                total += Math.abs(n);
                if (n > 0) {
                    plus += n;
                    ++pc;
                }
                else if (n < 0) {
                    minus += n;
                    ++mc;
                }
                numbers[i] = n;
            }
            spectrumAverage = total / 512.0;
        }
    }
}