/**
 * Copyright CatHobo ( http://wonderfl.net/user/CatHobo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bUSC
 */

package {
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    public class Main extends Sprite {
        private static var stage:Stage;
        public static function get GetStage():Stage{
            return Main.stage;
        }
        public function Main():void {
            Main.stage=this.stage;
             //Make a static variable of stage
             //so that other classes can access it
             //such as "addChild()" Display Objects to stage.
            new GetCircle();
                //Initialize three points and circle.
                //No need to refer to the object using "=".
        }
    }
}

import mx.utils.StringUtil;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.display.Shape;

final class GetCircle{
    private var PointObjects:Vector.<MovablePoint>=
        new Vector.<MovablePoint>();
        //Pushing three MovablePoint objects to make a circle.
    private var TheCircle:Shape=new Shape();
    private var new_x:Number=0;
    private var new_y:Number=0;
    private var new_r:Number=0;
    private function RandRange0To(MaxNum:Number):Number{
        return Math.random()*MaxNum;
    }
    public function GetCircle():void{
        var StageWidth:Number=Main.GetStage.stageWidth;
        var StageHeight:Number=Main.GetStage.stageHeight;
        PointObjects.push(
            new MovablePoint(RandRange0To(StageWidth),RandRange0To(StageHeight),0xFF0000),
            new MovablePoint(RandRange0To(StageWidth),RandRange0To(StageHeight),0x00FF00),
            new MovablePoint(RandRange0To(StageWidth),RandRange0To(StageHeight),0x0000FF)
        );
        //MovablePoint objects in random positions.
        
        radius_tf.height=20; //So text doesn't get in the way sometimes.
        radius_tf.autoSize=TextFieldAutoSize.LEFT;
            //So text will autosize by width.
        output_tf.height=20;
        output_tf.autoSize=TextFieldAutoSize.LEFT;
        
        radius_tf.selectable=false;
        output_tf.selectable=false;
        
        Main.GetStage.addChildAt(radius_tf,0);
        Main.GetStage.addChildAt(output_tf,0);
            //At index 0 so that points can be dragged near textfield.
            
        Main.GetStage.addChild(TheCircle);   
        Main.GetStage.addEventListener(CustomEvent.DISPATCHED,
            CalculateNewCoordinates);
            //Whenever a point was moved, calculate
            //the new coordinates of the circle.
        Main.GetStage.dispatchEvent(new CustomEvent());
            //Initialize drawing the circle and radius point.
    }
    private var radius_tf:TextField=new TextField();
        //Prints the radius point's coordinates.
    private function UpdateGraphics(x:Number,y:Number,r:Number,
    old_x:Number=0,old_y:Number=0):void{
        TheCircle.graphics.clear();
        
        TheCircle.graphics.lineStyle(1,0x000000);
        TheCircle.graphics.drawCircle(x,y,r);
        TheCircle.graphics.lineStyle(1,0x000000);
        //Circle graphic
        
        TheCircle.graphics.beginFill(0x000000);
        TheCircle.graphics.drawCircle(x,y,5);
        TheCircle.graphics.endFill();
        //Radius point graphic
        
        TheCircle.graphics.lineStyle(1,0x000000);
        TheCircle.graphics.drawCircle(old_x,old_y,2);
        //"old coordinates of a dragged point" graphic
        
        radius_tf.x=x-25;
        radius_tf.y=y+5;
        radius_tf.text=StringUtil.substitute(
        "Radius Point: (x={0},y={1})",x.toFixed(3),y.toFixed(3));
    }
    private var output_tf:TextField=new TextField();
    private var PrintOldNewCoords:Boolean=false;
    private function CalculateNewCoordinates(e:CustomEvent):void{
        //In http://www.regentsprep.org/Regents/math/geometry/GCG6/RCir.htm
        //and http://www.qc.edu.hk/math/Advanced%20Level/circle%20given%203%20points.htm
        //used their formulas to calculate x,y, and r.
        var slope1:Number=(PointObjects[1].y-PointObjects[0].y)/
        (PointObjects[1].x-PointObjects[0].x);
        var slope2:Number=(PointObjects[2].y-PointObjects[1].y)/
        (PointObjects[2].x-PointObjects[1].x);

        new_x=(slope1*slope2*(PointObjects[2].y-PointObjects[0].y)+
        slope1*(PointObjects[2].x+PointObjects[1].x)-
        slope2*(PointObjects[0].x+PointObjects[1].x))/
        (2*(slope1-slope2));
        
        new_y=(-1/slope1)*
        (new_x-(PointObjects[0].x+PointObjects[1].x)/2)+
        (PointObjects[0].y+PointObjects[1].y)/2
        
        new_r=Math.sqrt(Math.pow(PointObjects[0].x-new_x,2)+
        Math.pow(PointObjects[0].y-new_y,2));
        //Get the radius by the magnitude of the radius point
        //and the point that we have moved.
        
        UpdateGraphics(new_x,new_y,new_r,e.old_x,e.old_y);
        if(PrintOldNewCoords){
            output_tf.text=StringUtil.substitute(
            "Moved one point from (x={0},y={1}) to (x={2},y={3})",
            e.old_x,e.old_y,e.new_x,e.new_y);
        }else{
            output_tf.y=Main.GetStage.stageHeight-60;
            output_tf.text="Using three points to create a circle. Drag any colored points to create a new circle.";    
        }
        output_tf.appendText(StringUtil.substitute(
            "\nColored points share radius of length {0}.",new_r.toFixed(3)
        ));
        if(radius_tf.x+25>Main.GetStage.stageWidth+10||
            radius_tf.y-5>Main.GetStage.stageHeight+10||
            radius_tf.x+25<-10||
            radius_tf.y-5<-20){
            output_tf.appendText(StringUtil.substitute(
                "\nRadius point is out of bounds. Radius Point: (x={0},y={1})",
            new_x.toFixed(3),new_y.toFixed(3)
            ));
        }
        PrintOldNewCoords=true;       
    }
}

//CustomEvent for the purpose of dispatching to
//a GetCircle object and returns old/new coordinates of
//a moved point.
import flash.events.Event;
final class CustomEvent extends Event{
    public static const DISPATCHED:String="DispatchCustomEvent";
    private static var _x:Number=0;
    private static var _y:Number=0;
    private static var _old_x:Number=0;
    private static var _old_y:Number=0;
    public function get new_x():Number{return _x;}
    public function get new_y():Number{return _y;}
    public function get old_x():Number{return _old_x;}
    public function get old_y():Number{return _old_y;}
    public function CustomEvent(old_x:Number=-10,old_y:Number=-10,
    moved_x:Number=0,moved_y:Number=0):void{
        _x=moved_x;
        _y=moved_y;
        _old_x=old_x;
        _old_y=old_y;
        super(CustomEvent.DISPATCHED);
          //Tell GetCircle object to listen to this string
          //from CustomEvent.DISPATCHED ("DispatchCustomEvent")
    }
    public override function clone():Event 
    { 
        return new CustomEvent(); 
    }
}

import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import mx.utils.StringUtil;
final class MovablePoint extends Sprite{
    //Sprite as point/"container" for TextField.
    //object "this" as container.
    private var T:TextField=new TextField();
    private static const MIN_x:int=-50;
    private static const MAX_x:int=-20;
    private static var OldStageX:Number=0;
    private static var OldStageY:Number=0;
    public function MovablePoint(init_x:Number=0,init_y:Number=0,init_fill:uint=0x000000):void{
        T.height=20; //So text doesn't get in the way sometimes.
        T.autoSize=TextFieldAutoSize.LEFT;
           //So text will autosize by width.
        T.x=MIN_x; 
        T.y=10; //Textfield coordinates relative to "container".
        T.selectable=false;
        T.textColor=init_fill;
        this.x=init_x;
        this.y=init_y;
        PrintCoords();
        this.graphics.lineStyle(1,0x000000);
        this.graphics.beginFill(init_fill);
        this.graphics.drawCircle(0,0,5);
        this.buttonMode=true;
        this.addChild(T);
        Main.GetStage.addChild(this);
        this.addEventListener(MouseEvent.MOUSE_DOWN,DragRoutine);
        this.addEventListener(MouseEvent.MOUSE_UP,EndDragRoutine);
        this.addEventListener(Event.ENTER_FRAME,PrintCoords);
           //Update coordinates every frame.
    }
    private var Reverse:Boolean=false;
    private function PrintCoords(e:Event=null):void{
        T.text=StringUtil.substitute("(x={0},y={1})",this.x,this.y);
        switch(Reverse){
            //Animation that moves the text for no reason.
            case true:
                Reverse=(--T.x>=MIN_x)?true:false
                break;
            default:
                Reverse=(++T.x<=MAX_x)?false:true
        }
    }
    
    private function DragRoutine(e:MouseEvent):void{
        OldStageX=this.x;
        OldStageY=this.y;
        this.startDrag(true);
        this.addChild(T);
           //Move object forward.
    }
    private function EndDragRoutine(e:MouseEvent):void{
        this.stopDrag();
        Main.GetStage.dispatchEvent(new CustomEvent(
        OldStageX,OldStageY,e.stageX,e.stageY));
         //Tells the GetCircle object to do math and to
         //send old/new coordinates using main's stage to listen to.
    }
}