/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bTpS
 */

package {
    import flash.filters.*;
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
        private var _tf:TextField = new TextField();
        
        private var cards:Vector.<AlgoCard> = new Vector.<AlgoCard>(24);
        private var myHand:Hand = new Hand(true);
        private var comHand:Hand = new Hand(false);
        private var numSelector:NumSelector = new NumSelector();
        
        private var currentTurn:int;
        private var canSelect:Boolean;
        
        private var selectedCard:AlgoCard;
        private var cardDrawnJustNow:AlgoCard;
        
        public function FlashTest() {
            // write as3 code here. 
            addChild(new BackGround());          
            
            
            addChild1(myHand, stage.stageWidth/2 - myHand.width/2, 320);
            comHand.rotation = 180;
            addChild1(comHand, stage.stageWidth/2 + comHand.width/2, 180);
            
            _tf.width = 100; _tf.height = 465;
            addChild(_tf);
            
            var i:int = 24;
            while(i--){
                cards[i] = new AlgoCard(i,tr);
                cards[i].addEventListener(MouseEvent.CLICK,onCardSelected);
            }
            //debug();
            start();
        }
        
        private function debug():void{
            addChild(cards[13]);
            myHand.push(cards[11]);
            myHand.push(cards[18]);
            myHand.push(cards[12]);
            comHand.push(cards[20]);

            tr((myHand.getChildAt(1) as AlgoCard).id);
        }
        
        private function start():void{
            shuffle();
            currentTurn = 0;
            tsumo(true);
            tsumo(false);
            tsumo(true);
            tsumo(false);
            sleep(1000, function():void{
                tr("a");
                if(int(Math.random() * 2) == 0)myTurn();
                else comTurn();
            });
        }
        
        private function myTurn():void{
            tr("あなたのターンです");
            tsumo(true);
            canSelect = true;
        }
        
        private function comTurn():void{
            tr("COMのターンです");
            tsumo(false);
            var hand:Array = [];
            var l:int = myHand.numChildren;
            for(var i:int = 0; i < l; i++){
                var c:AlgoCard = myHand.getChildAt(i) as AlgoCard;
                if(c.isOpen)hand[i] = c.id;
                else {
                    if(c.isWhite)hand[i] = -1;
                    else hand[i] = -2;
                }
            }
            var selection:Array = COM.think(hand);//[何番目のカードが, 何(id)]
            selectedCard = myHand.getChildAt(selection[0]) as AlgoCard;
            attack(selection[1]);
        }


        
        private function tsumo(me:Boolean):void{
            if(currentTurn >= 22)return;
            tr("カードをドロー");
            var target:Hand;
            if(me == true)target = myHand;
            else target = comHand;
            var c:AlgoCard = cards[currentTurn++];
            cardDrawnJustNow = c;
            target.push(c);
        }

        
        private function shuffle():void{
            var l:int = cards.length;
            while(l){
                var m:int = int(Math.random()*l);
                var n:* = cards[--l];
                cards[l] = cards[m];
                cards[m] = n;
            }
        }


        
        private function onNumberSelected(e:NumSelectEvent):void{
            canSelect = false;
            fadeOut(numSelector);
            numSelector.removeEventListener("numberSelect", onNumberSelected);
            attack(e.data);
        }
        
        private function attack(num:int):void{
            var myTurnNow:Boolean = !selectedCard.my;
            var correct:Boolean = (num == selectedCard.number);
            if(myTurnNow){
                tr(comHand.getChildIndex(selectedCard) + "番目を" + num + "と予想");
                if(correct){
                    tr("正解です");
                    selectedCard.uragaesi();                    
                }
                else{
                    tr("はずれ");
                    cardDrawnJustNow.uragaesi();
                }
                comTurn();
            }
            else {
                tr(myHand.getChildIndex(selectedCard) + "番目を" + num + "と予想");
                if(correct){
                    tr("COMが正解しました");
                    selectedCard.uragaesi();
                }
                else{
                    tr("COMが外しました");
                    cardDrawnJustNow.uragaesi();
                }
                myTurn();
            }


        }


        
        private function onCardSelected(e:Event):void{
            var target:AlgoCard = e.target as AlgoCard;
            if(canSelect && !target.isOpen){
                selectedCard = target;
                numSelector.x = this.mouseX;
                numSelector.y = this.mouseY;
                numSelector.addEventListener("numberSelect",onNumberSelected);
                fadeIn(numSelector);
            }
        }
        
        private function fadeIn(d:DisplayObject):void{
            d.alpha = 0;
            addChild(d);
            d.addEventListener(Event.ENTER_FRAME,function():void{
                d.alpha += 0.1;
                if(d.alpha >= 1.0)d.removeEventListener(Event.ENTER_FRAME,arguments.callee);
            });

        }
        
        private function fadeOut(d:DisplayObject):void{
            d.alpha = 1;
            d.addEventListener(Event.ENTER_FRAME,function():void{
                d.alpha -= 0.1;
                if(d.alpha <= 0){
                    d.removeEventListener(Event.ENTER_FRAME,arguments.callee);
                    removeChild(d);
                }
            });

        }
        
        private function sleep(time:int, func:Function = null):void{
            if(func != null){
                var timer:Timer = new Timer(time,1);
                timer.addEventListener(TimerEvent.TIMER,function():void{timer.removeEventListener(TimerEvent.TIMER,arguments.callee);func();});
                timer.start();
            }
        }


        private function addChild1(d:DisplayObject, x:Number, y:Number):void{
            d.x = x;
            d.y = y;
            addChild(d);
        }
        
        private function tr(...o):void{
            _tf.appendText(o + "\n");
            _tf.scrollV = _tf.maxScrollV;
        }

    }
}
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.*;
import flash.text.*;
import flash.display.*;
import caurina.transitions.Tweener;

class COM{
    public static function think(myHand:Array):Array{
        return [0,0];
    }
}


class AlgoCard extends Sprite{
    private var _bmp:Bitmap;
    private var _id:int;
    public var my:Boolean = true;
    
    public function get id():int{return this._id;}
    public function get number():int{return int(this._id / 2);}
    public function get isWhite():Boolean{return Boolean(_id % 2)};
    
    private var tr:Function;
    
    public function get isOpen():Boolean{
        if(!this.my)return this._bmp.visible;
        return this.filters == [new DropShadowFilter(), new ColorMatrixFilter([1,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,1,0])];
    }
    
    function AlgoCard(arg:int, tr:Function){
        this.tr = tr; 
        this._id = arg;

        var g:Graphics = this.graphics;
        g.beginFill(0xffffff * int(isWhite));
        g.drawRoundRect(0,0,50,70,10);
        g.endFill();
        var fmt:TextFormat = new TextFormat("Osaka",50,0xffffff * int(!isWhite));
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.autoSize = "left";
        tf.text = String(number);
        var bmpdata:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        bmpdata.draw(tf);
        _bmp = new Bitmap(bmpdata);
        _bmp.x = this.width / 2 - _bmp.width / 2;
        _bmp.y = this.height / 2 - _bmp.height / 2;
        addChild(_bmp);
        this.filters = [new DropShadowFilter()];
    }
    
    public function uragaesi():void{
        if(!this.my)this._bmp.visible = !this._bmp.visible;
        else this.filters = [new DropShadowFilter(), new ColorMatrixFilter([1,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,1,0])];
    }

}

class Hand extends Sprite{
    private var _my:Boolean;
    
    function Hand(my:Boolean){
        this._my = my;
        var g:Graphics = this.graphics;
        g.beginFill(0x88ff88);
        g.drawRect(0,0,400,70);
        g.endFill();
    }
    
    public function push(d:AlgoCard):void{
        if(!this._my){
            d.my = false;
            d.uragaesi();
        }
        for(var i:int = 0; i < numChildren; i++){
            if((getChildAt(i) as AlgoCard).id > d.id)break;
        }
        addChildAt(d,i);
        draw();
    }
    
    private function draw():void{
        var l:int = numChildren;
        for(var i:int = 0; i < l; i++){
            Tweener.addTween(this.getChildAt(i), {x: width / 2 + (i - l / 2) * 50, time:0.8});
        }

    }
}

class NumSelector extends Sprite{
    function NumSelector():void{
        var g:Graphics = this.graphics;
        g.lineStyle(3,0x007929);
        g.beginFill(0xaaff88);
        g.drawRoundRect(-50,0,100,120,10);
        g.endFill();
        this.filters = [new DropShadowFilter()];
        this.name = "body";
        
        var n:Vector.<NumButton> = new Vector.<NumButton>(12);
        for(var i:int = 0; i < 12; i++){
            n[i] = new NumButton(i);
            addChild1(n[i],-42 + 30 * (i % 3),6 + 28 * int(i / 3));
            n[i].addEventListener(MouseEvent.CLICK,onButtonClicked);
        }
        addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
    }
    
    private function addChild1(d:DisplayObject,x:Number, y:Number):void{
        d.x = x;
        d.y = y;
        addChild(d);
        
    }
    
    private function onButtonClicked(e:MouseEvent):void{
        dispatchEvent(new NumSelectEvent("numberSelect",(e.target as NumButton).number));
    }

    
    private function onMouseDown(e:MouseEvent):void{
        if(e.target.name != "body") return;
        removeEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        startDrag();
        addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
    }
    
    private function onMouseUp(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stopDrag();
        addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
    }



}

class NumSelectEvent extends Event{
    public var data:int; 
    function NumSelectEvent(type:String,num:int){
        super(type);
        this.data = num;
    }

}


class NumButton extends Sprite{
    
    private var _number:int;
    private var _bmp:Bitmap;
    
    public function get number():int{return _number;}
    
    function NumButton(number:int){
        _number = number;
        var g:Graphics = this.graphics;
        g.lineStyle(2,0x007536);
        g.beginFill(0x38e156);
        g.drawRoundRect(0,0,25,25,10);
        g.endFill();
        var fmt:TextFormat = new TextFormat("MSGothic",28,0x002222);
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.autoSize = "left";
        tf.text = String(number);
        var bmpdata:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        bmpdata.draw(tf);
        _bmp = new Bitmap(bmpdata);
        _bmp.x = this.width / 2 - _bmp.width / 2;
        _bmp.y = this.height / 2 - _bmp.height / 2;
        addChild(_bmp);
        addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
    }
    
    private function onMouseOver(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
        this.filters = [new GlowFilter()];
        addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
    }
    private function onMouseOut(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
        this.filters = [];
        addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
    }


}


class BackGround extends Shape{
    function BackGround(){
        var g:Graphics = this.graphics;
        g.beginFill(0xaaffaa);
        g.drawRect(0,0,465,465);
        g.endFill();
    }
}

