/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bS0D
 */

//
//
//
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	
	/**
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		private var _canvas:BitmapData;
		private var lines:Array = new Array();
		private static const LINE_NUM:int = 50;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			_canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x00000000);
			addChild(new Bitmap(_canvas));
			
			for ( var i:int = 0; i < LINE_NUM; i++ )	lines.push( new LineObj(_canvas) );
			
			addEventListener( Event.ENTER_FRAME, EnterFrame );
		}
		
		private	function EnterFrame(e:Event):void 
		{
			var i:int = 0;
			var filter:BlurFilter = new BlurFilter();
			var color:ColorTransform = new ColorTransform(0.9, 1, 1, 1, 0, 0, 0, 0);
			_canvas.applyFilter( _canvas, _canvas.rect, new Point(0, 0), filter );
			_canvas.draw( _canvas, null, color );
			_canvas.lock();
			for ( i = 0; i < lines.length; i++ )
			{
				lines[i].Update();
				lines[i].Draw();
			}
			_canvas.unlock();
		}
		
		
	}
	
}
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.BlendMode;
import flash.geom.ColorTransform;

class LineObj extends Shape{
	
	private var posX:int;
	private var posY:int;
	private var length:int;
	private var lengthMax:int;
	private var angle:Number;
	private var radians:Number;
	private var color:int;
	
	private var _canvas:BitmapData = null;
		
	public	function LineObj(__canvas:BitmapData = null) 
	{
		_canvas = __canvas;
		Set();
	}
	public	function Set():void 
	{
		if ( !_canvas ) return;
		
		posX = Math.random() * _canvas.width;
		posY = Math.random() * _canvas.height;
		angle = Math.random() * 360;
		radians = angle * Math.PI / 180;
		length = 0;
		lengthMax = int(Math.random() * 100) + 50;
		
		color = int(Math.random() * 3);
	}
	public	function Update():void 
	{
		length += 8;
		if ( length >= lengthMax )	Set();
	}
	public	function Draw():void
	{
		graphics.clear();
		if ( color == 0 )	graphics.lineStyle(1, 0xFFFFFF);
		if ( color == 1 )	graphics.lineStyle(1, 0xFFFF00);
		if ( color == 2 )	graphics.lineStyle(1, 0xAAFFFF);
		graphics.moveTo(posX, posY);
		graphics.lineTo(posX + Math.cos( radians ) * length, posY + Math.sin( radians ) * length);
		
		_canvas.draw( this, null, null, null, null, false );
	}
		
}