/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bQtb
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private const NUM:uint = 8;
		private const PADDING:Number = 25;
		
        public function FlashTest() {
			this.graphics.beginFill(0x000000);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			var count:uint = 0;
			var frame:uint = 0;
			
			var array:Array = new Array();
			for (var index:uint = 0; index < NUM; ++index) {
				var rad:Number = -(index / NUM) * Math.PI * 2;
				var deg:Number = rad / (Math.PI * 2) * 360;
				
				var seg:Segment = new Segment(calcColor(index));
				seg.x = 232.5 + (PADDING * Math.cos(rad));
				seg.y = 232.5 + (PADDING * Math.sin(rad));
				seg.rotationZ = deg;
				
				this.addChild(seg);
				array.push(seg);
			}
			
			var proc:Function = function(e:Event):void {
				++frame;
				if (frame >= 2) {
					frame = 0;
					++count;
					if (count >= NUM) count = 0;
					
					for (var i:uint = 0; i < NUM; ++i) {
						array[i].setColor(calcColor((count + i) % NUM));
					}
				}
			}
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function calcColor(index:uint):uint {
			var white:uint = 255 - (index * 16);
			return (white << 16) + (white << 8) + (white << 0);
		}
    }
}

import flash.display.Sprite;
class Segment extends Sprite {
	private const LENGTH:Number = 35;
	private const WIDTH:Number = 12;
	
	public function Segment(color:uint) {
		draw(color);
	}
	
	public function setColor(color:uint):void {
		draw(color);
	}
	
	private function draw(color:uint):void {
		this.graphics.clear();
		this.graphics.beginFill(color);
		this.graphics.drawCircle(0, 0, WIDTH * 0.5);
		this.graphics.endFill();
		this.graphics.beginFill(color);
		this.graphics.drawRect(0, -WIDTH * 0.5, LENGTH, WIDTH);
		this.graphics.endFill();
		this.graphics.beginFill(color);
		this.graphics.drawCircle(LENGTH, 0, WIDTH * 0.5);
		this.graphics.endFill();
	}
}