/**
 * Copyright hankuro ( http://wonderfl.net/user/hankuro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bQq5
 */

package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.Timer;
	import flash.geom.*;
	import caurina.transitions.*;
	
	[SWF(width=520, height=320, backgroundColor=0x000000)]
	
	/**
	 * 
	 * Tweenerを使ったEFFECTを作ってみました。
	 * 
	 */
	public class Main extends Sprite 
	{

		public var check_sw:Array;
		public var cut_image:Array
		public var image_set_point:Array;
		public var bb:Bitmap
		public var w_rotation:Number = 20;
		public var load_cnt:Number = 0;
		public var cat:Loader = new Loader();
		public var dog:Loader = new Loader();
		public var w_num:Number = 0;
		public var h_num:Number = 0;
		public var i_width:Number = 500;
		public var i_height:Number = 330;
		public var w:Number = 10;
		public var h:Number = 10;
		public var start:Sprite = new Sprite();
		public var timer:Timer;
		public var bmp:Bitmap; 
		public var bmp_data:BitmapData 
		
		public var cat_url:URLRequest = new URLRequest("http://farm3.static.flickr.com/2479/3929725395_c9f6927f86.jpg");
		public var dog_url:URLRequest = new URLRequest("http://farm3.static.flickr.com/2590/3929637189_eecf1e100e.jpg");
		
		public function Main() {
			var context : LoaderContext = new LoaderContext(true);
			cat.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
			cat.load(cat_url, context);
			dog.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
			dog.load(dog_url,context);
		}
		public function onImageLoaded(event:Event):void {
			load_cnt++; 
			if (load_cnt != 2) return;
			bmp = Tools.Cut_image(cat, 0, 0, i_width, i_height);
			bmp.x = bmp.y = 10;
			bmp.visible = false;
			this.addChild(bmp);
			var dog_bmp:Bitmap = Tools.Cut_image(dog, 0, 0, i_width, i_height);
			bmp_data = new BitmapData(dog_bmp.width, dog_bmp.height);
			bmp_data.draw(dog_bmp);
			start.graphics.beginFill(0xFFFFFF, 0.5);
			start.graphics.moveTo(0, 0);
			start.graphics.lineTo(0, 30);
			start.graphics.lineTo(30, 15);
			start.graphics.lineTo(0, 0);
			start.graphics.endFill();
			start.x = 240;
			start.y = 150;
			addChild(start);
			start.addEventListener(MouseEvent.CLICK, onClick);
			start.buttonMode = true;
		}
		public function onClick(evt:MouseEvent):void {
			removeEventListener(MouseEvent.CLICK, onClick);
			start.visible = false;
			effct_start();
		}
		public function effct_start():void {			
			cut_image = Tools.Image_cut(bmp_data, 0, 0, w, h);
			image_set_point = new Array(cut_image.length);
			for (var i:Number = 0; i < cut_image.length; i++) {
				image_set_point[i] = new Array(cut_image[i].length);
				for (var n:Number = 0; n < cut_image[i].length; n++) {
					cut_image[i][n].x = -500;
					cut_image[i][n].y = -500;
					this.addChild(cut_image[i][n]);
					image_set_point[i][n] = new Point();
					image_set_point[i][n].x = i * w + 10;
					image_set_point[i][n].y = n * h + 10;
				}
			}
			timer = new Timer(1);
			timer.addEventListener(TimerEvent.TIMER, onTimer);
			timer.start();
		}		
		public function onTimer(eve:TimerEvent):void {
			if (w_num < cut_image.length) {
				if (h_num < cut_image[w_num].length) {					
					Tweener.addTween(cut_image[w_num][h_num], {x:image_set_point[w_num][h_num].x, y:image_set_point[w_num][h_num].y, transition:"easeOutElastic", time:1} );	
					h_num++;
				}else {
					h_num=0;
					w_num++;
				}
			}else {
				timer.removeEventListener(TimerEvent.TIMER, onTimer);
				timer = new Timer(2000);
				timer.addEventListener(TimerEvent.TIMER, onTimer2);
				timer.start();
			}
		}
		public function onTimer2(eve:TimerEvent):void {
			timer.removeEventListener(TimerEvent.TIMER, onTimer2);
			bmp.visible = true;
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		public function onLoop(evt:Event):void {
			var s:Sprite;
			var find_sw:Boolean = false;
			for (var i:Number = 0; i < cut_image.length; i++) {
				for (var n:Number = 0; n < cut_image[i].length; n++) {
					cut_image[i][n].alpha -= 0.05;
					var myMatrix:Matrix = cut_image[i][n].transform.matrix;
					Tools.rotateAroundInternalPoint(myMatrix, cut_image[i][n].width/2, cut_image[i][n].height/2, 50);
					cut_image[i][n].transform.matrix = myMatrix;
					if (cut_image[i][n].alpha < 0.01) {
						removeChild(cut_image[i][n]);						
						if (i + 1 == cut_image.length && n + 1 == cut_image[i].length) {
							removeEventListener(Event.ENTER_FRAME, onLoop);
							timer = new Timer(33);
							timer.addEventListener(TimerEvent.TIMER, onTimer3);
							timer.start();
							bmp.alpha -= 0.01;
						}
					}			
				}
			}
		}
		public function onTimer3(eve:TimerEvent):void {
			if(bmp.alpha < 0.01){
				timer.removeEventListener(TimerEvent.TIMER, onTimer3);
				bmp.visible = false;
				bmp.alpha = 1;
				start.visible = true;
				w_num = h_num = 0;
				start.addEventListener(MouseEvent.CLICK, onClick);
			}else {
				bmp.alpha -= 0.01;
			}
		}
	}
	
}
	import flash.display.*;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.geom.Matrix;
	
	/**
	 * ...
	 * @author ...
	 */
	class Tools 
	{
		
		public static function Image_cut(b_map:BitmapData,xx:Number, yy:Number, w:Number, h:Number):Array {
			trace("xx : "+xx+" yy : "+yy+" w : "+w+" h : "+h+" b_map.width : "+b_map.width+" b_map.height : "+b_map.height);
			var rect:Rectangle;
			var m_bitmap:Bitmap;
			var cut_image:Array = new Array(int((b_map.width + (w - 1)) /w));
//			trace("cut_image.length " + cut_image.length);
			for (var i:Number = 0; i < cut_image.length; i++) {
				cut_image[i] = new Array(int((b_map.height + (h - 1)) / h));
//				trace("cut_image["+i+"].length " + cut_image[i].length);
			}
			var copy_w:Number;
			var copy_h:Number;
			for (var n:Number = 0; n < cut_image.length; n++) {
				for (var nn:Number = 0; nn < cut_image[n].length; nn++) {
					if (n + 1 != cut_image.length) copy_w = w;
					else if (int(b_map.width % w) == 0)  copy_w = w;	
						else copy_w = int(b_map.width % w);
					if (nn + 1 != cut_image[n].length) copy_h = h;
					else if(int( b_map.height % h) == 0) copy_h = h;
						 else copy_h = int(b_map.height % h);
					var penguinCopyBmd:BitmapData = new BitmapData(copy_w,copy_h);
					rect = new Rectangle(n*w, nn*h, copy_w, copy_h);
					penguinCopyBmd.copyPixels(b_map, rect, new Point());
					var bmp:Bitmap = new Bitmap(penguinCopyBmd);						
					cut_image[n][nn] = new Bitmap(bmp.bitmapData.clone());
				}
			}
			return cut_image;
		}
		public static function Cut_image(l:Loader,xx:Number,yy:Number,w:Number,h:Number):Bitmap {
			var bit_data:BitmapData = new BitmapData(l.width,l.height);
			var bmp:Bitmap = Bitmap(l.content); 
			bit_data.draw(bmp);
			var rect:Rectangle = new Rectangle(xx, yy, w, h);
			var penguinCopyBmd:BitmapData = new BitmapData(w,h);
			penguinCopyBmd.copyPixels(bit_data, rect, new Point());
			var c_bmp:Bitmap = new Bitmap(penguinCopyBmd);
			bmp = new Bitmap(c_bmp.bitmapData.clone());
			return bmp;
		}
		public static function rotateAroundInternalPoint(m:Matrix, x:Number, y:Number, angleDegrees:Number):void
		{
			var point:Point = new Point(x, y);
			point = m.transformPoint(point);
			m.tx -= point.x;
			m.ty -= point.y;
			m.rotate(angleDegrees*(Math.PI/180));
			m.tx += point.x;
			m.ty += point.y;
		}
	}