/**
 * Copyright 1sunbou ( http://wonderfl.net/user/1sunbou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bQa7
 */

// forked from blacknanana's forked from: line2
// forked from Scmiz's line2
package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        private var _data:/*Datum*/Array;
        
        public function FlashTest() {
            _data = new Array();
            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            create();
            update();
            draw();
        }
        
        private function create():void {
            for (var index:uint = 0; index < 8; ++index) {
                var datum:Datum = new Datum();
                datum.baseX = (Math.random() * 600) - 70;
                datum.y = 0;
                datum.length = 40 + (Math.random() * 60);
                datum.radius = 10 + (Math.random() * 40);
                datum.radian = 0;
                datum.speedRate = (1.0 + (Math.random() * 1.0)) * (Math.random() < 0.5 ? 1:-1);
                var r:uint = 128 + (Math.random() * 128);
                var g:uint = 128 + (Math.random() * 128);
                var b:uint = 128 + (Math.random() * 128);
                datum.color = (r << 16) + (g << 8) + (b << 0);
                _data.push(datum);
            }
        }
        
        private function update():void {
            for (var index:uint = 0; index < _data.length; ++index) {
                var datum:Datum = _data[index];
                
                datum.y += 4 * Math.abs(datum.speedRate);
                datum.radian += Math.PI * 2 * 0.01 * datum.speedRate;
                
                if (datum.y > 465 + datum.length) {
                    _data.splice(index, 1);
                    --index;
                    continue;
                }
            }
        }
        
        private function draw():void {
            var g:Graphics = this.graphics;
            g.clear();
            
            g.beginFill(0x000000);
            g.drawRect(0, 0, 465, 465);
             g.drawString("12dot Font", 105, 105 + 12);        
            g.endFill();

            for (var index:uint = 0; index < _data.length; ++index) {
                var datum:Datum = _data[index];
                var posx:Number = datum.baseX + (Math.sin(datum.radian) * datum.radius);
                var posy:Number = datum.y;
                g.lineStyle(1, datum.color);
                g.moveTo(posx, posy);
                g.lineTo(posx, posy - datum.length);
            }
        }
    }
}

import flash.display.Sprite;

class Datum {
    public var baseX:Number;
    public var y:Number;
    public var length:Number;
    public var radius:Number;
    public var radian:Number;
    public var speedRate:Number;
    public var color:uint;
}