/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bPrN
 */

package {
    import flash.display.*;
    import flash.text.TextField;
    import flash.utils.getTimer;
    import flash.events.*;
    import flash.geom.*;
    import frocessing.display.F5MovieClip2D;
    import com.bit101.components.*;
    
    public class Test extends F5MovieClip2D {
        private var _tf : TextField;
        private var _edges : Vector.<uint>;
		private var _vertices : Vector.<Number>;
        private var _cz : Number = -200;
        
        public function setup() : void {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
//            addChild(_tf);
            
            colorMode(HSV, 30, 1, 1);
            
            var hs : HUISlider = new HUISlider(this, 10, 10, "camera Z", onSliderChange);
            hs.maximum = 0;
            hs.minimum = -400;
            hs.value = -200;
            _cz = hs.value; 
            
            init();
        }
        
        private function onSliderChange(e : Event) : void
        {
        		_cz = e.target.value;
        }
        
        private function init() : void
        {
        		_vertices = new Vector.<Number>();
        		_vertices.push(50, 50, 50);
        		_vertices.push(-50, 50, 50);
        		_vertices.push(50, -50, 50);
        		_vertices.push(50, 50, -50);
        		_vertices.push(-50, -50, 50);
        		_vertices.push(50, -50, -50);
        		_vertices.push(-50, 50, -50);
        		_vertices.push(-50, -50, -50);
        		 
        		_edges = new Vector.<uint>();
        		_edges.push(0, 1);
        		_edges.push(0, 2);
        		_edges.push(0, 3);
        		_edges.push(1, 4);
        		_edges.push(1, 6);
        		_edges.push(2, 4);
        		_edges.push(2, 5);
        		_edges.push(3, 5);
        		_edges.push(3, 6);
        		_edges.push(4, 7);
        		_edges.push(5, 7);
        		_edges.push(6, 7);
        }
        
        public function draw() : void
        {
        		move();
        	
        		var m : Matrix3D = new Matrix3D();
        		var vout : Vector.<Number> = new Vector.<Number>(_vertices.length);
        		m.transformVectors(_vertices, vout);
        		var i : uint, j : uint;
        		
        		translate(465 / 2, 465 / 2);
        		var T : uint = 10;
        		
        		noFill();
        		var a : Array;
        		for(i = 0;i < _edges.length;i += 2){
        			var fx : Number = vout[_edges[i] * 3];
        			var fy : Number = vout[_edges[i] * 3 + 1];
        			var fz : Number = vout[_edges[i] * 3 + 2];
        			var tx : Number = vout[_edges[i+1] * 3];
        			var ty : Number = vout[_edges[i+1] * 3 + 1];
        			var tz : Number = vout[_edges[i+1] * 3 + 2];
        			
	        		beginShape();
        			a = refract(fx, fy, fz);
	        		curveVertex(a[0], a[1]);
        			for(j = 0;j <= T;j++){
	        			var ix : Number = fx + (tx - fx) * j / T;
	        			var iy : Number = fy + (ty - fy) * j / T;
	        			var iz : Number = fz + (tz - fz) * j / T;
	        			
	        			a = refract(ix, iy, iz);
	        			curveVertex(a[0], a[1]);
	        		}
        			a = refract(tx, ty, tz);
	        		curveVertex(a[0], a[1]);
	    			endShape();
        		}
        }
        
        // 中心との距離が、カメラ正面向きのベクトル(Z軸正)とカメラから点へのベクトルの角度に比例する
        private function refract(x : Number, y : Number, z : Number) : Array
        {
        		z -= _cz;
        		var theta : Number = Math.atan2(z, Math.sqrt(x * x + y * y));
        		x *= theta / z * 250;
        		y *= theta / z * 250;
        		return [x, y];
        }
        
        private function move() : void
        {
        		var m : Matrix3D = new Matrix3D();
        		var axis : Vector3D = new Vector3D(1, 2, 3);
        		axis.normalize();
        		m.appendRotation(1, axis);
        		var vout : Vector.<Number> = new Vector.<Number>(_vertices.length);
        		m.transformVectors(_vertices, vout);
        		_vertices = vout;
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}
