/**
 * Copyright Jefoe ( http://wonderfl.net/user/Jefoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bPhm
 */

// forked from Qwaz's Jewela v0.6
package  {
    import gs.TweenLite;
    import flash.display.Sprite;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.net.URLRequest;
    import flash.utils.Timer;
    
    //import qwazlab.net.AssetLoader
    
    [SWF (width=300, height=300)]
    
    public class Main extends Sprite {
        private var asset:AssetLoader;
        
        private var Gem:Vector.<Class>;
        
        private var timer:Timer;
        private var mode:int;
        private var target:Sprite;
        
        private var maxGem:int;
        private var score:int;
        private var combo:int;
        
        private var data:Array;
        private var spriteArr:Array;
        
        private var tDirection:int;
        
        private const MAX:int = 15;
        private const TWEEN_TIME:Number = 0.4;
        private const TIMER_TIME:uint = 500;
        
        public function Main() {
            timer = new Timer(TIMER_TIME);
            timer.addEventListener(TimerEvent.TIMER, onTimerComplete);
            this.addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        private function onAddedToStage(e:Event):void {
            asset = new AssetLoader();
            asset.addEventListener(Event.COMPLETE, onComplete);
            asset.load(new URLRequest("http://cfs.tistory.com/custom/blog/87/874645/skin/images/_JewelaAsset.swf?=1262751924"));
        }
        
        private function onComplete(e:Event):void {
            Gem = new Vector.<Class>;
            Gem[0] = asset.getClass("Gem0");
            Gem[1] = asset.getClass("Gem1");
            Gem[2] = asset.getClass("Gem2");
            Gem[3] = asset.getClass("Gem3");
            Gem[4] = asset.getClass("Gem4");
            Gem[5] = asset.getClass("Gem5");
            init();
        }
        
        private function init():void {
            maxGem = 6;
            score = 0;
            combo = 0;
            
            var i:int;
            var j:int;
            data = new Array();
            for (i=0; i<MAX; i++) {
                data.push(new Array());
                for (j=0; j<MAX; j++) {
                    data[i].push(int(Math.random() * maxGem));
                }
            }
            var gem:Sprite;
            spriteArr = new Array();
            for (i=0; i<MAX; i++) {
                spriteArr.push(new Array());
                for (j=0; j<MAX; j++) {
                    gem = new Gem[data[i][j]]();
                    addListeners(gem);
                    this.addChild(gem);
                    gem.x = 10 + 20 * j;
                    gem.y = -10;
                    TweenLite.to(gem, TWEEN_TIME, {y:10+20*i});
                    spriteArr[i].push(gem);
                }
            }
            
            mode = 0;
            timer.start();
        }
        
        private function onTimerComplete(e:TimerEvent):void {
            timer.reset();
            timer.stop();
            
            if(mode == 3) {
                mode = 1;
            } else {
                chkChange();
            }
        }
        
        private function chkChange():void {
            var i:int;
            var j:int;
            var change:Boolean = false;
            var chk:Array = new Array();
            
            
            
            for(i=0; i<MAX; i++){
                chk[i] = new Array();
                for(j=0; j<MAX; j++){
                    chk[i].push(false);
                }
            }
            
            for(i=0; i<MAX; i++){
                for(j=2; j<MAX; j++){
                    if(data[i][j-2] == data[i][j-1] && data[i][j-1] == data[i][j]){
                        chk[i][j-2] = true;
                        chk[i][j-1] = true;
                        chk[i][j] = true;
                    }
                }
            }
            for(i=2; i<MAX; i++){
                for(j=0; j<MAX; j++){
                    if(data[i-2][j] == data[i-1][j] && data[i-1][j] == data[i][j]){
                        chk[i-2][j] = true;
                        chk[i-1][j] = true;
                        chk[i][j] = true;
                    }
                }
            }
            
            for(i=0; i<MAX; i++){
                for(j=0; j<MAX; j++){
                    if(chk[i][j] == true){
                        data[i][j] = -1;
                        change = true;
                    }
                }
            }
            
            if(change) {
                mode = 0;
                alignGem();
            } else {
                if(mode == 2) {
                    i = (target.y-10)/20;
                    j = (target.x-10)/20;
                    target = null;
                    
                    var tmpInt:int;
                    var tmpSpr:Sprite;
                    
                    switch(tDirection) {
                        //0-Right 1-Down 2-Left 3-Up
                        case 0 :
                            tmpInt = data[i][j];
                            data[i][j] = data[i][j-1];
                            data[i][j-1] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i][j-1];
                            spriteArr[i][j-1] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i][j-1], TWEEN_TIME, {y:10+20*i, x:10+20*(j-1)});
                            break;
                        case 1 :
                            tmpInt = data[i][j];
                            data[i][j] = data[i-1][j];
                            data[i-1][j] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i-1][j];
                            spriteArr[i-1][j] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i-1][j], TWEEN_TIME, {y:10+20*(i-1), x:10+20*j});
                            break;
                        case 2 :
                            tmpInt = data[i][j];
                            data[i][j] = data[i][j+1];
                            data[i][j+1] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i][j+1];
                            spriteArr[i][j+1] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i][j+1], TWEEN_TIME, {y:10+20*i, x:10+20*(j+1)});
                            break;
                        case 3 :
                            tmpInt = data[i][j];
                            data[i][j] = data[i+1][j];
                            data[i+1][j] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i+1][j];
                            spriteArr[i+1][j] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i+1][j], TWEEN_TIME, {y:10+20*(i+1), x:10+20*j});
                            break;
                    }
                    mode = 3;
                    timer.start();
                } else if(mode == 0) {
                    mode = 1;
                }
            }
        }
        
        private function alignGem():void {
            target = null;
            
            var i:int;
            var j:int;
            var k:int;
            
            var gem:Sprite;
            for(i=MAX-1; i>=0; i--){
                for(j=0; j<MAX; j++){
                    if(data[i][j] == -1){
                        if(spriteArr[i][j]){
                            remove(spriteArr[i][j]);
                        }
                        for(k=i-1; k>=0; k--){
                            if(data[k][j] != -1){
                                TweenLite.to(spriteArr[k][j], TWEEN_TIME, {y:10+20*i});
                                spriteArr[i][j] = spriteArr[k][j];
                                spriteArr[k][j] = null;
                                data[i][j] = data[k][j];
                                data[k][j]= -1;
                                break;
                            }
                        }
                        if(k == -1){
                            data[i][j] = int(Math.random() * maxGem);
                            gem = new Gem[data[i][j]]();
                            addListeners(gem);
                            this.addChild(gem);
                            gem.x = 10 + 20 * j;
                            gem.y = -10;
                            TweenLite.to(gem, TWEEN_TIME, {y:10+20*i});
                            spriteArr[i][j] = gem;
                        }
                    }
                }
            }
            timer.start();
        }
        
        private function addListeners($target:Sprite):void {
            $target.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            $target.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            $target.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        }
        
        private function remove($target:Sprite):void {
            $target.removeEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            $target.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            $target.removeEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
            this.removeChild($target);
        }
        
        private function onMouseDown(e:MouseEvent):void {
            if(mode == 1){
                target = e.target as Sprite;
            }
        }
        
        private function onMouseUp(e:MouseEvent):void {
            if(mode == 1){
                target = null;
            }
        }
        
        private function onMouseOut(e:MouseEvent):void {
            if(mode == 1 && target == e.target){
                //0-Right 1-Down 2-Left 3-Up
                var direction:int;
                
                var dx:int = this.mouseX-e.target.x;
                var dy:int = this.mouseY-e.target.y;
                
                var i:int = (e.target.y-10)/20;
                var j:int = (e.target.x-10)/20;
                
                var tmpInt:int;
                var tmpSpr:Sprite;
                
                if(dx >= 0){
                    if(dy >= 0){
                        if(dy > dx) direction = 1;
                        else direction = 0;
                    } else {
                        if(-dy > dx) direction = 3;
                        else direction = 0;
                    }
                } else {
                    if(dy >= 0){
                        if(dy > -dx) direction = 1;
                        else direction = 2;
                    } else {
                        if(-dy > -dx) direction = 3;
                        else direction = 2;
                    }
                }
                switch (direction) {
                    case 0 :
                        if(j < 14) {
                            tmpInt = data[i][j];
                            data[i][j] = data[i][j+1];
                            data[i][j+1] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i][j+1];
                            spriteArr[i][j+1] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i][j+1], TWEEN_TIME, {y:10+20*i, x:10+20*(j+1)});
                        }
                        break;
                    case 1 :
                        if(i < 14) {
                            tmpInt = data[i][j];
                            data[i][j] = data[i+1][j];
                            data[i+1][j] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i+1][j];
                            spriteArr[i+1][j] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i+1][j], TWEEN_TIME, {y:10+20*(i+1), x:10+20*j});
                        }
                        break;
                    case 2 :
                        if(j > 0) {
                            tmpInt = data[i][j];
                            data[i][j] = data[i][j-1];
                            data[i][j-1] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i][j-1];
                            spriteArr[i][j-1] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i][j-1], TWEEN_TIME, {y:10+20*i, x:10+20*(j-1)});
                        }
                        break;
                    case 3 :
                        if(i > 0) {
                            tmpInt = data[i][j];
                            data[i][j] = data[i-1][j];
                            data[i-1][j] = tmpInt;
                            tmpSpr = spriteArr[i][j];
                            spriteArr[i][j] = spriteArr[i-1][j];
                            spriteArr[i-1][j] = tmpSpr;
                            TweenLite.to(spriteArr[i][j], TWEEN_TIME, {y:10+20*i, x:10+20*j});
                            TweenLite.to(spriteArr[i-1][j], TWEEN_TIME, {y:10+20*(i-1), x:10+20*j});
                        }
                        break;
                }
                tDirection = direction;
                mode = 2;
                timer.start();
            }
        }
    }
}

import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.net.URLRequest;
import flash.system.ApplicationDomain;
import flash.system.LoaderContext;
import flash.system.Security;
import flash.system.SecurityDomain;

class AssetLoader extends EventDispatcher {
    private var loader:Loader;
    private var lc:LoaderContext;
    
    public function AssetLoader($url:URLRequest=null):void {
        loader = new Loader();
        if ($url != null) {
            load($url);
        }
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
    }
    
    private function completeHandler(e:Event):void    {
        this.dispatchEvent(new Event(Event.COMPLETE));
    }
    
    public function load($url:URLRequest):void {
        if (Security.sandboxType == Security.REMOTE) {
            lc = new LoaderContext(false, ApplicationDomain.currentDomain, SecurityDomain.currentDomain);
        } else {
            lc = new LoaderContext(false, ApplicationDomain.currentDomain);
        }
        loader.load($url, lc);
    }
    
    public function getClass($name:String):Class {
        return loader.contentLoaderInfo.applicationDomain.getDefinition($name) as Class;
    }
}