/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bP5g
 */

package {
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private var shape:DragMeNot;
        private var settings:Settings;
        
        public function FlashTest() {
            shape = new DragMeNot();
            addChild(shape);
            
            settings = new Settings(shape);
            addChild(settings); 
        }
    }
}
import flash.geom.Point;
import flash.display.Shape;

import com.bit101.components.CheckBox;
import com.bit101.components.Panel;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;

class DragMeNot extends Sprite
{
    public var lockCenter:Boolean = false;
    public var dragBounds:Rectangle = null;
    
    public function DragMeNot() 
    {
        //Shape
        graphics.lineStyle(3,0);        
        graphics.beginFill(0xFF340F);        
        graphics.drawRect(0,0,30,30);       
        graphics.endFill();       
        graphics.beginFill(0x0FFF0F);
        graphics.drawCircle(30,30,15);        
        graphics.drawCircle(-7,3,11);        
        graphics.endFill();       
        
        //Origin
        graphics.lineStyle(1,0);        
        graphics.beginFill(0xFFFFFF);        
        graphics.drawCircle(0,0,4);        
        graphics.endFill();       
        
        rotation = 25;        
        scaleX = scaleY = 1.2;       
        x = y = 200;
        useHandCursor = true;
        buttonMode = true;
        addEventListener(MouseEvent.MOUSE_DOWN,md);
        addEventListener(Event.ENTER_FRAME,loop);
    }    
    private function loop(e:Event):void
    {
        rotation += 3;
        
    }

    private function md(e:MouseEvent):void
    {
        startDrag(lockCenter, dragBounds);        
        stage.addEventListener(MouseEvent.MOUSE_UP, mu);
    }    
    private function mu(e:MouseEvent):void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP, mu);        
        stopDrag();
    }
}

class Settings extends Panel
{
    private var control:DragMeNot;
    private var lockCenter:CheckBox;
    private var applyBounds:CheckBox;
    private var box:VisibleBounds;
    private var drawBounds:CheckBox;
    private var art:Shape;
    public function Settings(control:DragMeNot) {
        this.control = control;
        super();
        setSize(230, 20);
        scaleX = scaleY = 2;
    }
    override protected function addChildren():void {
        super.addChildren();
        lockCenter = new CheckBox(this, 5, 5, "Lock center", toogleCenter);
        lockCenter.selected = control.lockCenter;
        
        box = new VisibleBounds(onUpdate);
        addChild(box);
        
        applyBounds = new CheckBox(this, lockCenter.width + 10, 5, "Drag bounds", toogleBounds);
        box.visible = applyBounds.selected = control.dragBounds != null;
        
        art = new Shape();
        
        drawBounds = new CheckBox(this, applyBounds.x + applyBounds.width + 10, 5,"Draw bounds",toogleDrawBounds);
    }
    private function onUpdate():void {
        control.dragBounds = box.rect;
    }
    private function toogleCenter(e:Event):void {
        control.lockCenter = lockCenter.selected;
    }
    private function toogleBounds(e:Event):void {
        box.visible = applyBounds.selected;
        control.dragBounds = box.visible ? box.rect : null;
    }
    private function toogleDrawBounds(e:Event):void {
        if(drawBounds.selected)
        {
            parent.addChild(art);    
            addEventListener(Event.ENTER_FRAME,onDraw);
        } else {
            removeEventListener(Event.ENTER_FRAME,onDraw);
        }
        art.visible = drawBounds.selected;   
    }
    
    private function onDraw(e:Event):void
    {
        art.graphics.clear();
        
        var r:Rectangle = control.getBounds(parent);
        
        art.graphics.lineStyle(1,0x0000FF);
        art.graphics.drawRect(r.x,r.y,r.width,r.height);
        
        var p:Point = new Point(control.x,control.y);
        
        art.graphics.moveTo(p.x,0);
        art.graphics.lineTo(p.x,500);

        art.graphics.moveTo(0,p.y);
        art.graphics.lineTo(500,p.y);
    }
}

class VisibleBounds extends Sprite
{
    private var _rect:Rectangle;
    private var tl:DragIco, tr:DragIco, bl:DragIco, br:DragIco;
    private var onUpdate:Function;
    
    public function VisibleBounds(onUpdate:Function) {
        this.onUpdate = onUpdate;
        addEventListener(Event.ADDED_TO_STAGE, init);
        tl = new DragIco(onDrag);
        tr = new DragIco(onDrag,0xE34428);
        bl = new DragIco(onDrag);
        br = new DragIco(onDrag);
        rect = new Rectangle(132, 132, 200, 200);
        //rect = new Rectangle(50, 50, 100, 100);
        addChild(tl);    addChild(tr);
        addChild(bl);    addChild(br);
    }
    
    private function onDrag(target:DragIco):void {
        switch(target) {
            case tl:
                bl.x = tl.x;
                tr.y = tl.y;
                break;
            case tr:
                br.x = tr.x;
                tl.y = tr.y;
                break;
            case br:
                tr.x = br.x;
                bl.y = br.y;
                break;
            default:
            case bl:
                tl.x = bl.x;
                br.y = bl.y;
                break; 
        } _rect = new Rectangle(tl.x, tl.y, br.x - tl.x, br.y - tl.y);
        updateLimits();
        onUpdate();
    }
    
    private function updateLimits():void {        
        tl.dragBounds = new Rectangle(0,0,tr.x - 16,bl.y - 16);
        //tr.dragBounds = new Rectangle(tl.x + 16, 0, Infinity, br.y - 16);
        //br.dragBounds = new Rectangle(bl.x + 16,tr.y + 16, Infinity, Infinity);
        //bl.dragBounds = new Rectangle(0,tl.y + 16,br.x - 16,Infinity);
        drawBorder();
    }
    
    private function drawBorder():void {
        graphics.clear();
        graphics.lineStyle(3,0x28E332,0.5);
        graphics.drawRect(_rect.x, _rect.y, _rect.width, _rect.height);
        graphics.endFill();
    }
    
    private function init(e:Event):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);        
        stage.addChild(this);        
    }
    
    public function get rect():Rectangle {return _rect.clone();}
    public function set rect(value:Rectangle):void {
        _rect = value.clone();
        bl.x = tl.x = _rect.left;
        tr.y = tl.y = _rect.top;
        tr.x = br.x = _rect.right;
        bl.y = br.y = _rect.bottom;
        updateLimits();
    }
}

class DragIco extends Sprite {
    private var onDrag:Function;
    public var dragBounds:Rectangle;
    public function DragIco(onDrag:Function,color:uint = 0x95E817) {
        this.onDrag = onDrag;
        graphics.beginFill(color);
        graphics.lineStyle(3);
        graphics.drawCircle(0, 0, 8);
        graphics.endFill();
        dragBounds = null;
        addEventListener(MouseEvent.MOUSE_DOWN, md);
    }
    
    private function md(e:MouseEvent):void {
        stage.addEventListener(MouseEvent.MOUSE_UP, mu);
        startDrag(true, dragBounds);
        addEventListener(Event.ENTER_FRAME, fireEvent);
    }
    private function fireEvent(e:Event):void {onDrag(this); }
    private function mu(e:MouseEvent):void {
        onDrag(this);
        stage.removeEventListener(MouseEvent.MOUSE_UP, mu);
        removeEventListener(Event.ENTER_FRAME, fireEvent);
        stopDrag();
    }
}