/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bOrN
 */

package
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.StageQuality;
    import net.hires.debug.Stats;

    
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#ffffff',frameRate='60')]
    
    /**
     * Name           : Main
     * Coded By       : Matt Wakeling
     * Date           : 07th May 2012
     * Description    : Main Class for the Application.
     *                  ActionScript 3 Henon Phase Diagrams (HI-RES) - based on code from Paul Bourke and Jared Tarbell
     *
     * @author Matt Wakeling
     */
    public class HenonClient extends Sprite
    {
        // Main Constructor
        public function HenonClient()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }
        
        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else
                addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage, false, 0, true);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(evtInitialiseStage:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            // Black Screen for Wonderfl Capture
            //this.graphics.beginFill(0x000000, 1);
            //this.graphics.drawRect(stage.x, stage.y, stage.stageWidth, stage.stageHeight);
            //this.graphics.endFill();
            
            initHenonPhase();
            
            //addChild(new Stats());
        }
        
        // initHenonPhase Method
        private function initHenonPhase():void
        {
            var scrHenonPhase:HenonPhase = new HenonPhase(stage.stageWidth, stage.stageHeight);
            scrHenonPhase.cacheAsBitmap = true;
            scrHenonPhase.scaleX = 0.125;
            scrHenonPhase.scaleY = 0.125;
            
            addChild(scrHenonPhase);
        }
    }
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.events.Event;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import frocessing.color.ColorHSV;

class HenonPhase extends Sprite
{
    private var $Width:int = 0;
    private var $Height:int = 0;
    private var $Scale:int = 3;
    private var $Angle:Number = 2.62;
    private var $SAngle:Number = Math.sin($Angle);
    private var $CAngle:Number = Math.cos($Angle);
    
    private var $Iterations:int = 1000;
    private var $Points:int = 6000;
    
    private var $PointColor:Array = new Array(0x030303, 0x050505, 0x080808, 0x0A0A0A, 0x0D0D0D, 0x0F0F0F, 0x121212, 0x141414, 0x171717, 0x1A1A1A, 0x1C1C1C, 0x1F1F1F, 0x212121, 0x242424, 0x262626, 0x292929, 0x2B2B2B, 0x2E2E2E, 0x303030, 0x333333, 0x363636, 0x383838, 0x3B3B3B, 0x3D3D3D, 0x404040, 0x424242, 0x454545, 0x474747, 0x4A4A4A, 0x4D4D4D, 0x4F4F4F, 0x525252, 0x545454, 0x575757, 0x595959, 0x5C5C5C, 0x5E5E5E, 0x616161, 0x636363, 0x666666, 0x696969, 0x6B6B6B, 0x6E6E6E, 0x707070, 0x737373, 0x757575, 0x787878);
    
    private var $FrameCounter:int = 0;
    
    private var $BitmapData:BitmapData;
    private var $Bitmap:Bitmap;
    
    private var $AngleTextField:TextField;
    
    private var $ColorHSV:ColorHSV = new ColorHSV(0);
    
    // HenonPhase Constructor
    public function HenonPhase($StageWidth:int, $StageHeight:int)
    {
        for (var i:int = 0; i < $PointColor.length; i++) 
        {
            $PointColor[i] = 0;
        }
        $Width = $StageWidth * 8;
        $Height = $StageHeight * 8;
        
        $BitmapData = new BitmapData($Width, $Height, false, 0xffffff);
        $Bitmap = new Bitmap($BitmapData);
        
        addChild($Bitmap);
        /*
        var $HeaderTextField:TextField = createCustomTextField(280 * 8, 0);
        $HeaderTextField.text = "xn+1 = xn cos(a) - (yn - xn2) sin(a) \n" + "yn+1 = xn sin(a) + (yn - xn2) cos(a) \n";
        $HeaderTextField.scaleX = $HeaderTextField.scaleY = 8;
        $HeaderTextField.textColor = 0xAAAAAA;
        $HeaderTextField.background = true;
        $HeaderTextField.backgroundColor = 0x000000;
        $HeaderTextField.selectable = false;
        
        $AngleTextField = createCustomTextField(0, 450 * 8);
        $AngleTextField.text = "ANGLE : " + $Angle;
        $AngleTextField.scaleX = $AngleTextField.scaleY = 8;
        $AngleTextField.textColor = 0xAAAAAA;
        $AngleTextField.background = true;
        $AngleTextField.backgroundColor = 0x000000;
        $AngleTextField.selectable = false;
        */
        addEventListener(Event.ENTER_FRAME, FrameEvent);
    }
    
    // FrameEvent Method
    private function FrameEvent($Event:Event):void
    {
        var $XCoord:Number = 0;
        var $YCoord:Number = 0;
        
        var $StartPoint:Number = Math.random();
        var $SelectedColor:int = Math.random() * $PointColor.length;
        var $Henon:HenonClass = new HenonClass($StartPoint, 0.0, $ColorHSV.value * $StartPoint);
        
        $BitmapData.lock();
        
        for (var $PointCounter:int = 0; $PointCounter < $Points; $PointCounter++)
        {
            var $NextX:Number = $Henon.$x * $CAngle - ($Henon.$y - $Henon.$x * $Henon.$x) * $SAngle;
            
            $Henon.$y = $Henon.$x * $SAngle + ($Henon.$y - $Henon.$x * $Henon.$x) * $CAngle;
            $Henon.$x = $NextX;
            
            if (isNaN($Henon.$x) || isNaN($Henon.$y))
                break;
            if ($Henon.$x == Number.NEGATIVE_INFINITY || $Henon.$x == Number.POSITIVE_INFINITY || $Henon.$y == Number.NEGATIVE_INFINITY || $Henon.$y == Number.POSITIVE_INFINITY)
                break;
            
            $XCoord = ($Henon.$x / $Scale + .5) * $Width;
            $YCoord = ($Henon.$y / $Scale + .5) * $Height;
            
            if (($XCoord >= 0 && $XCoord <= $Width) && ($YCoord >= 0 && $YCoord <= $Height))
            {
                //$BitmapData.setPixel($XCoord, $YCoord, $Henon.$color);
                $BitmapData.setPixel($XCoord, $YCoord, 0);
            }
        }
        
        $BitmapData.unlock();
        
        if ($FrameCounter++ >= $Iterations)
        {
            removeEventListener(Event.ENTER_FRAME, FrameEvent)
            
            $FrameCounter = 0;
            
            $BitmapData.fillRect($BitmapData.rect, 0xffffff);
            
            $Angle = Math.random() * (2 * Math.PI);
            $SAngle = Math.sin($Angle);
            $CAngle = Math.cos($Angle);
            
            //$AngleTextField.text = "ANGLE : " + $Angle;
            
            addEventListener(Event.ENTER_FRAME, FrameEvent);
        }
    }
    
    // createCustomTextField Method
    private function createCustomTextField($x:Number, $y:Number):TextField
    {
        var $result:TextField = new TextField();
        $result.x = $x;
        $result.y = $y;
        $result.autoSize = TextFieldAutoSize.LEFT;
        
        addChild($result);
        
        return $result;
    }
}

class HenonClass
{
    public var $x:Number;
    public var $y:Number;
    public var $color:int;
    
    // HenonClass Constructor
    public function HenonClass($XCoord:Number, $YCoord:Number, $Color:int)
    {
        $x = $XCoord;
        $y = $YCoord;
        $color = $Color;
    }

}

