/**
 * Copyright shihu ( http://wonderfl.net/user/shihu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bOlF
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.ActivityEvent;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;

    public class Main extends Sprite {
        //------- CONST ------------------------------------------------------------
        private static const _WIDTH:Number = 640;
        private static const _HEIGHT:Number = 480;
        //------- MEMBER -----------------------------------------------------------
        private var _srcRect:Rectangle;
        private var _srcBMD:BitmapData;
        private var _effectBMD:BitmapData;
        private var _effects:Array;
        private var _bmd:BitmapData;
        //
        private var _camera:Camera;
        private var _video:Video;
        //------- PUBLIC -----------------------------------------------------------
        public function Main():void {
            _effects = [];
            Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _onLoader1Complete, false, 0, true );
            loader.load( new URLRequest( "http://farm5.static.flickr.com/4042/5075118395_56a727ec1c_z.jpg" ), new LoaderContext( true ) );
        }
        
        private function _onLoader1Complete( event:Event ):void {
            _effects[ _effects.length ] = Bitmap( LoaderInfo( event.currentTarget ).content ).bitmapData;
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, _onLoader2Complete, false, 0, true );
            loader.load( new URLRequest( "http://farm5.static.flickr.com/4037/5075146125_4b2a976f14_z.jpg" ), new LoaderContext( true ) );
        }
        
        private function _onLoader2Complete( event:Event ):void {
            _effects[ _effects.length ] = Bitmap( LoaderInfo( event.currentTarget ).content ).bitmapData;
            
            _srcRect = new Rectangle( 0, 0, _WIDTH, _HEIGHT );
            _srcBMD = new BitmapData( _WIDTH, _HEIGHT );
            _effectBMD = new BitmapData( _WIDTH, _HEIGHT );
            _bmd = new BitmapData( _WIDTH, _HEIGHT );
            _effects[ _effects.length ] = _effectBMD;
            //
            if ( _checkAvailability() ) {
                _initialize();
            } else {
                addEventListener( Event.ENTER_FRAME, _onCheckEnterFrame );
            }
        }
        //------- PRIVATE ----------------------------------------------------------
        private function _checkAvailability():Boolean {
            _camera = Camera.getCamera( "0" );
            if ( _camera != null ) {
                return true;
            } else {
                return false;
            }
        }
        private function _onCheckEnterFrame( event:Event ):void {
            if ( _checkAvailability() ) {
                removeEventListener( Event.ENTER_FRAME, _onCheckEnterFrame );
                _initialize();
            }
        }
        private function _initialize():void {
            _camera.setMode( _WIDTH, _HEIGHT, stage.frameRate, false );
            _video = new Video( _WIDTH, _HEIGHT );
            _video.attachCamera( _camera );
            _camera.addEventListener( ActivityEvent.ACTIVITY, _onCameraActivity );
        }
        //--------------------------------------
        //  
        //--------------------------------------
        private function _onCameraActivity( event:ActivityEvent ):void {
            _camera.removeEventListener( ActivityEvent.ACTIVITY, _onCameraActivity );
            addChild( new Bitmap( _bmd ) );
            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        }
        //--------------------------------------
        //  
        //--------------------------------------
        private function _onEnterFrame( event:Event ):void {
            _effectBMD = _srcBMD.clone();
            _effects[ _effects.length - 1 ] = _effectBMD;
            _srcBMD.draw( _video );
            //
            //_bmd.setPixels( _srcRect, getGlitchByteArray( _srcBMD, _effectBMD ) );
            _bmd.setPixels( _srcRect, getGlitchByteArray( _srcBMD, _effects[ uint( _effects.length * Math.random() ) ] ) );
        }
        //--------------------------------------
        //  
        //--------------------------------------
        private function getGlitchByteArray(
              srcBMD:BitmapData
            , effectBMD:BitmapData
            , maxSize:int = 128
            , loop:uint = 10
        ):ByteArray {
            var effectBytes:ByteArray = effectBMD.getPixels( new Rectangle( 0, 0, srcBMD.width, srcBMD.height ) );
            var bytes:ByteArray = new ByteArray();
            bytes.writeBytes( srcBMD.getPixels( _srcRect ) );
            const BYTES_LENGTH:uint = effectBytes.length;
            for ( var idx:uint = 0; idx < loop; idx++ ) {
                var size:int = int( maxSize * Math.random() );
                bytes.position = int( BYTES_LENGTH * Math.random() );
                bytes.writeBytes( effectBytes, int( ( BYTES_LENGTH - size ) * Math.random() ), size * Math.random() );
            }
            bytes.position = 0;
            return bytes;
        }
        //------- PROTECTED --------------------------------------------------------
        //------- INTERNAL ---------------------------------------------------------
    }
}