/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bMov
 */

package {
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var bitmatData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight,false,0x0)
            addChild(new Bitmap(bitmatData))
            var wire:Shape = new Shape
            var body:Shape = addChild(new Shape) as Shape
            var solid:Object = new Object
            solid.verts = new Vector.<Number>
            solid.verts.push(0,1,0,1,0,0,0,0,1,-1,0,0,0,0,-1,0,-1,0)
            solid.indices = new Vector.<int>
            solid.indices.push(0,1,2,0,2,3,0,3,4,0,4,1,5,2,1,5,3,2,5,4,3,5,1,4)
            var drawSolid:Function = function(canvas:Shape,matrix:Matrix3D,color:uint):void {
                var persVerts:Vector.<Number> = new Vector.<Number>
                var uvtData:Vector.<Number> = new Vector.<Number>
                Utils3D.projectVectors(matrix, solid.verts, persVerts, uvtData)
                persVerts.map(function(item:Number, index:int, vector:Vector.<Number>):void {
                    vector[index] += (index%2==0) ? stage.stageWidth/2 : stage.stageHeight/2
                })
                canvas.graphics.lineStyle(0,color)
                canvas.graphics.drawTriangles(persVerts, solid.indices, uvtData, 'negative')
            }   
            var spline:Function = function(p:Vector.<Vector3D>, t:Number):Vector3D {
                var point:Vector3D = new Vector3D
                for each(var v:String in ["x","y","z"]){
                    point[v] =  0.5*(
                                (2*p[1][v]) +
                                (-p[0][v] + p[2][v]) * t +
                                (2*p[0][v] - 5*p[1][v] + 4*p[2][v] - p[3][v]) * Math.pow(t,2) +
                                (-p[0][v] + 3*p[1][v]- 3*p[2][v] + p[3][v]) * Math.pow(t,3) )
                }
                return point
            }                          
            var radius:int = 20            
            var rabbits:Vector.<Vector3D> = new Vector.<Vector3D>
            for (var i:int=0; i<10; i++) {
                rabbits.push(new Vector3D(
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5)
                ))
            }            
            var nextDog:Vector3D = new Vector3D
            var dog:Vector3D = new Vector3D
            var pers:PerspectiveProjection = new PerspectiveProjection
            var persMatrix:Matrix3D = pers.toMatrix3D()
            var worldMatrix:Matrix3D = new Matrix3D
            var solidMatrix:Matrix3D = new Matrix3D                      
            var split:int = 100
            var count:int = 1
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                dog = nextDog.clone()
                nextDog = spline(rabbits,count/split)
                count++
                if (count>split) {
                    rabbits.shift()
                    rabbits.push(new Vector3D(
                        radius*(Math.random()-0.5),
                        radius*(Math.random()-0.5),
                        radius*(Math.random()-0.5)
                    ))                    
                    count=1
                }
                var colorTransform:ColorTransform = new ColorTransform(0.95,0.95,0.95)
                bitmatData.colorTransform(bitmatData.rect, colorTransform)
                var sightLine:Vector3D = Vector3D.Z_AXIS  
                var diff:Vector3D = nextDog.subtract(dog)
                var axis:Vector3D = sightLine.crossProduct(diff)
                var theta:Number = -Vector3D.angleBetween(sightLine,diff)*180/Math.PI
                with (worldMatrix) {
                    identity()
                    appendTranslation(-dog.x,-dog.y,-dog.z)                
                    appendRotation(theta,axis)
                    appendTranslation(0,0,-3)                
                    append(persMatrix)
                }                 
                wire.graphics.clear()                
                var n:int = rabbits.length
                while (n--) {
                    with (solidMatrix) {
                        identity()
                        appendTranslation(rabbits[n].x,rabbits[n].y,rabbits[n].z)
                        append(worldMatrix)
                    }
                    if (solidMatrix.transformVector(new Vector3D(0,0,0)).z > 1) {
                        drawSolid(wire,solidMatrix,0x0055aa)
                    }
                }
                bitmatData.draw(wire)
                with (solidMatrix) {
                    identity()
                    appendTranslation(dog.x,dog.y,dog.z)
                    append(worldMatrix)
                }
                body.graphics.clear()
                drawSolid(body,solidMatrix,0xaa0000)                
            })                 
        }
    }
}
