/**
 * Copyright Hio818214 ( http://wonderfl.net/user/Hio818214 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bMfk
 */

// forked from clockmaker's [F-site] Sample 02 - Papervision3D
// 3面図から立体を作るテスト
// 3面図をクリックするとドットを打てます。
// 整合性の取れたドットを打てば立体として表示されます。
// 多くのドットでテストしてないのでおかしな立体になっても気にしない。
// 
// わかりにくいので左上の一番手前にひとつテストドットを打った

package {
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    public class Main extends Sprite{
        private var view: View = new View();
        public function Main(){
            initData();
            createCanvas();
            
            graphics.lineStyle( 1, 0xffffffff );
            graphics.moveTo( stage.stageWidth/2, 0 );
            graphics.lineTo( stage.stageWidth/2, stage.stageHeight );
            graphics.moveTo( 0, stage.stageHeight/2 );
            graphics.lineTo( stage.stageWidth, stage.stageHeight/2 );
            
            graphics.lineStyle( 1, 0x44444444 );
            var dx: Array = [0, 0, stage.stageWidth/2];
            var dy:Array = [0,stage.stageHeight/2,stage.stageHeight/2];
            for( var k:int = 0; k < 3; k++ ){
                for( var i: int = 0; i < stage.stageWidth/2; i+=10 ){
                    graphics.moveTo( i+dx[k], 0+dy[k] );
                    graphics.lineTo( i+dx[k], stage.stageHeight/2+dy[k] );
                }
                for( var j:int = 0; j < stage.stageHeight/2; j+=10 ){
                    graphics.moveTo( 0+dx[k], j+dy[k] );
                    graphics.lineTo( stage.stageWidth/2+dx[k], j+dy[k] );
                }
            }
            graphics.lineStyle( 1, 0xffffffff );
            
            view.scaleX = 0.5;
            view.scaleY = 0.5;
            view.x = stage.stageWidth/2+1;
            view.y = -1;
            addChild( view );
                        
            stage.addEventListener( MouseEvent.CLICK, onClick );
            stage.addEventListener( MouseEvent.MOUSE_MOVE, onMouseMove );
            addPoint( 1, stage.stageHeight/2-5 );
            addPoint( 1, stage.stageHeight/2+1 );
            addPoint( stage.stageWidth/2+1, stage.stageHeight/2+1 );
        }
        
        private var size: int = 20;
        private function initData(): void{
            size = stage.stageWidth/2/10;
        }
        
        private var canvas: Array = [];
        private function createCanvas(): void{
            for( var i:int = 0; i < 3; i++ ){
                canvas[i] = new BitmapData(size,size,true,0xff000000 );
            }
            var t:Array = [];
            var text:Array = ["top view", "front view", "side view"];
            var textx:Array = [0,0,stage.stageWidth/2];
            var texty:Array = [0,stage.stageHeight/2,stage.stageHeight/2];
            for( var j:int = 0; j < 3; j++ ){
                t[j] = new TextField();
                t[j].text = text[j];
                t[j].textColor = 0xffffffff;
                t[j].mouseEnabled = false;
                t[j].x = textx[j];
                t[j].y = texty[j];
                addChild(t[j]);
            }
        }
        

        private function setBlock( x:int, y:int ): void{
            graphics.beginFill( 0x888888 );
            graphics.drawRect( x, y, 10, 10 );
            graphics.endFill();
        }
        
        private function drawCursorBlock( x:int, y:int ):void{
            graphics.drawRect( x, y, 10, 10 );
        }

        
        private function cursor( ex:int, ey:int, color:Boolean ):void{
            if( color ){
                graphics.lineStyle( 1, 0xffff0000 );
            }else{
                graphics.lineStyle( 1, 0xff444444 );
            }

            var canvasNo:int = getCanvasNo( ex, ey );
            var x:int, y:int;
            var i:int;
            switch( canvasNo ){
                case 0:
                x = int(ex/10);
                y = int((ey-stage.stageHeight/2)/10);
                drawCursorBlock( x*10, y*10+stage.stageHeight/2 );
                for( i = 0; i < size; i++ ){
                    drawCursorBlock( x*10, i*10 );
                    drawCursorBlock( i*10+stage.stageWidth/2, y*10+stage.stageHeight/2 );
                }
                break;
                case 1:
                x = int(ex/10);
                y = int(ey/10);
                drawCursorBlock( x*10, y*10 );
                for( i = 0; i < size; i++ ){
                    drawCursorBlock( x*10, i*10+stage.stageHeight/2 );
                    drawCursorBlock( (size-1-y)*10+stage.stageWidth/2, i*10+stage.stageHeight/2 );
                }
                break;
                case 2:
                x = int((ex-stage.stageWidth/2)/10);
                y = int((ey-stage.stageHeight/2)/10);
                drawCursorBlock( x*10+stage.stageWidth/2, y*10+stage.stageHeight/2 );
                for( i = 0; i < size; i++ ){
                    drawCursorBlock( i*10, (size-1-x)*10 );
                    drawCursorBlock( i*10, y*10+stage.stageHeight/2 );
                }
                break;
            }
        }
        
        
        private var dotPoint:Point = new Point();
        private function onMouseMove( event:MouseEvent ):void{
            cursor( dotPoint.x, dotPoint.y, false );
            cursor( event.stageX, event.stageY, true );
            
            dotPoint.x = event.stageX;
            dotPoint.y = event.stageY;
        }
        

        private function onClick( event:MouseEvent ):void{
            addPoint(event.stageX,event.stageY);
        }
        
        private function getCanvasNo( ex: int, ey: int ):int{
            if( ex < stage.stageWidth/2 && ey < stage.stageHeight/2 ){
                return 1;
            }
            if( ex < stage.stageWidth/2 && ey > stage.stageHeight/2 ){
                return 0;
            }
            if( ex > stage.stageWidth/2 && ey > stage.stageHeight/2 ){
                return 2;
            }
            return -1;
        }

        private function addPoint( ex: int, ey: int ): void{
            var x:int, y:int, z:int;
            switch( getCanvasNo( ex, ey ) ){
                case 1:
                x = int(ex/10);//%size;
                z = (size-1)-int(ey/10);//%size;
                setBlock( x*10, (size-1-z)*10 );
                canvas[1].setPixel( x, z, 0xffffff );
                for( y = 0; y < size; y++ ){
                    if( canvas[0].getPixel( x, y ) == 0xffffff && canvas[2].getPixel( z, y ) == 0xffffff ){
                        view.addBlock(x,y,z);
                    }
                }
                break;
                case 0:
                x = int(ex/10);//%size;
                y = int((ey-stage.stageHeight/2)/10);//%size;
                setBlock( x*10, y*10 + stage.stageHeight/2 );
                canvas[0].setPixel( x, y, 0xffffff );
                for( z = 0; z < size; z++ ){
                    if( canvas[1].getPixel( x, z ) == 0xffffff && canvas[2].getPixel( z, y ) == 0xffffff ){
                        view.addBlock(x,y,z);
                    }
                }
                break;
                case 2:
                z = int((ex-stage.stageWidth/2)/10);//%size;
                y = int((ey-stage.stageHeight/2)/10);//%size;
                setBlock( z*10 + stage.stageWidth/2, y*10 + stage.stageHeight/2 );
                canvas[2].setPixel( z, y, 0xffffff );
                for( x = 0; x < size; x++ ){
                    if( canvas[0].getPixel( x, y ) == 0xffffff && canvas[1].getPixel( x, z ) == 0xffffff ){
                        view.addBlock(x,y,z);
                    }
                }
                break;
            }
        }
    }
}



import flash.events.Event;
import org.papervision3d.lights.PointLight3D;
import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
import org.papervision3d.materials.utils.MaterialsList;
import org.papervision3d.objects.DisplayObject3D;
import org.papervision3d.objects.primitives.Cube;
import org.papervision3d.view.BasicView;

[SWF(backgroundColor=0)]
class View extends BasicView {
    private var wrap:DisplayObject3D;

    public function View():void {
    
        opaqueBackground = 0x0;
                    
        wrap = new DisplayObject3D();
        scene.addChild(wrap);
        
        startRendering();
        camera.z = -20000;

        addEventListener(Event.ENTER_FRAME, loop);
    }

    private function loop(e:Event):void {
        wrap.rotationY += 5 * (mouseX / stage.stageWidth - 0.5);
    }
    
    public function addBlock( x: int, y: int, z: int ): void{
        var light:PointLight3D = new PointLight3D();
        var m:FlatShadeMaterial = new FlatShadeMaterial( light, 0xFFFFFF, 0x222222);
        var ml: MaterialsList = new MaterialsList({all: m});
        var cube: Cube = new Cube(ml);
        cube.x = 500*x;
        cube.y = -500*y;
        cube.z = 500*z;
        wrap.addChild(cube);
    }
}



