/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bMEY
 */

package {
  import flash.display.Sprite;
  import flash.text.TextField;

  import funnel.*;

  public class MeasureTemperature extends Sprite {
    private var arduino:Arduino;

    // 温度センサに接続したピン
    private var sensorPin:Pin;

    // 温度を表示するテキストフィールド
    private var textField:TextField;

    public function MeasureTemperature() {
      arduino = new Arduino(Arduino.FIRMATA);

      // センサに接続したピンにスケーラとイベントリスナをセット
      sensorPin = arduino.analogPin(0);
      sensorPin.addFilter(new Scaler(0, 0.2, 0, 100));
      sensorPin.addEventListener(PinEvent.CHANGE, onChange);

      // 温度を表示するテキストフィールドを追加
      textField = new TextField();
      addChild(textField);
    }

    // センサの値に変化があれば以下を実行
    private function onChange(e:PinEvent):void {
      textField.text = "Temperature: ";
      textField.appendText(sensorPin.value + " ºC");
    }
  }
}