/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bM5o
 */

// forked from codeonwort's sunglow
package {
    
    import flash.display.Loader
    import flash.net.URLRequest
    
    import flash.events.Event
    import flash.display.Shape
    import flash.display.Sprite
    import flash.display.Bitmap
    import flash.display.BitmapData
    import flash.geom.Matrix
    import flash.geom.Point
    import flash.events.MouseEvent
    
    public class SunglowTest extends Sprite {
        
        private var dst:BitmapData
        private var sun:Shape
        
        public function SunglowTest() {
            var img:Loader = new Loader
            //http://a0.twimg.com/profile_images/1389298946/me_photo_cold_flash.png
            
            //img.load(new URLRequest("http://clug.cau.ac.kr/~codeonwort/wonderfl/sea.jpg"))
            img.load(new URLRequest("http://a0.twimg.com/profile_images/1389298946/me_photo_cold_flash.png"))
            img.contentLoaderInfo.addEventListener("complete", img_loaded)
            addChild(img)
        }
        
        private function img_loaded(e:Event):void {
            var img:Loader = e.target as Loader
            
            dst = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0)
            addChild(new Bitmap(dst)).blendMode = "add"
            
            sun = new Shape
            sun.graphics.beginFill(0xff9952, 0.04)
            sun.graphics.drawCircle(0, 0, 27)
            sun.graphics.endFill()
            
            mm()
            stage.addEventListener("mouseMove", mm)
        }
        
        private function addSun(tx:Number, ty:Number, scale:Number):void {
            dst.fillRect(dst.rect, 0x0)
            var mat:Matrix = new Matrix
            mat.translate(tx, ty)
            var r:Number = sun.width / 2
            var maxR:Number = Math.max(dist(0, 0), dist(stage.stageWidth, 0), dist(0, stage.stageHeight), dist(stage.stageWidth, stage.stageHeight))
            while(r < maxR){
                dst.draw(sun, mat, null, "add")
                mat.translate(-tx, -ty)
                mat.scale(scale, scale)
                mat.translate(tx, ty)
                r *= scale
            }
            function dist(xx:Number, yy:Number):Number {
                return Math.sqrt(Math.pow(xx - tx, 2) + Math.pow(yy - ty, 2))
            }
        }
        
        private function mm(e:MouseEvent = null):void {
            addSun(mouseX, mouseY, 1.04)
        }
        
    }
    
}