/**
 * Copyright ikekou ( http://wonderfl.net/user/ikekou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bLek
 */

//まんまです。自分用メモ。

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IMEEvent;
	import flash.system.Capabilities;
	import flash.system.IME;
	import flash.system.IMEConversionMode;
	import flash.system.System;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFieldType;
	
	public class Main extends Sprite 
	{
		private var inputTxt:TextField;
		private var outputTxt:TextField;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point			

			inputTxt = new TextField();
			inputTxt.type = TextFieldType.INPUT;
			inputTxt.width = 200;
			inputTxt.height = 18;
			inputTxt.border = true;
			inputTxt.background = true;
			addChild(inputTxt);

			outputTxt = new TextField();
			outputTxt.autoSize = TextFieldAutoSize.LEFT;
			outputTxt.y = 20;
			addChild(outputTxt);

			if (Capabilities.hasIME)
			{
				IME.enabled = true;
				try
				{
					IME.conversionMode = IMEConversionMode.JAPANESE_HIRAGANA;
				}
				catch (error:Error)
				{
					outputTxt.text = "Unable to change IME.";
				}
				System.ime.addEventListener(IMEEvent.IME_COMPOSITION, imeCompositionHandler);
				
			}
			else
			{
				outputTxt.text = "Please install IME and try again.";
			}
		}
		
		private function imeCompositionHandler(event:IMEEvent):void
		{
			outputTxt.text = "you typed: " + event.text;
		}
		
	}
	
}


