/**
 * Copyright fumix ( http://wonderfl.net/user/fumix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bLAG
 */

package {
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.display.Sprite;

    /**
     * @author fumix
     */
    public class EffectSoundEditor extends Sprite {
        private var _w : int;
        private var _h : int;
        private var inputSound : Label;
        private var inputLoopStep : Label;
        private var inputSoundStep : Label;
        private var inputEvolution : Label;
        private var inputType : Label;
        private var driver : SiONDriver;
        private var mml : String;
        public function EffectSoundEditor() {
            if (stage) initialize();
            else addEventListener(Event.ADDED_TO_STAGE, initialize);

        }

        private function initialize(event : Event=null) : void {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);            

            // ステージ設定
            // stage.quality = StageQuality.LOW;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            // 背景設定
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            var bmd : BitmapData = new BitmapData(_w, _h, false, 0xFFFFFF);
            addChild(new Bitmap(bmd));
            
            // UI設定
            var layoutSound : LayoutWidth = new LayoutWidth(3);
            var arrowLeftSound : Button = new Button('<', 25);
            arrowLeftSound.addEventListener(MouseEvent.MOUSE_DOWN, onLeftSound);
            var arrowRightSound : Button = new Button('>', 25);
            arrowRightSound.addEventListener(MouseEvent.MOUSE_DOWN, onRightSound);
            var labelSound : Label = new Label('SOUND', 160);
            inputSound = new Label('15',55,true,true);
            layoutSound.addChild(arrowLeftSound);
            layoutSound.addChild(arrowRightSound);
            layoutSound.addChild(labelSound);
            layoutSound.addChild(inputSound);

            var layoutLoopStep : LayoutWidth = new LayoutWidth(3);
            var arrowLeftLoopStep : Button = new Button('<', 25);
            arrowLeftLoopStep.addEventListener(MouseEvent.MOUSE_DOWN, onLeftLoopStep);
            var arrowRightLoopStep : Button = new Button('>', 25);
            arrowRightLoopStep.addEventListener(MouseEvent.MOUSE_DOWN, onRightLoopStep);
            var labelLoopStep : Label = new Label('LOOP STEP', 160);
            inputLoopStep = new Label('50',55,true,true);
            layoutLoopStep.addChild(arrowLeftLoopStep);
            layoutLoopStep.addChild(arrowRightLoopStep);
            layoutLoopStep.addChild(labelLoopStep);
            layoutLoopStep.addChild(inputLoopStep);

            var layoutSoundStep : LayoutWidth = new LayoutWidth(3);
            var arrowLeftSoundStep : Button = new Button('<', 25);
            arrowLeftSoundStep.addEventListener(MouseEvent.MOUSE_DOWN, onLeftSoundStep);
            var arrowRightSoundStep : Button = new Button('>', 25);
            arrowRightSoundStep.addEventListener(MouseEvent.MOUSE_DOWN, onRighttSoundStep);
            var labelSoundStep : Label = new Label('SOUND STEP', 160);
            inputSoundStep = new Label('30',55,true,true);
            layoutSoundStep.addChild(arrowLeftSoundStep);
            layoutSoundStep.addChild(arrowRightSoundStep);
            layoutSoundStep.addChild(labelSoundStep);
            layoutSoundStep.addChild(inputSoundStep);

            var layoutEvolution : LayoutWidth = new LayoutWidth(3);
            var arrowLeftEvolution : Button = new Button('<', 25);
            arrowLeftEvolution.addEventListener(MouseEvent.MOUSE_DOWN, onLeftEvolution);
            var arrowRightEvolution : Button = new Button('>', 25);
            arrowRightEvolution.addEventListener(MouseEvent.MOUSE_DOWN, onRightEvolution);
            var labelEvolution : Label = new Label('EVOLUTION', 160);
            inputEvolution = new Label('DOWN',55,true,true);
            layoutEvolution.addChild(arrowLeftEvolution);
            layoutEvolution.addChild(arrowRightEvolution);
            layoutEvolution.addChild(labelEvolution);
            layoutEvolution.addChild(inputEvolution);

            var layoutType : LayoutWidth = new LayoutWidth(3);
            var arrowLeftType : Button = new Button('<', 25);
            arrowLeftType.addEventListener(MouseEvent.MOUSE_DOWN, onLeftType);
            var arrowRightType : Button = new Button('>', 25);
            arrowRightType.addEventListener(MouseEvent.MOUSE_DOWN, onRightType);
            var labelType : Label = new Label('TYPE', 160);
            inputType = new Label('<<<',55,true,true);
            layoutType.addChild(arrowLeftType);
            layoutType.addChild(arrowRightType);
            layoutType.addChild(labelType);
            layoutType.addChild(inputType);

            var layoutButton : LayoutWidth = new LayoutWidth(10);
            var playButton : Button = new Button('PLAY >>', 60);
            playButton.addEventListener(MouseEvent.CLICK, onPlay);
            var stopButton : Button = new Button('STOP []', 60);
            stopButton.addEventListener(MouseEvent.CLICK, onStop);
            layoutButton.addChild(playButton);
            layoutButton.addChild(stopButton);

            var layout : LayoutHeight = new LayoutHeight(20);
            layout.x = layout.y = 40;
            layout.addChild(layoutSound);
            layout.addChild(layoutLoopStep);
            layout.addChild(layoutSoundStep);
            layout.addChild(layoutEvolution);
            layout.addChild(layoutType);
            layout.addChild(layoutButton);
            addChild(layout);

            //SiON設定
            driver = new SiONDriver(8192);
            //MMLデータ
            mml = new String();
            
        }

        private function onRightType(event : MouseEvent) : void {
                switch(inputType.text){
                    case '===':
                        inputType.text = ">>>";
                        break;
                    case '>>>':
                        inputType.text = "<<<";
                        break;
                    case '<<<':
                        inputType.text = "===";
                        break;
                    default:
                }
        }

        private function onLeftType(event : MouseEvent) : void {
                switch(inputType.text){
                    case '===':
                        inputType.text = "<<<";
                        break;
                    case '>>>':
                        inputType.text = "===";
                        break;
                    case '<<<':
                        inputType.text = ">>>";
                        break;
                    default:
                }
        }

        private function onRightEvolution(event : MouseEvent) : void {
                    switch(inputEvolution.text){
                        case 'UP':
                            inputEvolution.text = "DOWN";
                            break;
                        case 'DOWN':
                            inputEvolution.text = "UP";
                            break;
                        default:
                    }
        }

        private function onLeftEvolution(event : MouseEvent) : void {
                    switch(inputEvolution.text){
                        case 'UP':
                            inputEvolution.text = "DOWN";
                            break;
                        case 'DOWN':
                            inputEvolution.text = "UP";
                            break;
                        default:
                    }
        }

        private function onRighttSoundStep(event : MouseEvent) : void {
            var loop:Number = Number(inputSoundStep.text);
            if(loop >= 255) return;
            loop++;
            inputSoundStep.text = String(loop);
        }

        private function onLeftSoundStep(event : MouseEvent) : void {
            var loop:Number = Number(inputSoundStep.text);
            if(loop <= 1) return;
            loop--;
            inputSoundStep.text = String(loop);
        }

        private function onRightLoopStep(event : MouseEvent) : void {
            var loop:Number = Number(inputLoopStep.text);
            if(loop >= 255) return;
            loop++;
            inputLoopStep.text = String(loop);
        }

        private function onLeftLoopStep(event : MouseEvent) : void {
            var loop:Number = Number(inputLoopStep.text);
            if(loop <= 1) return;
            loop--;
            inputLoopStep.text = String(loop);
        }

        private function onRightSound(event : MouseEvent) : void {
            var sound:Number = Number(inputSound.text);
            if(sound >= 31) return;
            sound++;
            inputSound.text = String(sound);
        }

        private function onLeftSound(event : MouseEvent) : void {
            var sound:Number = Number(inputSound.text);
            if(sound <= 0) return;
            sound--;
            inputSound.text = String(sound);
        }

        private function onStop(event : MouseEvent) : void {
            driver.stop();
        } 

        private function onPlay(event : MouseEvent) : void {
            trace(generateMML());
            var note : SiONData = driver.compile(generateMML());
            driver.play(note);
        }
        private function generateMML():String{
            var sound:Number = Number(inputSound.text);
            var loopStep:Number = Number(inputLoopStep.text);
            var soundStep:Number = Number(inputSoundStep.text);
            var v:int;
            var k:int;
            var m:String = 't250;s63q8l64o0';
            for (var i : int = 0; i < 256; i=i+loopStep) {
                switch(inputType.text){
                    case '===':
                        v = 15;
                        break;
                    case '>>>':
                        v = 15 - Math.floor(i/16);
                        break;
                    case '<<<':
                        v = Math.floor(i/16);
                        break;
                    default:
                }
                for (var j : int = 0; j < 256; j=j+soundStep) {
                    switch(inputEvolution.text){
                        case 'UP':
                            k = sound * 256 + j*2;
                            break;
                        case 'DOWN':
                            k = sound * 256 +(255 - j)*2;
                            break;
                        default:
                    }
                    //音色合成
                    m = m + 'k'+ k + 'v'+ v + 'c';
                }
            }
            m = m + 'k'+ 0 + 'v'+ 0 + 'c';
            
            
            return m;
            
        }
    }
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.SimpleButton;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.display.DisplayObject;


class Button extends SimpleButton {
    public function Button(label : String, width : int = 0) : void {
        var up : Sprite = _buildImage(label, 0x0, width);
        var over : Sprite = _buildImage(label, 0x333333, width);
        var down : Sprite = _buildImage(label, 0x333333, width);
        down.y = 1;
        super(up, over, down, up);
    }

    private static function _buildImage(label : String, color : int, width : int = 0) : Sprite {
        var text : TextField = new TextField();
        text.defaultTextFormat = new TextFormat('Verdana', 10, 0xffffff, true, null, null, null, null, TextFormatAlign.CENTER);
        text.autoSize = TextFieldAutoSize.LEFT;
        text.selectable = false;
        text.text = label;
        text.x = (width - text.width) >> 1;
        text.y = 5;
        var base : Shape = new Shape();
        var g : Graphics = base.graphics;
        g.beginFill(color);
        g.drawRect(0, 0, width, text.height + 10);
        g.endFill();
        var sp : Sprite = new Sprite();
        sp.addChild(base);
        sp.addChild(text);
        return sp;
    }
}

class Label extends Sprite {
    private var _text : TextField;
    public function Label(label : String, width : int = 0,border:Boolean = false,center:Boolean = false ) : void {
        var up : Sprite = _buildImage(label, 0x0, width,border,center);
        addChild(up);
    }

    private function _buildImage(label : String, color : int, width : int = 0,border:Boolean = false,center:Boolean = false ) : Sprite {
        _text = new TextField();
        _text.defaultTextFormat = new TextFormat('Verdana', 14, 0x000000, true, null, null, null, null, TextFormatAlign.CENTER);
        _text.autoSize = TextFieldAutoSize.LEFT;
        if(center) _text.autoSize = TextFieldAutoSize.CENTER;
        _text.selectable = false;
        _text.text = label;

        if(center) _text.x = (width - _text.width) >> 1;
        _text.y = 3;
        var base : Shape = new Shape();
        var g : Graphics = base.graphics;
        if(border) g.lineStyle(1,0x0);
        g.beginFill(color,0);
        g.drawRect(0, 0, width, _text.height + 6);
        g.endFill();
        var sp : Sprite = new Sprite();
        sp.addChild(base);
        sp.addChild(_text);
        return sp;
    }

    public function get text() : String {
        return _text.text;
    }

    public function set text(text : String) : void {
        _text.text = text;
    }
}

class LayoutHeight extends Sprite {
    private var _interval : int;
    private var _nextY : int;

    public function LayoutHeight(interval : int = 5,margin:int = 0) {
        _interval = interval;
        _nextY = margin;
    }
    override public function addChild(child : DisplayObject) : DisplayObject {
        child.y = _nextY;
        _nextY += child.height+_interval;
        return super.addChild(child);
    }
}

class LayoutWidth extends Sprite {
    private var _interval : int;
    private var _nextX : int;
    public function LayoutWidth(interval:int = 5,margin:int = 0) {
        _interval = interval;
        _nextX = margin;
    }
    override public function addChild(child : DisplayObject) : DisplayObject {
        child.x = _nextX;
        _nextX += child.width+_interval;
        return super.addChild(child);
    }
}