/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bKsh
 */

package 
{
    import caurina.transitions.properties.ColorShortcuts;
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    
    
    /**
     * ...
     * @author gaina
     */
    [SWF(width="465",height="465",frameRate="30")]
    public class Main extends Sprite 
    {
        private var QTY:int = 8;
        
        private var _array:Array;
        private var _sp:Sprite;
        private var _sp_switch:Boolean = true;
        private var _line:Array;
        private var _line_switch:Boolean = true;
        private var _blend_swicth:Boolean = true;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            ColorShortcuts.init();
            
            _line = LineCircles();
            _array = Circles();
            
            var _sound:PlaySound = new PlaySound("http://www.takasumi-nagai.com/soundfiles/sound007.mp3");
            
            _sp = new Sprite();
            _sp.graphics.beginFill(0xFF0000);
            _sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            _sp.graphics.endFill();
            addChild(_sp);
            _sp.blendMode = "invert";
            _sp.addEventListener(MouseEvent.CLICK, BlendSwitch);
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void 
        {
            var _byte:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_byte, true, 0);
            
            for (var i:int = 0; i < QTY; i++) {
                _byte.position = i * 64;
                var p:Number = 0;
                var q:Number = 0;
                for (var j:int = 0; j < 64; j++) {
                    p += _byte.readFloat();
                    
                    if (i == 0) {
                        q = Math.max(0.3, p / 14);
                    }else {
                        q = Math.max(0.3, p / 4);
                    }
                    
                    if (i == 6 && p > 3.5) {
                        Switch();
                    }
                    if (i == 7 && p > 3) {
                        VisibleSwicth();
                    }
                }
                Tweener.addTween(_array[i] as Sprite, { scaleX:q, scaleY:q, time:0.5 } );
                Tweener.addTween(_line[i] as Sprite, { scaleX:q, scaleY:q, time:0.5 } );
            }
            
        }
        
        private function Switch():void
        {
            if (_sp_switch) {
                Tweener.addTween(_sp, {_color:0x000000 } );
                _sp_switch = false;
            } else {
                Tweener.addTween(_sp, {_color:Math.random()*0xFFFFFF } );
                _sp_switch = true;
            }
        }
        
        private function VisibleSwicth():void
        {
            if (_line_switch) {
                for (var i:int = 0; i < QTY; i++) {
                    _array[i].visible = false;
                    _line[i].visible = true;
                }
                _line_switch = false;
            } else {
                for (var j:int = 0; j < QTY; j++) {
                    _array[j].visible = true;
                    _line[j].visible = false;
                }
                _line_switch = true;
            }
        }
        
        private function BlendSwitch(e:MouseEvent):void 
        {
            if (_blend_swicth) {
                _sp.blendMode = "screen";
                _blend_swicth = false;
            } else {
                _sp.blendMode = "invert";
                _blend_swicth = true;
            }
        }
        
        
        private function Circles():Array
        {
            var _arr:Array = [];
            for (var i:int = 0; i < QTY; i++)
            {
                var _radius:Number = 465 - 465 / QTY * i;
                var _circle:Sprite = new Sprite();
                _circle.graphics.beginFill(0);
                _circle.graphics.lineStyle(2, 0xFFFFFF);
                _circle.graphics.drawCircle(0, 0, _radius);
                _circle.graphics.endFill();
                _circle.x = stage.stageWidth / 2;
                _circle.y = stage.stageHeight / 2;
                addChild(_circle);
                _arr.push(_circle);
            }
            return _arr;
        }
        
        private function LineCircles():Array
        {
            var _arr:Array = [];
            for (var i:int = 0; i < QTY; i++)
            {
                var _radius:Number = 465 - 465 / QTY * i;
                var _circle:Sprite = new Sprite();
                _circle.graphics.lineStyle(2, 0);
                _circle.graphics.drawCircle(0, 0, _radius);
                _circle.graphics.endFill();
                _circle.x = stage.stageWidth / 2;
                _circle.y = stage.stageHeight / 2;
                addChild(_circle);
                _arr.push(_circle);
            }
            return _arr;
        }
        
    }
    
}

import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class PlaySound
{
    private var sound:Sound;

        public function PlaySound(url:String)
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            sound.play(0, 10, new SoundTransform(0.3, 0));
        }
}