/**
 * Copyright more_more_for ( http://wonderfl.net/user/more_more_for )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bKmH
 */

/* Text Layout Framework Test02
** 欧文と日本語の違いの実験。それとTextLayoutTextLineFactoryについての試し。
** 欧文が綺麗に揃わないので欧文泣き別れにして収めてみた（組版的には問題だが）
** 各所のコメントアウトは色々試した結果なので気にせず。
	** reference--------
	** http://quotations.livedoor.biz/archives/51355581.html(アインシュタインの相対性に関する英語の名言)
	** http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/index.html (Adobe)
	/* auther--------
	** more_more_for
	*/
package
{
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.geom.Rectangle;
    import flash.text.engine.TextLine;
    import flash.text.engine.JustificationStyle;
    import flash.text.engine.Kerning
    import flash.text.engine.BreakOpportunity;
    import caurina.transitions.Tweener;
    
    import flashx.textLayout.elements.ParagraphElement;
    import flashx.textLayout.elements.SpanElement;
    import flashx.textLayout.elements.TextFlow;
    import flashx.textLayout.factory.TextFlowTextLineFactory;
    import flashx.textLayout.formats.TextLayoutFormat;
    import flashx.textLayout.formats.JustificationRule;
    import flashx.textLayout.formats.BlockProgression;
    import flashx.textLayout.formats.TextAlign;
    import flashx.textLayout.formats.LineBreak;
    import flashx.textLayout.formats.TextJustify;

    public class TextFlowTextLineFactory_example extends Sprite
    {
    	private var _txtFormat:TextLayoutFormat;
    	private var _txtFormatJ:TextLayoutFormat;
    	private var _factory:TextFlowTextLineFactory;
    	private var _txtFlow:TextFlow;
    	private var _paragraphEl:ParagraphElement;
    	private var _spanEl:SpanElement;
    	
        public function TextFlowTextLineFactory_example()
        {
        	//背景設定
        	graphics.beginFill(0x330000,0.8);
            graphics.drawRect( 0, 0, 465, 465 );
            graphics.endFill();
            graphics.beginFill(0xFFFFFF,0.1);
            graphics.drawRect( 60, 65, 350, 144 );
            graphics.endFill();
        	
        	//テキストのフォーマットを設定
        	//英文
        	_txtFormat = new TextLayoutFormat();
            _txtFormat.fontFamily = "Times new roman, _sans";
            _txtFormat.fontSize = 24;
            _txtFormat.color = 0xFFFFFF;
            _txtFormat.locale = "en";
            _txtFormat.textAlpha = 0.8;
            _txtFormat.textAlign = TextAlign.JUSTIFY;
            //_txtFormat.lineBreak = LineBreak.TO_FIT;
            _txtFormat.justificationRule = JustificationRule.SPACE;
            _txtFormat.kerning = Kerning.ON;
            //_txtFormat.textJustify = TextJustify.DISTRIBUTE;
            _txtFormat.breakOpportunity = BreakOpportunity.ANY;
            //_txtFormat.justificationStyle = JustificationStyle.PUSH_IN_KINSOKU; PRIORITIZE_LEAST_ADJUSTMENT PUSH_OUT_ONLY
            //日本語
            _txtFormatJ = new TextLayoutFormat();
            _txtFormatJ.fontFamily = "Kozuka Mincho Pro M";
            _txtFormatJ.fontSize = 14;
            _txtFormatJ.lineHeight = 23;
            _txtFormatJ.color = 0xFFFFFF;
            _txtFormatJ.textAlpha = 0.9;
            _txtFormatJ.locale = "ja";
            _txtFormatJ.textAlign = TextAlign.JUSTIFY;
            _txtFormatJ.justificationRule = JustificationRule.EAST_ASIAN;
            _txtFormatJ.justificationStyle = JustificationStyle.PUSH_IN_KINSOKU;
            //_txtFormatJ.blockProgression = BlockProgression.RL;
            
            //TextLineFactoryを設定
            _factory = new TextFlowTextLineFactory();
            _factory.compositionBounds = new Rectangle( 60, 65, 350, 360 );
            
            //TextFlowを設定
            _txtFlow = new TextFlow();
            
            //paragraphElementを設定
            _paragraphEl = new ParagraphElement();
            
            //SpanElementを設定
            _spanEl = new SpanElement();
            _spanEl.text = "When you sit with a nice girl for two hours,you think it's only a minute.But when you sit on a hot stove for a minute,you think it's two hours. That's relativity. —— Albert Einstein";            
            _spanEl.format = _txtFormat;
            
            //英文を追加
            _paragraphEl.addChild( _spanEl ); 
            _txtFlow.addChild( _paragraphEl );
            _factory.createTextLines( useTextLines, _txtFlow );
            
            //日本語訳を追加
            _factory.compositionBounds = new Rectangle( 60, 265, 364, 200 );
            _spanEl.format = _txtFormatJ;
            _spanEl.text = "2時間可愛い女の子と一緒に座っていたら、たった１分くらいに感じるだろう。でも、熱いコンロの上に1分間座ったら、それは2時間に感じられる。それが相対性だ。\n —— アルベルト・アインシュタイン"
            _factory.createTextLines( useTextLines, _txtFlow );
            
            var mov:DisplayObject = this.getChildAt(8)
            mov.x = 195;
            mov.y = 450;
            mov.alpha = 0;
            
            tweenObj(mov);
        }
        
        public function tweenObj(obj:DisplayObject):void{
        	var _obj = obj;
        	Tweener.addTween(_obj, {y:339+19, alpha:1, time:1, delay:0.1, transition:"easeOutCubic"}); 
        }
        
        private function useTextLines( lineOrShape:DisplayObject ):void
        {
            this.addChild( lineOrShape );
        }
        
    }
}
