/**
 * Copyright mausuit ( http://wonderfl.net/user/mausuit )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bKdv
 */

// forked from mausuit's mausuit: Pixels motion on 2011-7-10
// forked from mausuit's flash on 2011-7-10
package
{
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.utils.Timer;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    
    public class FlashTest extends Sprite
    {
        
        private var _pixelsData:BitmapData         = new BitmapData(465, 465, true, 0xff000000);
        private var _pixelsArea:Bitmap             = new Bitmap(_pixelsData, "auto", true);
        private var _areaCTransform:ColorTransform = new ColorTransform();
        private var _renderTimer:Timer             = new Timer(30);
        private var _pixelsCollection:Array        = [];
        private var _appBackground:Sprite          = new Sprite();
        
        // add random colors to particles
        private var _colorsCollection:Array        = [0xff00ff00, 0xffffffff];
        
        
        public function FlashTest()
        {
            addEventListener(Event.ADDED_TO_STAGE, setup);
        }
        
        
        private function setup(e:Event):void
        {
            _appBackground.graphics.beginFill(0x000000);
            _appBackground.graphics.drawRect(0, 0, 465, 465);
            addChild(_appBackground);
            
            _areaCTransform.alphaMultiplier = 0.99;
            
            // add pixel area to stage
            addChild(_pixelsArea);
            
            _renderTimer.addEventListener(TimerEvent.TIMER, render);
            
            // create Mouse move listener
            addEventListener(Event.ENTER_FRAME, createParticle);
            
            // initializing
            initApp();
        }
        
        
        
        private function createParticle(e:Event):void
        {
            var newPixel:Pixel;
            var inity:uint;
            
            for(var i:uint = 0; i < 10; i++)
            {
                inity = Math.round(Math.random() * 6 - 6);
                newPixel = new Pixel(mouseX, mouseY + inity);
                _pixelsCollection.push(newPixel);
            }
            
        }
        
        
        
        private function render(e:Event):void
        {
            var currentPixel:Pixel;
            
            _pixelsData.applyFilter(_pixelsData, _pixelsData.rect, new Point(0, 0), new BlurFilter(3, 3, 1));
            
            for(var i:Number = _pixelsCollection.length - 1; i >= 0; i--)
            {
                currentPixel = _pixelsCollection[i];
                currentPixel.updatePosition();
                
                if(currentPixel.x > 465)
                {
                    currentPixel.x = 0
                }
                else if(currentPixel.x < 0)
                {
                    currentPixel.x = 465;
                }
                
                if(currentPixel.y > 465)
                {
                    _pixelsCollection.splice(i, 1);
                }
                _pixelsData.setPixel32(currentPixel.x, currentPixel.y, _colorsCollection[i % _colorsCollection.length]);
            }
            
            _pixelsData.colorTransform(_pixelsData.rect, _areaCTransform);
            _pixelsArea.blendMode  = "add";
            _pixelsArea.bitmapData = _pixelsData;
        }
        
        private function initApp():void
        {
            _renderTimer.start();
        }
        
        private function finishApp():void
        {
            _renderTimer.stop();
        }



    }
}

internal class Pixel
{
    public var x:int;
    public var y:int;
    
    private var _vely:Number = Math.round(Math.random() * -5);
    private var _velx:Number = Math.round(Math.random() * 8 - 4);
    
    public function Pixel(posx:int, posy:int)
    {
        x = posx;
        y = posy;
        
        if(_velx > 0)
        {
            _velx += 1;
        }
        else
        {
            _velx -= 1;
        }

    }
    
    
    public function updatePosition():void
    {
        // Crazy movement in x to the right
        x += _velx;
        
        // normal UP movement
        y += Math.round(_vely);
        
        _vely += 0.5;
    }
}