/**
 * Copyright Kitosan1986 ( http://wonderfl.net/user/Kitosan1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bJzh
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(backgroundColor="#FFFFFF",width='465',height='465', frameRate=60)]
    
    public class Balls extends Sprite {
    	
    		public var numBalls:uint = 500;
		public var bounce:Number = -1.0;
		public var balls:Array = new Array();
		public var xalpha:Number = 0.7;
		public var velocity:Number = 0.5;
		
        public function Balls() {
        		for (var i:uint = 0; i < numBalls; i++) {
			 var radius:Number = Math.random() * 5 + 3;
			 var ball:Ball = new Ball(radius, Math.random()*0xffffff, xalpha);
			 ball.mass = radius;
			 ball.x = Math.random() * stage.stageWidth;
			 ball.y = Math.random() * stage.stageHeight;
			 ball.vx = (Math.random() * 10 - 5) * velocity;
			 ball.vy = (Math.random() * 10 - 5) * velocity;
			 addChild(ball);
			 balls.push(ball);
			}
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
            // write as3 code here..
        }
        
        public function onEnterFrame(event:Event):void {
        		 for (var i:uint = 0; i < numBalls; i++) {
			  var ball:Ball = balls[i];
			  ball.x += ball.vx;
			  ball.y += ball.vy;
			  checkWalls(ball);
			 }
			 //numBalls - 1であるとこに注意
			 for (i = 0; i < numBalls - 1; i++) {
			  var ballA:Ball = balls[i];
			  for (var j:Number = i + 1; j < numBalls; j++) {
			   var ballB:Ball = balls[j];
			   checkCollision(ballA, ballB);
			  }
			 }
			}
			
		public function checkWalls(ball:Ball):void {
			 if (ball.x + ball.radius > stage.stageWidth) {
			  ball.x = stage.stageWidth - ball.radius;
			  ball.vx *= bounce;
			 } else if (ball.x - ball.radius < 0) {
			  ball.x = ball.radius;
			  ball.vx *= bounce;
			 }
			 if (ball.y + ball.radius > stage.stageHeight) {
			  ball.y = stage.stageHeight - ball.radius;
			  ball.vy *= bounce;
			 } else if (ball.y - ball.radius < 0) {
			  ball.y = ball.radius;
			  ball.vy *= bounce;
 			 }
			}
			
			//それぞれのボールが衝突しているかどうかチェック
		public function checkCollision(ball0:Ball, ball1:Ball):void {
			 var dx:Number = ball1.x - ball0.x;
			 var dy:Number = ball1.y - ball0.y;
			 var dist:Number = Math.sqrt(dx*dx + dy*dy);
			 if (dist < ball0.radius + ball1.radius) {
				
			  var angle:Number = Math.atan2(dy, dx);
			  var cos:Number = Math.cos(angle);
			  var sin:Number = Math.sin(angle);
				
			  var pos0:Point = new Point(0, 0);
			  var pos1:Point = rotate(dx, dy, sin, cos, true);
			  var vel0:Point = rotate(ball0.vx, ball0.vy, sin, cos, true);
			  var vel1:Point = rotate(ball1.vx, ball1.vy, sin, cos, true);
				
			  var vxTotal:Number = vel0.x - vel1.x;
			  vel0.x = ((ball0.mass - ball1.mass) * vel0.x +
			    2 * ball1.mass * vel1.x) /
			  (ball0.mass + ball1.mass);
			  vel1.x = vxTotal + vel0.x;
				
			  var absV:Number = Math.abs(vel0.x) + Math.abs(vel1.x);
			  var overlap:Number = (ball0.radius + ball1.radius)
			  - Math.abs(pos0.x - pos1.x);
			  pos0.x += vel0.x / absV * overlap;
			  pos1.x += vel1.x / absV * overlap;
				
			  var pos0F:Object = rotate(pos0.x, pos0.y, sin, cos, false);
			  var pos1F:Object = rotate(pos1.x, pos1.y, sin, cos, false);
				
			 //注意！ball1を先に計算しないと、エラー発生
			  ball1.x = ball0.x + pos1F.x;
			  ball1.y = ball0.y + pos1F.y;
			  ball0.x = ball0.x + pos0F.x;
			  ball0.y = ball0.y + pos0F.y;
				
			  var vel0F:Object = rotate(vel0.x, vel0.y, sin, cos, false);
			  var vel1F:Object = rotate(vel1.x, vel1.y, sin, cos, false);
				
			  ball0.vx = vel0F.x;
			  ball0.vy = vel0F.y;
			  ball1.vx = vel1F.x;
			  ball1.vy = vel1F.y;
			 }
			}
			
			//計算できるように回転させる動作
		public function rotate(x:Number, y:Number, sin:Number, cos:Number, reverse:Boolean):Point {
				
			 var result:Point = new Point();
			 if (reverse) {
			  result.x = x * cos + y * sin;
			  result.y = y * cos - x * sin;
			 } else {
			  result.x = x * cos - y * sin;
			  result.y = y * cos + x * sin;
			 }
			 return result;
			}


    }
}

import flash.display.*;
class Ball extends Sprite
{
    public var vx:Number;
    public var vy:Number;
    public var mass:Number;
    public var radius:Number;
    //rd=半径、cl=色、al=アルファ値
    function Ball(rd:Number,cl:Number,al:Number)
    {       
    		
        this.graphics.beginFill(cl,al);
        this.graphics.drawCircle(0, 0, rd);
        this.graphics.endFill();
        radius = this.width/2 
        
        
    }
}