/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bJuX
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;

    public class GainerBasic_LED extends Sprite {
        // Gainerオブジェクト
        private var _gainer:Gainer;
        
        // ステージ中央に表示する矩形のボタン
        private var _squareButton:Sprite;

        public function GainerBasic_LED() {
            // Gainerのインスタンスを生成
            _gainer = new Gainer();

	        // 矩形のボタンを生成してステージ中央に追加
            _squareButton = new Sprite();
            _squareButton.graphics.beginFill(0x808080);
            _squareButton.graphics.drawRect(-25, -25, 50, 50);
            _squareButton.graphics.endFill();
            _squareButton.x = stage.stageWidth / 2;
            _squareButton.y = stage.stageHeight / 2;
            _squareButton.buttonMode = true;
            addChild(_squareButton);

            // Gainer GUIのインスタンスを生成して配置
            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            _gainer.gui = gui;

            // ボタンに対してイベントリスナをセット
            _squareButton.addEventListener(MouseEvent.MOUSE_DOWN, mousePressed);
            _squareButton.addEventListener(MouseEvent.MOUSE_UP, mouseReleased);
        }

        private function mousePressed(e:MouseEvent):void {
            // マウスボタンが押されたらI/Oモジュール上のLEDを点灯
            _gainer.led.on();
        }

        private function mouseReleased(e:MouseEvent):void {
            // マウスボタンが離されたらI/Oモジュール上のLEDを消灯
            _gainer.led.off();
        }
    }
}
