/**
 * Copyright aiz ( http://wonderfl.net/user/aiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bJ5LJ
 */

// forked from shohei909's 魚類タイピング
//タイピングゲーム作る LIVE_CODING 2010/08/01 8:39-13:46

//使用したコードと参考にさせていただいたコード
//FontLoder http://wonderfl.net/c/4tnW
//textanim example http://wonderfl.net/c/7cxt
//DynamicStack http://wonderfl.net/c/pb4T
//あずきフォントで遊ぼう http://wonderfl.net/c/f98N
//タイピングゲームをつくろう! http://wonderfl.net/c/8Al5
//魚群 http://wonderfl.net/c/9fSR



//画面クリック後、キータイプでタイピングスタート
//現在のところエンドレス。


//注意点
//魚の情報は、正しくなかったり、個人的な意見だったり、最新のものでなかったりする場合があります。
//個人のブログの情報を元にしたものや、Wikipediaで調べた情報も多いです。


//todo
//タイピングスタート前のカウントダウン
//タイピング結果の表示
//魚の情報を増やす。
//効果音の設定
//軽量化


//補足(flash内でかけなかったこととか)
/*
フィレオフィッシュについて
現在、マクドナルドのフィレオフィッシュにはスケソウダラが使われているそうです。
http://www.mcdonalds.co.jp/quality/basic_information/menu_info.php?mid=1110&cid=1


マゼランアイナメについて
「銀ムツ」という名前で流通していましたが、
ムツとは異なるマゼランアイナメを「銀ムツ」と呼ぶのは
優良誤解を与えるという理由で、「銀ムツ」の名前で売ることがJAS法で禁止されました。
でもスズキ目だから、カサゴ目のアイナメよりスズキ目のムツの方が近いのではないだろうか。
*/

package {
    import flash.events.*;
    import flash.display.Sprite;
    import flash.text.*;
    import net.wonderfl.utils.FontLoader;
    import caurina.transitions.Tweener;
    import com.bit101.components.ProgressBar;
    
    [SWF(width=465, height=465, backgroundColor=0xFFFFFF)]
    public class Game extends Sprite {
        static public const LIST:Array = [
            //temp { word : "" ,  kana : " ", info:"" },
            { word : "ガストロ" ,  kana : "がすとろ ", info:"スズキ目サバ科の白身魚。大型肉食魚。調理法は焼き魚、煮付け、唐揚げなど。" },
            { word : "キングクリップ" ,  kana : "きんぐくりっぷ ", info:"南半球でとれる白身魚。かつては「アマダイ」という名前が使われていた。高級魚として扱われている地域もある。" },
            { word : "スギ" ,  kana : "すぎ ", info:"クロカンパチとも呼ばれるスズキ目スギ科の魚。身は刺身やフライにされ、食用にされる。養殖も行われる。" },
            { word : "シルバーワレフ" ,  kana : "しるばーわれふ ", info:"ニュージーランドなどから輸入される魚。ブリの代用魚として使われることがある。" },
            { word : "マゼランアイナメ" ,  kana : "まぜらんあいなめ ", info:"メロとも呼ばれる、大型の深海魚。脂身が多く食用白身魚として広く利用されている。調理方法は照り焼き、焼き魚、煮付けなどなど。"},
            { word : "オヒョウ" ,  kana : "おひょう ", info:"カレイ目カレイ科の巨大な魚。大きいものでは3mを超える。タンパクな白身魚。回転寿司では「エンガワ」として使われることが多い。イギリス料理のフィッシュ・アンド・チップスにも使われる。" },
            { word : "メルルーサ" ,  kana : "めるるーさ ", info:"昔、マクドナルドのフィレオフィッシュに使われていた魚。スケトウダラの代用魚。乱獲で数が減っている。" },
            { word : "ブラックバス" ,  kana : "ぶらっくばす ", info:"外来魚として有名な魚。皮は臭みがあるが、皮を剥がして調理すれば白身で淡泊な味の美味な魚。" },
            { word : "ランプフィッシュ" ,  kana : "らんぷふぃっしゅ ", info:"カサゴ目ダンゴウオ科の魚。身は軟らかく、卵はキャビアの代用品に使われる。" },
            { word : "ブルーギル" ,  kana : "ぶるーぎる ", info:"琵琶湖などで外来魚として問題になっている魚。味は淡白で、食感は柔らかい。ムニエルにするとおいしいらしい。" },
            { word : "シイラ" ,  kana : "しいら ", info:"大型の肉食魚。フライ、煮付け、ムニエルなど調理法は様々。" },
            { word : "ナイルティラピア" ,  kana : "ないるてぃらぴあ ", info:"タイに似た味や触感がする川魚。養殖されている。" },
            { word : "カぺリン" ,  kana : "かぺりん ", info:"子持ちシシャモという名前で売られる魚。焼いて食べるとおいしい。" },
            { word : "カラスガレイ" ,  kana : "からすがれい ", info:"回転寿司の「エンガワ」に使われることが多い。ヒラメのエンガワより脂が乗っている。" },
            { word : "ナイルパーチ" ,  kana : "ないるぱーち ", info:"巨大な淡水魚。淡白な白身魚。フライはタルタルソースをかけて食べるとおいしい。" },
            { word : "アカマンボウ" ,  kana : "あかまんぼう ", info:"赤身の深海魚。マグロの代用魚で、「ネギトロ」として売られる場合がある。マンボウの仲間ではない。"  },
            { word : "アンギーラ" ,  kana : "あんぎーら ", info:"ウナギ目ウミヘビ科の魚。ウミヘビ科だけど爬虫類のヘビとは関係ない。マルアナゴと呼ばれる。"  },
            { word : "ホキ" ,  kana : "ほき ",　info:"モスバーガーのフィッシュバーガーに使われている白身魚。"}
        ];
        
        
        
        private var stack:DynamicStack = new DynamicStack(465,465);
        
        //スタート画面
        private var startSprite:StartSprite;
        //ゲーム画面
        private var gameSprite:GameSprite;
        //得点画面
        private var endSprite:EndSprite;
        
        static private const TF:Array = [  ["text","nowLoading..."],["autoSize",TextFieldAutoSize.LEFT], ["x",0],["y",0],["selectable",false]   ];
        static private const FR:Array = [  ["size",20] ];
        private var text:TextField;
        private var progress:ProgressBar;
        
        public function Game() {
            var fl :FontLoader = new FontLoader();
            fl.load( "Azuki" );
            fl.addEventListener( Event.COMPLETE, init );
            
            text=TFUtil.textField(TF,FR);
            addChild(text);
            progress = new ProgressBar(this,3,25);
            
            stage.addEventListener( "keyDown", start );
            fl.loader.contentLoaderInfo.addEventListener( "progress", loading );
        }
        
        public function init(e:Event):void{
            removeEventListener( "enterFrame", loading );
            Tweener.addTween(text, { delay:0, alpha:0, time:1, transition:"easeOutQuad"});
            Tweener.addTween(progress, { delay:0, alpha:0, time:1, transition:"easeOutQuad"});
            
            startSprite = new StartSprite(); 
            gameSprite = new GameSprite(); 
            endSprite = new EndSprite(); 
            
            stack.addEffect("blur");
            stack.addStack(startSprite); 
            stack.addStack(gameSprite);
            stack.addStack(endSprite);
            addChildAt(stack,0);
            graphics.beginFill(0xAAFFFF);
            graphics.drawRoundRect(0,0,465,465,10); 
        } 
        
        public function start(e:KeyboardEvent):void{
            switch(stack._selectedChild){
                case 0:
                    if(e.keyCode==229){
                        startSprite.setText("※日本語入力をオフにしてください");
                    }else{    
                        stack.display(1);
                        startSprite.hide();
                        gameSprite.view();
                    }
            }
        }
        public function loading(e:Event):void{
            progress.value = e.currentTarget.bytesLoaded / e.currentTarget.bytesTotal;
        }
    }
}
import flash.display.*;
import flash.events.Event;
import flash.filters.*;
import flash.geom.*;
import flash.text.*;
import caurina.transitions.Tweener;
import flupie.textanim.*;




//スタート画面
class StartSprite extends Sprite{
    static private const TF1:Array = [  ["embedFonts",true], ["text","魚類タイピング"],["autoSize",TextFieldAutoSize.LEFT],["x",15],["y",80],["selectable",false]   ];
    static private const FR1:Array = [  ["font","Azuki"], ["size",60], ["color",0x002266] ];
    
    static private const TF2:Array = [  ["embedFonts",true], ["text","みんな大好き？お魚のなまえでタイピングゲーム╂"],["autoSize",TextFieldAutoSize.LEFT],["x",0],["y",340],["selectable",false]   ];
    static private const FR2:Array = [  ["font","Azuki"], ["size",20], ["color",0x000022] ];
    
    static private const TF3:Array = [  ["embedFonts",true], ["text",""],["autoSize",TextFieldAutoSize.LEFT],["x",30],["y",280],["selectable",false]   ];
    static private const FR3:Array = [  ["font","Azuki"], ["size",24], ["color",0xEE1100] ];
    static private const tf3str:String = "※キータイプでタイピングスタート";
    
    private var title:TextField,text2:TextField,text3:TextField,anim1:TextAnim,anim2:TextAnim,anim3:TextAnim;
    public function StartSprite():void{
         title = TFUtil.textField(TF1,FR1); text2 = TFUtil.textField(TF2,FR2); text3 = TFUtil.textField(TF3,FR3);
         addChild(title); addChild(text2); addChild(text3);
         
         anim1 = new TextAnim(title); anim1.effects = titleEffect;
         anim2= new TextAnim(text2); anim2.effects = tf2Effect;  anim2.delay = 3000;
         anim3 = new TextAnim(text3); anim3.effects = tf3Effect;
         
         
         view();
    }
    
    private function titleEffect(block:TextAnimBlock):void{
        block.scaleX = block.scaleY = 0;
        var sc:Number = Math.random()*0.3 + 1.0;
        var r:Number = (2*Math.random() - 1)*2;
        Tweener.addTween(block, {delay:1, alpha:1, rotation:r,  scaleX:sc, scaleY:sc, time:2, transition:"easeOutBounce"});
    }
    private function tf2Effect(block:TextAnimBlock):void{
        Tweener.addTween(block, {delay:10, alpha:1, time:1});
    }
    private function tf3Effect(block:TextAnimBlock):void{
        block.scaleX = block.scaleY = 1.2;
        Tweener.addTween(block, {scaleX:1, scaleY:1, time:2, transition:"easeOutElastic"});
    }
    private function tf3Start(a:*=null):void{
         anim3.start();
    }
    public function view():void{
         anim1.start();
         anim2.start();
         anim2.onComplete = tf3Start;
         anim3.onComplete = tf3Start;
         anim1.blocksVisible = false;
         anim2.blocksVisible = false;
         anim3.blocksVisible = false;
         anim3.htmlText = tf3str;
         anim3.delay = 1000;
    }
    public function hide():void{
         anim3.onComplete = null;
    }
    public function setText(str:String):void{
         anim3.htmlText = str;
         anim3.blocksVisible = false;
         anim3.delay = 0;
         anim3.start();
         anim3.delay = 1000;
    }
}

//ゲーム中の画面
class GameSprite extends Sprite{
    static private const TF1:Array = [  ["embedFonts",true], ["text","※背景の魚と魚の名前とは、まったく関係ありません"],["x",0],["y",440],["autoSize",TextFieldAutoSize.LEFT],["selectable",false]   ];
    static private const FR1:Array = [  ["font","Azuki"], ["size",17], ["color",0xEE1100] ];
    
    static private const TF2:Array = [  ["embedFonts",true], ["text",""], ["x",5],["y",350],["width",455],["multiline",true],["wordWrap",true],["selectable",false]   ];
    static private const FR2:Array = [  ["font","Azuki"], ["size",15], ["color",0x002266] ];
    
    private var typing:Typing = new Typing();
    private var textField:TextField = new TextField();
    private var seaMap:SeaMap = new SeaMap(465,465,new ColorTransform(0.5,2,3,1));
    private var crowdMap:CrowdMap = new CrowdMap(465,465);
    
    private var text1:TextField,text2:TextField;
    public function GameSprite():void{
        text1 = TFUtil.textField(TF1,FR1);
        text2 = TFUtil.textField(TF2,FR2);
        
        typing.setWordList(Game.LIST);
        typing.addEventListener(TypingEvent.TYPE_WORD,onWordType);        //単語入力完了を監視するリスナー
        typing.addEventListener(TypingEvent.TYPE,onType);                //文字のタイプを監視するリスナー
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
        
        addChild(crowdMap);
        addChild(seaMap);
        addChild(typing);
        addChild(text1);
        addChild(text2);
    }
    private function onType(e:TypingEvent):void{
        if(e.miss<1){
            crowdMap.del();
            crowdMap.create(200, 140, 1, 14, 5);
        }
    }
    private function onWordType(e:TypingEvent):void{
        setTarget();
    }
    private function onEnterFrame(e:Event):void{}

    //画面を表示したときの処理
    public function view():void{
        restart();
    }
    public function hide():void{
        typing.stop();    
    }
 
    
    private function restart():void{
       //タイピングを開始します。
       typing.reset();
       typing.start();
       setTarget();
    }
    private function setTarget():void{
       typing.addTargetRandom(1);
       typing.typingWindows[0].x = 132;
       typing.typingWindows[0].y = 250;
       text2.text = typing.target[0].info;
    }
}




//結果を表示する画面
class EndSprite extends Sprite{
    static private const TF1:Array = [  ["embedFonts",true], ["text","結果"],["autoSize",TextFieldAutoSize.LEFT],["x",15],["y",80],["selectable",false]   ];
    static private const FR1:Array = [  ["font","Azuki"], ["size",60], ["color",0x002266] ];
}


//テキストフィールド用のユーティリティ
class TFUtil{
    //行列に従ってパラメータを設定したTextFieldを返します。
    static public function textField(arr:Array,format:Array=null):TextField{
        var tf:TextField = new TextField();
        if(format!=null){tf.defaultTextFormat = TFUtil.format(format);}
        for(var i:int=0;i<arr.length;i++){tf[arr[i][0]]=arr[i][1];}
        return tf;
    }
    //行列に従ってパラメータを設定したTextFormatを返します。
    static public function format(arr:Array):TextFormat{
        var f:TextFormat = new TextFormat(); 
        for(var i:int=0;i<arr.length;i++){f[arr[i][0]]=arr[i][1];}
        return f;
    }
    //行列に従ってパラメータをobjに設定します。
    static public function push(obj:Object,arr:Array):void{
        for(var i:int=0;i<arr.length;i++){obj[arr[i][0]]=arr[i][1];}
    }
}


class DynamicStack extends Sprite{
    private var w:int,h:int;
    private var transMap:BitmapData; 
    private var bitmap:Bitmap;
    private var maskMap:Bitmap = new Bitmap(new BitmapData(1,1));
    private var children:Vector.<DisplayObject> = new Vector.<DisplayObject>();
    public var _selectedChild:int = 0;
    private var effects:Vector.<Object> = new Vector.<Object>();
    private var time:int = 0;
    private var maxTime:int = 0;
    private var center:Point;
    public static const EFFECT_NAME:Array = ["fade","zoomOut","spin","slide","blur","color","flash"];
    public static const EFFECT_DATA:Array = [
        {name:"normal",type:"matrix",time:0,matrix:new Matrix() },
        {name:"fade",type:"matrix",time:30,matrix:new Matrix()  },
        {name:"zoomOut",type:"matrix",time:30,matrix:new Matrix(0.8,0,0,0.8) },
        {name:"spin",type:"matrix",time:30,matrix:new Matrix(0.98,-0.02,0.02,0.98) },
        {name:"slide",type:"matrix",time:30,matrix:new Matrix(1,0,0,1,-2,0) },
        {name:"blur",type:"filter",time:70,filter:new BlurFilter(2,2,1) },
        {name:"color",type:"filter",time:30,filter:new ColorMatrixFilter([0.8,0.2,0,0,10, 0,0.8,0.2,0,10, 0.2,0,0.8,0,10, 0,0,0,1,0]) },
        {name:"flash",type:"filter",time:30,filter:new ColorMatrixFilter([0.4,0.6,0,0,5, 0,0.3,0.8,0,5, 0.8,0,0.1,0,5, 0,0,0,1,5]) }
    ];
    public function DynamicStack(w:int,h:int):void{
        transMap = new BitmapData(w,h,true,0x01AAAAAA);
        bitmap =  new Bitmap(new BitmapData(w,h,true,0x0));
        bitmap.visible = false;　addChild(bitmap);
        addEventListener("enterFrame",onFrame);
        addChild(maskMap); maskMap.scaleX = w; maskMap.scaleY = h;  mask = maskMap;
    }
    public function addStack(obj:DisplayObject):DisplayObject{
        children.push(obj); addChildAt(obj,0); obj.visible = false;
        return obj;
    }
    public function display(index:int):DisplayObject{
        children[_selectedChild].visible = false;
        var size:int = effects.length;
        time = 0;
        for(var i:int=0;i<size;i++){ time += effects[i].time; }
        maxTime = time;
        if(time>0){ 
            bitmap.visible = true;
            var b:BitmapData = bitmap.bitmapData;
            b.fillRect(b.rect,0);
            b.draw( children[_selectedChild] );
        }
        _selectedChild = index;
        return children[index];
    }
    
    //エフェクトの追加
    public function addEffect(effectName:String="normal"):void{ effects.push(effect(effectName)); }
    //エフェクトの削除 (index　から　lengthの数だけ削除,　ただし、length=-1で以降全て削除)
    public function removeEffect(index:int=0,length:int=1):Object{ return effects.splice(index, length) }
    
    //オブジェクトを渡して、エフェクトを追加します。
    public function addEffectObject(effect:Object):void{ effects.push(effect) }
    
    //指定された名前のEffectを返します
    static public function effect(effectName:String="normal"):Object{ return EFFECT_DATA[EFFECT_NAME.indexOf(effectName)+1]; }
    
    //matrixタイプのEffectを作ってかえします
    static public function matrixEffect(matrix:Matrix,time:int=40):Object{ return { name:"fade",type:"matrix",time:time,matrix:matrix } }
    //filterタイプのEffectを作ってかえします
    static public function filterEffect(filter:BitmapFilter,time:int=40):Object{ return { name:"fade",type:"filter",time:time,filter:filter } }
    
    private function onFrame(e:Event=null):void{
        if(_selectedChild>=0 && _selectedChild<children.length){
            var b:BitmapData = bitmap.bitmapData;
            children[_selectedChild].visible = true;
            var size:int = effects.length;
            if(time>0){
                b.lock();
                for(var i:int=0;i<size;i++){
                    switch(effects[i].type){
                         case "matrix":
                             b.draw(b,effects[i].matrix);
                             break;
                         case "filter":
                             b.applyFilter(b,b.rect,new Point,effects[i].filter);
                    }
                    var r:uint = (1- time / maxTime)*256;
                    b.merge(transMap,b.rect,new Point(),r,r,r,r);
                    time--;
                }
                b.unlock();
            }
        }
        if(time==0){
            bitmap.visible = false;
        }
    }
}


import flash.display.Sprite;
import flash.text.*;
import flash.events.*;
import flash.utils.*;


//単語を表示する。ウィンドウの表示。
class TypingWindow extends Sprite{
    
    public var typedFormat:TextFormat = new TextFormat();
    public var kanaFormat:TextFormat = new TextFormat();
    public var wordFormat:TextFormat = new TextFormat();
    public var romanFormat:TextFormat = new TextFormat();
    
    public var kanaField:TextField = new TextField();
    public var wordField:TextField = new TextField();
    public var romanField:TextField = new TextField();
    
    public var blinde:Sprite = new Sprite();
    
    public var messageFormat:TextFormat = new TextFormat();
    public var messageField:TextField = new TextField();
    
    public function TypingWindow(){
        addChild(kanaField);
        addChild(wordField);
        addChild(romanField);
        layout();
    }
    
    
    //ウィンドウのレイアウトです。好きに改変してください*******************************************
    public function layout():void{
        
        var w :int　= 200;    //幅
        var h :int　= 90;        //高さ
        var r :int = 20;        //丸み
        
        
        
        
        
        //背景、枠の設定
        graphics.lineStyle (4, 0x000000, 1);    // 線のスタイル指定
        graphics.beginFill (0xAAAACC, 0.5);    // 面のスタイル設定
        graphics.drawRoundRect(0, 0, w, h , r , r);
        
        
        //かなの設定
        with(kanaFormat){    
            size = 15;            //サイズの設定
            bold = false         //太文字にするか
            font = "ＭＳ ゴシック"        //フォント
            align = "center";    //文字の揃え方
            
        }
        with(kanaField){
            width = 200;
            y = 10;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = kanaFormat;
        }
        
        
        //メインの単語の設定
        with(wordFormat){    
            size = 24;            //サイズの設定
            bold = true;         //太文字にするか
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(wordField){
            width = 200;
            y = 25;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = wordFormat;
        }
        
        
        
        //ローマ字の設定
        with(romanFormat){    
            size = 15;            //サイズの設定
            bold = false;         //太文字にするか
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(romanField){
            width = 200;
            x="0"
            y = 55;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = romanFormat;
        }
        
        
        
        //タイプ済みの文字の設定
        with(typedFormat){    
            size = 15;            //サイズの設定
            bold = false;         //太文字にするか
            font = "メイリオ"        //フォント
            color = 0x666666;    //色
            align = "center";    //文字の揃え方
        }
        
        
        
        
        
        
        
        
        //ウィンドウがオフのときの設定
        blinde.graphics.lineStyle (4, 0x444444, 1);    // 線のスタイル指定
        blinde.graphics.beginFill (0xFFFFFF, 0.7);    // 面のスタイル設定
        blinde.graphics.drawRoundRect(0, 0, w, h , r , r);
        
        //メッセージの設定
        with(messageFormat){    
            size = 30;            //サイズの設定
            bold = true;         //太文字にするか
            color = 0xFF1600;
            font = "メイリオ"        //フォント
            align = "center";    //文字の揃え方
        }
        with(messageField){
            width = 200;
            y = 28;
            alpha = 1;            //透明度
            
            selectable = false;
            defaultTextFormat = messageFormat;
        }
    }
    //****************************************************************
    
    public function off():void{
        if(contains(blinde)==false){addChild(blinde);}
    }
    public function on():void{
        if(contains(blinde)){removeChild(blinde);}
        if(contains(messageField)){removeChild(messageField);}
    }
    
    
    public function setMessage(m:String):void{
        messageField.text = m; 
        off();
        addChild(messageField);
    }
    
    public var _typed:String;
    public function set typed(t:String):void{
        _typed = t;
        var length:int = _typed.length;
        if(length > romanField.text.length){
            length = romanField.text.length;
        }else if(length+1 == romanField.text.length){
            if(romanField.text.substring(length)==" "){
                setMessage("SPACE");
            }
        }
        romanField.setTextFormat(typedFormat,-1,length);
    }
}



class CrowdMap extends Bitmap{
    public var color:uint = 0xFF000000;
    private var cores:Vector.<Object> = new Vector.<Object>();
    private var points:Vector.<Object> = new Vector.<Object>();
    private static const FISH_PASS1:Array = [[ [1,1.5,0x000000,1.0,0x668899,1.0],[0,10,0],[10,0,1],[19,8,0],[26,0,0],[25,20,0],[19,14,0],[10,20,1] ],[[1,1.5,0x000000,1.0,0xFFFFFF,1.0],[7,0,1],[11,7,1],[7,14,1],[3,7,1]],[[1,0,0x000000,1.0,0x000000,1.0],[7,3,1],[9,7,1],[7,11,1],[4,7,1]]];
    private static const FISH_PASS2:Array = [[ [1,1.5,0x000000,1.0,0x668899,1.0],[0,10,0],[10,0,1],[19,8,0],[23,0,0],[24,20,0],[19,14,0],[10,20,1] ],[[1,1.5,0x000000,1.0,0xFFFFFF,1.0],[7,0,1],[11,7,1],[7,14,1],[3,7,1]],[[1,0,0x000000,1.0,0x000000,1.0],[7,3,1],[9,7,1],[7,11,1],[4,7,1]]];
    private var fishMap:Vector.<BitmapData> = new Vector.<BitmapData>;
    
    private var transMap:BitmapData;
    private var rate:Number = 60;
    private var filter:BlurFilter = new BlurFilter(5,5,1);
    private var aliveRect:Rectangle;
    
    public function CrowdMap(w:int,h:int){
        aliveRect = new Rectangle(-100,-100,w+200,h+200);
        transMap = new BitmapData(w,h,true,0x22005533);
        fishMap[0] = VectorImageUtil.bitmapData(FISH_PASS1);
        fishMap[1] = VectorImageUtil.bitmapData(FISH_PASS2);
        super(new BitmapData(w,h,true));
        this.addEventListener( "enterFrame", onFrame );
        
    }

    public function create(x:int,y:int,n:int,num:int,w:int=10):void{
        for(var i:int=0;i<n;i++){
            var core:Object = { x:x+i*w,y:y };
            cores.push( core );
            for(var j:int=0;j<num;j++){
                var r:Number = Math.random()*200+100;
                var deg:Number = Math.PI*( 0.3-Math.random()*0.6 );
                var ct:ColorTransform = new ColorTransform( 1+Math.random(),1+Math.random(),1+Math.random(),1 );
                points.push( {   
                                 x: core.x+r*Math.cos(deg),
                                 y: core.y+r*Math.sin(deg),
                                 dx: 0,
                                 dy: 0,
                                 targetX: core.x + (50-Math.random()*100),
                                 targetY: core.y + (20-Math.random()*40),
                                 target: core,
                                 chase: true,
                                 life: 40,
                                 color: ct,
                                 count:20*Math.random()
                              } );
            }
        }
    }
    
    private function onFrame(e:Event):void{
        move();
        drow();
    }
    
    private function drow():void{
        var b:BitmapData = bitmapData;
        b.lock();
        b.merge(transMap,b.rect,new Point(),100,100,100,256);
        var l:int = points.length;
        for(var i:int=l-1;i>-1;i--){
            var p:Object = points[i];
            var dir:int = 1; 
            if(p.x<p.targetX){dir=-1}
            p.count++;
            b.draw(fishMap[int(p.count/10)%2],new Matrix(dir,0,0,1,p.x-12*dir,p.y), p.color);
        }
        b.unlock();
    }
    
    private function move():void{
        var l:int = points.length;
        for(var i:int=0;i<l;i++){
            var p:Object = points[i];
            p.x = (p.x*15+p.targetX)/16;
            p.y = (p.y*15+p.targetY)/16;            
            if(p.chase){
                if(Math.random()<0.01){
                    var core:Object = p.target;
                    p.targetX = core.x + (120-Math.random()*240);
                    p.targetY = core.y + (50-Math.random()*100);
                }
            }else{
                p.life--;
                p.color.alphaMultiplier = p.life/14;
                if(p.life<0 || bitmapData.rect.contains(p.x,p.y)==false){
                    points.splice(i,1);
                    l--;i--;
                }
            }        
        }
    }
    
    public function del(n:int = 0):Boolean{
        var l:int = points.length;
        if(n < cores.length){
            var c:Object = cores[n];
            cores.splice(n,1);
            for(var i:int=0;i<l;i++){
                var p:Object = points[i];
                if(p.target == c){
                    p.chase = false;
                    var speed:Number = Math.random()*900+200;
                    var deg:Number = Math.PI*(-Math.random()*0.6+1.3);
                    p.targetX += speed*Math.cos(deg);
                    p.targetY += speed*Math.sin(deg);
                }
            }
            return true;
        }
        return false;
    }
}
class SeaMap extends Bitmap{
    public var offsets:Array = [new Point,new Point],w:int,h:int,scroll:Number,colorTrans:ColorTransform,randomSeed:int;
    public function SeaMap(w:int,h:int,colorTrans:ColorTransform=null,seed:int=-1){
        if(colorTrans==null){colorTrans=new ColorTransform()}
        if(seed==-1){randomSeed=Math.random()*1000;}
        else{randomSeed=seed;}
        this.w=w;this.h=h;
        this.colorTrans=colorTrans;
        super(new BitmapData(w,h,true));
        drow();
    }
    public function startScroll(scroll:Number=2):void{
        this.scroll=scroll;
        addEventListener("enterFrame",drow);
    }
    public function drow(e:Event=null):void{
        bitmapData.perlinNoise( 120,120,2,randomSeed,false,false,15,false, offsets );
        bitmapData.colorTransform(bitmapData.rect,colorTrans);
        offsets[0].x += scroll;
        offsets[1].x -= scroll/2;
    }
}


import flash.display.Shape;
//ベクタ画像用クラス=================================================================================================================================================================
class VectorImage extends Shape{
    public var data:Array;
    public var styles:Vector.<Array>;        //styles[][],,,style:[open/close,lineWeight,lineColor,lineAlpha,fillColor,fillAlpha]
    public var dots:Vector.<Array>;            //dots[][][],,,dot:[x,y,curve]
    
    //コンストラクタ
    public function VectorImage(pass:Array){ read(pass); }

    //データの読み込み
    public function read(pass:Array):void{
        data=pass;
        styles = new Vector.<Array>();
        dots = new Vector.<Array>();
        var size:int = pass.length
        for(var i:int=0;i<size;i++){
            styles[i] = [];dots[i] = [];
            for(var j:int=0;j<6;j++){ styles[i][j]=pass[i][0][j]; }
            var l:int =pass[i].length-1;
            for(var k:int=0;k<l;k++){
                dots[i][k] = [];
                for(var n:int=0;n<3;n++){ dots[i][k][n]=pass[i][k+1][n]; }
            }
        }
        drow();
    }
    //データの描画
    public function drow():void{
        var size:int = styles.length;
        graphics.clear();
        for(var i:int=0;i<size;i++){
            var l:int=dots[i].length;
            graphics.lineStyle(styles[i][1],styles[i][2],styles[i][3]);
            if(styles[i][0]==1){ graphics.beginFill(styles[i][4],styles[i][5]); var bf:Array=dots[i][l-1];}
            else{ bf=dots[i][0];}
            graphics.moveTo( center(bf,dots[i][0],0),center(bf,dots[i][0],1) ); 
            for(var j:int=0;j<l-1;j++){  line(bf,dots[i][j],dots[i][j+1]);bf=dots[i][j]; }
            if(styles[i][0]==1){ line( bf, dots[i][j], dots[i][0]);  }
            else{  line(bf, dots[i][j], dots[i][j] ); }
        }
    }
    private function line(dot1:Array,dot2:Array,dot3:Array):void{
        graphics.lineTo( center(dot2,dot1,0),center(dot2,dot1,1) );
        if(dot2[2]>0){graphics.curveTo( dot2[0],dot2[1],center(dot2,dot3,0),center(dot2,dot3,1) );}
    }
    private function center(dot1:Array,dot2:Array,xy:int):Number{
        if( dot1[2] == 0){return dot1[xy];}
        return (dot1[xy]*dot2[2]+dot2[xy]*dot1[2]*dot1[2])/(dot1[2]*dot1[2]+dot2[2]);
    }
}
//=========================================================================================================================================================================================

//ベクタ画像用のユーティリティ==========================================================================================
class VectorImageUtil{
    //ベクタ画像用のデータをBitmapDataに変換します。
    public static function bitmapData(pass:Array):BitmapData{
        var img:VectorImage = new VectorImage(pass);
        var rect:Rectangle = img.getRect(img);
        var mapData:BitmapData = new BitmapData(rect.width,rect.height,true,0);
        mapData.draw(img);
        return mapData;
    }
}




//ここから下は編集せずにタイピングゲームを作ることができます
class Typing extends Sprite{
    public var typed:String;
    public var play:Boolean;
    
    
    public var time:Number;
    private var lastTime:Number;
    
    
    public var touch:int;
    public var missTouch:int;
    public var finWord:int;

    public var typingWindows:Vector.<TypingWindow>;
    public var romanList:Vector.<Array>;
    
    public var wordList:Array = new Array();     //単語表
    
    public var target:Vector.<Object>;        //現在ターゲットとなっている単語     
    public var hint:Vector.<Object>;            //次以降の単語
    //Objectの変数は基本的に二つ    word:単語     kana:かな        index:単語リスト中での番号
    
    public var unused:Vector.<int>;            //未使用の単語のリスト
    private var lastWord:Object;
    private var lastType:Object;
    private var currentWord:Object;
    private var currentType:Object;
    
    //文字をタイプします。　t は length=1 の文字列にしてください。
    //このメソッドを呼び出すと指定された文字列をタイプしたのと同じ操作をします
    public function type(t:String):void{
        var s:String = typed + t;
        var miss:Boolean=true;
        var clear:int = -1;
        for(var i:int=target.length-1;i>=0;i--){
            if(match(target[i].kana,s) == s.length){
                typed = s;
                typingWindows[i].on();
                
                var preffered:String = preferredRoman(target[i].kana,s);
                typingWindows[i].romanField.text = preffered;
                typingWindows[i].typed = typed;
                miss = false;
                if(typed==preffered){
                    clear = i;
                }
            }else{
                typingWindows[i].off();
                typingWindows[i].romanField.text = firstRoman(target[i].kana);
            }
        }
        if(miss){
            currentType.miss = 1;
            currentWord.miss++;
            missTouch++;
            back();
        }else{
            touch++;
            currentType.miss=0;
        }
        currentType.typed = t;
        currentType.time = time;
        
        dispatchEvent(new TypingEvent(TypingEvent.TYPE,false,false,
                                currentType.time - lastType.time,currentType.typed,currentType.miss));
        lastType = currentType;
        currentType = {typed:"", miss:0, time:0};    
        
        if(clear>=0){
            finWord++;
            currentWord.index = target[clear].index;
            currentWord.word = target[clear].word;
            currentWord.kana = target[clear].kana;
            currentWord.typed = typed;
            clearWord(clear);
        }
    }
    
    //単語リストの設定
    //start()するより前に設定してください.
    //またtargetが設定されているときに単語リストを変更しないでください。
    public function setWordList(list:Array):void{
        wordList = list;
        unused = new Vector.<int>();
        for(var i:int=0;i<wordList.length;i++){
            unused[i] = i;
            wordList[i].index = i;
        }
    }
    
    //単語リスト hint の中から順番にnコの単語をtargetに追加
    public function addTargetFirst(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var k:int;
            if(hint.length == 0){
                if(unused.length==0){
                    for(var j:int=0;j<wordList.length;j++){
                        unused[j] = j;
                    }
                }
                k = unused[0];
                unused.splice(0,1);
                addTarget(wordList[k]);
            }else{
                addTarget(hint[0]);
                hint.splice(0,1);
            }
        }
    }
    
    //単語リストまたは hint の中からランダムにnコの単語をtargetに追加
    public function addTargetRandom(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var rand:int;
            var k:int;
            if(hint.length == 0){
                if(unused.length==0){
                    for(var j:int=0;j<wordList.length;j++){
                        unused[j] = j;
                    }
                }
                rand = Math.random() * unused.length;
                k = unused[rand];
                unused.splice(rand,1);
                addTarget(wordList[k]);
            }else{
                rand = Math.random() * hint.length;
                hint.splice(rand,1);
                addTarget(hint[rand]);
            }
        }
    }
    
    //単語リストの中から順番にnコの単語をhintに追加
    //hintに設定された単語は優先的にtargetに追加されるので,
    //hintを用いることで次の単語、その次の単語をあらかじめ決めることができます。
    public function addHintFirst(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var k:int;
            if(unused.length==0){
                for(var j:int=0;j<wordList.length;j++){
                    unused[j] = j;
                }
            }
            k = unused[0];
            unused.splice(0,1);
            addHint(wordList[k]);
        }
    }
    
    //単語リストの中からランダムにnコの単語をhintに追加
    public function addHintRandom(n:int):void{
        if(wordList.length < 1){return;}
        for(var i:int=0;i<n;i++){
            var rand:int;
            var k:int;
            if(unused.length==0){
                for(var j:int=0;j<wordList.length;j++){
                    unused[j] = j;
                }
            }
            rand = Math.random() * unused.length;
            k = unused[rand];
            unused.splice(rand,1);
            addHint(wordList[k]);
        }
    }
    /*    
        addTargetRandom(),addTargetFirst(),
        addHintRandom(),addHintFirst()メソッドは
        既に使用されている単語を避けて、単語を追加します。
        
        つまり,addTargetRandom(),addTargetFirst()メソッドでは、
            1, hintに指定されている単語
            2, まだ使用されていない単語
            3, 既に使用された単語
        の順に、単語の追加が行われます。
    */
    
    //Objectを指定してtargetに追加
    public function addTarget(o:Object):void{
        target.push(o);
        typingWindows.push(new TypingWindow());
        typingWindows[typingWindows.length-1].kanaField.text = o.kana;
        typingWindows[typingWindows.length-1].wordField.text = o.word;
        typingWindows[typingWindows.length-1].romanField.text = firstRoman(o.kana);
        addChildAt(typingWindows[typingWindows.length-1],0);
    }
    //Objectを指定してhintに追加
    public function addHint(o:Object):void{
        hint.push(o);
    }
    
    //targetを消去。removeTarget(消去する最初のターゲット,消去する個数)
    public function removeTarget(s:int, count:int = -1):void{
        var c:int = 0;
        while(c != count && target.length > s){
            removeChild(typingWindows[s]);
            typingWindows.splice(s,1);
            target.splice(s,1);
            c++;
        }
        return;
    }
    
    
    
    //単語入力完了処理
    public function clearWord(n:int):void{
        removeTarget(n,1);
        typed="";
        back();
        currentWord.time = time;
        dispatchEvent(new TypingEvent(TypingEvent.TYPE_WORD,false,false,
                                currentWord.time - lastWord.time,currentWord.typed,currentWord.miss,
                                currentWord.word,currentWord.kana,currentWord.index
                                ));
        
        lastWord = currentWord;
        currentWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
    }
    
    
    
    
    //与えられたかなの先頭にromanが最大何文字マッチするか返す
    public function match(kana:String,roman:String):int{
        var matchLength:int = 0;
        var longest:int = 0;
        var unreaded:String = kana;
        var unreadedRoman:String = roman;
        while(unreaded.length != 0 && unreadedRoman.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<3;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        var term:String = romanList[m][unreaded.substring(0,n)]
                        if(term == unreadedRoman.substring(0,term.length)){
                            unreaded = unreaded.substring(n);
                            unreadedRoman = unreadedRoman.substring(term.length);
                            matchLength += term.length;
                            longest = matchLength;
                            break loop1;
                        }else{
                            while(term.length > 1){
                                term = term.substring(0,term.length - 1);
                                if(term == unreadedRoman.substring(0,term.length)){
                                    if(longest < matchLength + term.length){longest = matchLength + term.length;}
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if(n==0){break;}
        }
        return longest;
    }
    
    public function preferredRoman(kana:String,roman:String):String{
        //romanがタイプされているときの最適なローマ字の振り方を返す
        var matchLength:int = 0;
        var longest:int = 0;
        var preferred:String = "";
        var unreaded:String = kana;
        var unreadedRoman:String = roman;
        while(unreaded.length != 0 && unreadedRoman.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<4;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        var term:String = romanList[m][unreaded.substring(0,n)]
                        if(term == unreadedRoman.substring(0,term.length)){
                            preferred += term;
                            unreaded = unreaded.substring(n);
                            unreadedRoman = unreadedRoman.substring(term.length);
                            matchLength += term.length;
                            longest = matchLength;
                            if(roman.length==longest){return preferred + firstRoman(unreaded);}
                            break loop1;
                        }else{
                            var bterm:String = term;
                            while(term.length > 1){
                                term = term.substring(0,term.length - 1);
                                if(term == unreadedRoman.substring(0,term.length)){
                                    longest = matchLength+term.length;
                                    if(roman.length==longest){
                                            preferred += bterm;
                                            unreaded = unreaded.substring(n);
                                            unreadedRoman = unreadedRoman.substring(term.length);
                                            matchLength += term.length;
                                            longest = matchLength;
                                            return preferred + firstRoman(unreaded);
                                    }
                                    break;
                                }
                            }
                        }
                    }
                }
            }
            if(n==0){
                break;
            }
        }
        preferred += firstRoman(unreaded);
        return preferred;
    }
    
    //kanaのもっとも簡単なローマ字の振り方を返す
    public function firstRoman(kana:String):String{
        var unreaded:String = kana;
        var preferred:String = "";
        while(unreaded.length != 0){
            loop1:for(var n:int=4;n>0;n--){//文字数
                for(var m:int=0;m<4;m++){//候補番号
                    if(romanList[m][unreaded.substring(0,n)] != undefined){
                        preferred += romanList[m][unreaded.substring(0,n)];                        
                        unreaded = unreaded.substring(n);
                        break loop1;
                    }
                }
            }
            if(n==0){
                break;
            }
        }
        return preferred;
    }
    
    
    //単語リストとウインドウスタイル以外を初期化します
    public function reset():void{
        time = 0;
        missTouch = 0;
        touch = 0;
        finWord = 0;
        
        typed = "";
        
        currentWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
        currentType = {typed:"", miss:0, time:0};
        
        lastWord = {typed:"",word:"", kana:"",  index:0,  miss:0, time:0};
        lastType = {typed:"", miss:0, time:0};
        
        
        typingWindows = new Vector.<TypingWindow>();
        target = new Vector.<Object>();
        hint = new Vector.<Object>();
        
        while(numChildren>0){removeChildAt(0);}
        
        setWordList(wordList);
        
        play = false;
    }

    
    
    
    
    //タイピングを一時停止します
    public function stop():void{
        play = false;
        
        removeEventListener(Event.ENTER_FRAME,onEnterFrame);
        stage.removeEventListener("keyDown", onKeyDown);
    }
    
    //タイピングを開始します
    public function start():void{
        play = true;
        
        lastTime = getTimer()/1000;
        addEventListener(Event.ENTER_FRAME,onEnterFrame);
        stage.addEventListener("keyDown", onKeyDown);
    }
    
    public function onKeyDown(e:KeyboardEvent):void{
        if(e.keyCode < 16 || e.keyCode > 18){
            type(String.fromCharCode(e.charCode));
        }
    }
    
    
    private function back():void{
        for(var i:int=0;i<target.length;i++){
            if(match(target[i].kana,typed) == typed.length){
                var preffered:String = preferredRoman(target[i].kana,typed);    
                typingWindows[i].romanField.text = preffered;
                typingWindows[i].on();
                if(typed != ""){typingWindows[i].typed = typed;}
            }else{
                typingWindows[i].romanField.text = firstRoman(target[i].kana);
            }
        }
    }
    
    public function onEnterFrame(e:Event):void{
        var t:Number = getTimer()/1000;
        time += t - lastTime;
        lastTime = t;
        
    }
    
    
    
    
    public function Typing(){
            reset();
            
            
            romanList = new Vector.<Array>(4); //かなとローマ字の変換表
           //候補1------------------------------------------------------------
        romanList[0] = new Array();
        
        romanList[0]["ー"] = "-";
        romanList[0]["。"] = ".";
        romanList[0]["、"] = ",";
        romanList[0]["？"] = "?";
        romanList[0]["！"] = "!";
        romanList[0]["　"] = " ";
        romanList[0]["あ"] = "a";
        romanList[0]["い"] = "i";
        romanList[0]["う"] = "u";
        romanList[0]["え"] = "e";
        romanList[0]["お"] = "o";
        romanList[0]["か"] = "ka";
        romanList[0]["き"] = "ki";
        romanList[0]["く"] = "ku";
        romanList[0]["け"] = "ke";
        romanList[0]["こ"] = "ko";
        romanList[0]["さ"] = "sa";
        romanList[0]["し"] = "si";
        romanList[0]["す"] = "su";
        romanList[0]["せ"] = "se";
        romanList[0]["そ"] = "so";
        romanList[0]["な"] = "na";
        romanList[0]["に"] = "ni";
        romanList[0]["ぬ"] = "nu";
        romanList[0]["ね"] = "ne";
        romanList[0]["の"] = "no";
        romanList[0]["た"] = "ta";
        romanList[0]["ち"] = "ti";
        romanList[0]["つ"] = "tu";
        romanList[0]["て"] = "te";
        romanList[0]["と"] = "to";
        romanList[0]["は"] = "ha";
        romanList[0]["ひ"] = "hi";
        romanList[0]["ふ"] = "fu";
        romanList[0]["へ"] = "he";
        romanList[0]["ほ"] = "ho";
        romanList[0]["ま"] = "ma";
        romanList[0]["み"] = "mi";
        romanList[0]["む"] = "mu";
        romanList[0]["め"] = "me";
        romanList[0]["も"] = "mo";
        romanList[0]["や"] = "ya";
        romanList[0]["ゆ"] = "yu";
        romanList[0]["いぇ"] = "ye";
        romanList[0]["よ"] = "yo";
        romanList[0]["ら"] = "ra";
        romanList[0]["り"] = "ri";
        romanList[0]["る"] = "ru";
        romanList[0]["れ"] = "re";
        romanList[0]["ろ"] = "ro";
        romanList[0]["わ"] = "wa";
        romanList[0]["ゐ"] = "wi";
        romanList[0]["ゑ"] = "we";
        romanList[0]["を"] = "wo";
        romanList[0]["が"] = "ga";
        romanList[0]["ぎ"] = "gi";
        romanList[0]["ぐ"] = "gu";
        romanList[0]["げ"] = "ge";
        romanList[0]["ご"] = "go";
        romanList[0]["ざ"] = "za";
        romanList[0]["じ"] = "ji";
        romanList[0]["ず"] = "zu";
        romanList[0]["ぜ"] = "ze";
        romanList[0]["ぞ"] = "zo";
        romanList[0]["だ"] = "da";
        romanList[0]["ぢ"] = "di";
        romanList[0]["づ"] = "du";
        romanList[0]["で"] = "de";
        romanList[0]["ど"] = "do";
        romanList[0]["ば"] = "ba";
        romanList[0]["び"] = "bi";
        romanList[0]["ぶ"] = "bu";
        romanList[0]["べ"] = "be";
        romanList[0]["ぼ"] = "bo";
        romanList[0]["ぱ"] = "pa";
        romanList[0]["ぴ"] = "pi";
        romanList[0]["ぷ"] = "pu";
        romanList[0]["ぺ"] = "pe";
        romanList[0]["ぽ"] = "po";
        romanList[0]["ぁ"] = "la";
        romanList[0]["ぃ"] = "li";
        romanList[0]["ぅ"] = "lu";
        romanList[0]["ぇ"] = "le";
        romanList[0]["ぉ"] = "lo";
        romanList[0]["ゃ"] = "lya";
        romanList[0]["ゅ"] = "lyu";
        romanList[0]["ょ"] = "lyo";
        romanList[0]["ゎ"] = "lwa";
        romanList[0]["っ"] = "ltu";
        romanList[0]["ヵ"] = "lka";
        romanList[0]["ヶ"] = "lke";
        romanList[0]["きゃ"] = "kya";
        romanList[0]["きぃ"] = "kyi";
        romanList[0]["きゅ"] = "kyu";
        romanList[0]["きぇ"] = "kye";
        romanList[0]["きょ"] = "kyo";
        romanList[0]["しゃ"] = "sya";
        romanList[0]["しぃ"] = "syi";
        romanList[0]["しゅ"] = "syu";
        romanList[0]["しぇ"] = "sye";
        romanList[0]["しょ"] = "syo";
        romanList[0]["ちゃ"] = "tya";
        romanList[0]["ちぃ"] = "tyi";
        romanList[0]["ちゅ"] = "tyu";
        romanList[0]["ちぇ"] = "tye";
        romanList[0]["ちょ"] = "tyo";
        romanList[0]["にゃ"] = "nya";
        romanList[0]["にぃ"] = "nyi";
        romanList[0]["にゅ"] = "nyu";
        romanList[0]["にぇ"] = "nye";
        romanList[0]["にょ"] = "nyo";
        romanList[0]["ひゃ"] = "hya";
        romanList[0]["ひぃ"] = "hyi";
        romanList[0]["ひゅ"] = "hyu";
        romanList[0]["ひぇ"] = "hye";
        romanList[0]["ひょ"] = "hyo";
        romanList[0]["みゃ"] = "mya";
        romanList[0]["みぃ"] = "myi";
        romanList[0]["みゅ"] = "myu";
        romanList[0]["みぇ"] = "mye";
        romanList[0]["みょ"] = "myo";
        romanList[0]["りゃ"] = "rya";
        romanList[0]["りぃ"] = "ryi";
        romanList[0]["りゅ"] = "ryu";
        romanList[0]["りぇ"] = "rye";
        romanList[0]["りょ"] = "ryo";
        romanList[0]["ぎゃ"] = "gya";
        romanList[0]["ぎぃ"] = "gyi";
        romanList[0]["ぎゅ"] = "gyu";
        romanList[0]["ぎぇ"] = "gye";
        romanList[0]["ぎょ"] = "gyo";
        romanList[0]["じゃ"] = "ja";
        romanList[0]["じぃ"] = "zyi";
        romanList[0]["じゅ"] = "ju";
        romanList[0]["じぇ"] = "je";
        romanList[0]["じょ"] = "jo";
        romanList[0]["ぢゃ"] = "dya";
        romanList[0]["ぢぃ"] = "dyi";
        romanList[0]["ぢゅ"] = "dyu";
        romanList[0]["ぢぇ"] = "dye";
        romanList[0]["ぢょ"] = "dyo";
        romanList[0]["びゃ"] = "bya";
        romanList[0]["びぃ"] = "byi";
        romanList[0]["びゅ"] = "byu";
        romanList[0]["びぇ"] = "bye";
        romanList[0]["びょ"] = "byo";
        romanList[0]["ぴゃ"] = "pya";
        romanList[0]["ぴぃ"] = "pyi";
        romanList[0]["ぴゅ"] = "pyu";
        romanList[0]["ぴぇ"] = "pye";
        romanList[0]["ぴょ"] = "pyo";
        romanList[0]["うぁ"] = "wa";
        romanList[0]["うぃ"] = "wi";
        romanList[0]["うぇ"] = "we";
        romanList[0]["うぉ"] = "wo";
        romanList[0]["ヴぁ"] = "va";
        romanList[0]["ヴぃ"] = "vi";
        romanList[0]["ヴ"] = "vu";
        romanList[0]["ヴぇ"] = "ve";
        romanList[0]["ヴぉ"] = "vo";
        romanList[0]["ヴゃ"] = "vya";
        romanList[0]["ヴゅ"] = "vyu";
        romanList[0]["ヴょ"] = "vyo";
        romanList[0]["てゃ"] = "tha";
        romanList[0]["てぃ"] = "thi";
        romanList[0]["てゅ"] = "thu";
        romanList[0]["てぇ"] = "the";
        romanList[0]["てょ"] = "tho";
        romanList[0]["ふぁ"] = "fa";
        romanList[0]["ふぃ"] = "fi";
        romanList[0]["ふぅ"] = "fwu";
        romanList[0]["ふぇ"] = "fe";
        romanList[0]["ふぉ"] = "fo";
        romanList[0]["ふゃ"] = "fya";
        romanList[0]["ふゅ"] = "fyu";
        romanList[0]["ふょ"] = "fyo";
        romanList[0]["でゃ"] = "dha";
        romanList[0]["でぃ"] = "dhi";
        romanList[0]["でゅ"] = "dhu";
        romanList[0]["でぇ"] = "dhe";
        romanList[0]["でょ"] = "dho";
        romanList[0]["くぁ"] = "qa";
        romanList[0]["くぃ"] = "qi";
        romanList[0]["くぅ"] = "qwu";
        romanList[0]["くぇ"] = "qe";
        romanList[0]["くぉ"] = "qo";
        romanList[0]["くゃ"] = "qya";//何て読むんだ,これ。
        romanList[0]["くゅ"] = "qyu";
        romanList[0]["くょ"] = "qyo";
        romanList[0]["すぁ"] = "swa";
        romanList[0]["すぃ"] = "swi";
        romanList[0]["すぅ"] = "swu";
        romanList[0]["すぇ"] = "swe";
        romanList[0]["すぉ"] = "swo";
        romanList[0]["ぐぁ"] = "gwa";
        romanList[0]["ぐぃ"] = "gwi";
        romanList[0]["ぐぅ"] = "gwu";
        romanList[0]["ぐぇ"] = "gwe";
        romanList[0]["ぐぉ"] = "gwo";
        romanList[0]["どぁ"] = "dwa";
        romanList[0]["どぃ"] = "dwi";
        romanList[0]["どぅ"] = "dwu";
        romanList[0]["どぇ"] = "dwe";
        romanList[0]["どぉ"] = "dwo";
        romanList[0]["とぁ"] = "twa";
        romanList[0]["とぃ"] = "twi";
        romanList[0]["とぅ"] = "twu";
        romanList[0]["とぇ"] = "twe";
        romanList[0]["とぉ"] = "two";
        romanList[0]["つぁ"] = "tsa";
        romanList[0]["つぃ"] = "tsi";
        romanList[0]["つぇ"] = "tse";
        romanList[0]["つぉ"] = "tso";
        romanList[0]["ん"] = "nn";
    //候補2------------------------------------------------------------
        romanList[1] = new Array();
        
        romanList[1]["い"] = "yi";
        romanList[1]["う"] = "wu";
        romanList[1]["うぁ"] = "wha";
        romanList[1]["うぃ"] = "whi";
        romanList[1]["うぇ"] = "whe";
        romanList[1]["うぉ"] = "who";
        romanList[1]["う"] = "wu";
        romanList[1]["か"] = "ca";
        romanList[1]["く"] = "cu";
        romanList[1]["こ"] = "co";
        romanList[1]["くぃ"] = "qwi";
        romanList[1]["くぅ"] = "qwu";
        romanList[1]["くぇ"] = "qwe";
        romanList[1]["くぉ"] = "qwo";
        romanList[1]["くぁ"] = "kwa";
        romanList[1]["くぃ"] = "qwi";
        romanList[1]["くぅ"] = "qwu";
        romanList[1]["くぇ"] = "qwe";
        romanList[1]["くぉ"] = "qwo";
        romanList[1]["しゃ"] = "sha";
        romanList[1]["し"] = "shi";
        romanList[1]["しゅ"] = "shu";
        romanList[1]["しぇ"] = "she";
        romanList[1]["しょ"] = "sho";
        romanList[1]["せ"] = "ce";
        romanList[1]["じ"] = "zi";
        romanList[1]["じゃ"] = "zya";
        romanList[1]["じぃ"] = "jyi";
        romanList[1]["じゅ"] = "zyu";
        romanList[1]["じぇ"] = "zye";
        romanList[1]["じょ"] = "zyo";
        romanList[1]["ちゃ"] = "cha";
        romanList[1]["ち"] = "chi";
        romanList[1]["ちぃ"] = "cyi";
        romanList[1]["ちゅ"] = "chu";
        romanList[1]["ちぇ"] = "che";
        romanList[1]["ちょ"] = "cho";
        romanList[1]["つ"] = "tsu";
        romanList[1]["ふ"] = "hu";
        romanList[1]["ふぁ"] = "fwa";
        romanList[1]["ふぃ"] = "fwi";
        romanList[1]["ふぇ"] = "fwe";
        romanList[1]["ふぉ"] = "fwo";
        romanList[1]["ぁ"] = "xa";
        romanList[1]["ぃ"] = "xi";
        romanList[1]["ぅ"] = "xu";
        romanList[1]["ぇ"] = "xe";
        romanList[1]["ぉ"] = "xo";
        romanList[1]["ゃ"] = "xya";
        romanList[1]["ゅ"] = "xyi";
        romanList[1]["ょ"] = "xyu";
        romanList[1]["ゎ"] = "xwa";
        romanList[1]["っ"] = "ltsu";
        romanList[0]["ヵ"] = "xka";
        romanList[0]["ヶ"] = "xke";
    //候補3------------------------------------------------------------
        romanList[2] = new Array();
        romanList[2]["う"] = "whu";
        romanList[2]["し"] = "ci";
        romanList[2]["くぁ"] = "qwa";
        romanList[2]["くぃ"] = "qyi";
        romanList[2]["くぇ"] = "qye";
        romanList[2]["じゃ"] = "jya";
        romanList[2]["じゅ"] = "jyu";
        romanList[2]["じぇ"] = "jye";
        romanList[2]["じょ"] = "jyo";
        romanList[2]["ちゃ"] = "cya";
        romanList[2]["ちゅ"] = "cyu";
        romanList[2]["ちぇ"] = "cye";
        romanList[2]["ちょ"] = "cyo";
        romanList[2]["ふぃ"] = "fyi";
        romanList[2]["ふぇ"] = "fye";
        romanList[2]["ふぉ"] = "fwo";
        romanList[2]["ぃ"] = "lyi";
        romanList[2]["ぇ"] = "lye";
    //候補4------------------------------------------------------------
        romanList[3] = new Array();
        romanList[3]["ぃ"] = "xyi";
        romanList[3]["ぇ"] = "xye";
        
        //一文字目になるひらがな表
        var beforetse1:Array = [
                "あ","い","う","え","お",
                "か","き","く","け","こ",
                "さ","し","す","せ","そ",
                "た","ち","つ","て","と",
                "は","ひ","ふ","へ","ほ",
                "ま","み","む","め","も",
                "や","ゆ","よ",
                "わ","ゐ","う","ヱ","を","ん",
                "ら","り","る","れ","ろ",
                "が","ぎ","ぐ","げ","ご",
                "ざ","じ","ず","ぜ","ぞ",
                "だ","ぢ","づ","で","ど",
                "ば","び","ぶ","べ","ぼ",
                "ぱ","ぴ","ぷ","ぺ","ぽ","ヴ",
                "ゃ","ゅ","ょ","ゎ",
                "ぁ","ぃ","ぅ","ぇ","ぉ",
                "！","？","。","、","　"
                ];

        var beforetse2:Array = ["","ゃ","ゅ","ょ",
                "ぁ","ぃ","ぅ","ぇ","ぉ"
                ];
        
        //連続すると「っ」になるアルファベット　
        var tse:Array =["q","w","r","t","y","p","s","d","f","g","h","j","k","l","z","x","c","v","b","m"];
        
    
        //直前にn 1つで「ん」になるアルファベット
        var nn:Array =["q","w","r","t","p","s","d","f","g","h","j","k","l","z","x","c","v","b","m","!","?",".",","," "];
 
         //「っ」の付く候補作成
        for(var i:int = 0;i < beforetse1.length;i++){    
            for(var j:int = 0;j < beforetse2.length;j++){
                for(var k:int = 0;k < 4;k++){
                    var ok1:Boolean = false;
                    if( romanList[k][ beforetse1[i]+beforetse2[j] ] !=undefined){
                        for(var n:int=0;n<tse.length;n++){
                            if(romanList[k][ beforetse1[i]+beforetse2[j] ].substring(0,1) == tse[n]){ok1 = true;}
                        }
                    }
                    if( ok1 ){
                        romanList[k][ "っ"+beforetse1[i]+beforetse2[j] ] = romanList[k][ beforetse1[i]+beforetse2[j] ].substr(0,1) + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
        
                    var ok2:Boolean = false;
                    if( romanList[k][ beforetse1[i]+beforetse2[j] ] !=undefined){
                        for(n=0;n<tse.length;n++){
                            if(romanList[k][ beforetse1[i]+beforetse2[j] ].substring(0,1) == nn[n]){ok2 = true;}
                        }
                    }
                    if( ok2 ){
                        romanList[k][ "ん"+beforetse1[i]+beforetse2[j] ] = "n" + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
                    if( ok1 && ok2 ){
                        romanList[k][ "ん"+"っ"+beforetse1[i]+beforetse2[j] ] = "n" + romanList[k][ beforetse1[i]+beforetse2[j] ].substr(0,1) + romanList[k][ beforetse1[i]+beforetse2[j] ];
                    }
                }
            }
        }
            //半角文字
            for(i=32;i<127;i++){
                romanList[0][String.fromCharCode(i)] = String.fromCharCode(i);
            }
        }
}




class TypingEvent extends Event{
    public var time :Number;        //タイプにかかった時間
    public var typed:String;        //タイプされた文字列
    public var miss :int;        //ミスタイプの数
    public var word :String;        //タイプされた単語
    public var kana :String;        //タイプされたかな
    public var index :String;    //タイプされた単語の番号
    
    static public var TYPE_WORD :String = "typeWord";    //タイプされたかな
    static public var TYPE :String = "type";                //タイプされた単語の番号
    public function TypingEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false,
                                    timeValue:Number = 0, typedValue:String = "", missValue:int = 0,
                                    wordValue:String="", kanaValue:String = "", indexValue:String = ""
                                ):void{
        super( type , bubbles , cancelable);
        time = timeValue;
        typed = typedValue;
        miss = missValue;
        word = wordValue;
        kana = kanaValue;
        index = indexValue;
    }
}