/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bIH7
 */

// forked from FLASHMAFIA's Perlin Noize Tunnel [ Away3D 4.1 ]
package {
    import away3d.containers.View3D;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;

    [SWF(width='465', height='465')]
    public class PerlinTunnelA3D extends View3D {
        private var tunnel : PerlinNoizeTunnel;
        // private var snapBmd : BitmapData;

        function PerlinTunnelA3D() {
            stage.stageFocusRect = tabChildren = tabEnabled = mouseChildren = mouseEnabled = false;
            stage.scaleMode = 'noScale';
            stage.align = 'TL';
            stage.quality = 'low';
            stage.frameRate = 64;

            super();

            antiAlias = 4;

            camera.z = -10;
            camera.lookAt(new Vector3D(0, 0, -2048));

            tunnel = new PerlinNoizeTunnel(2048);
            scene.addChild(tunnel);

            // Wonderfl.disable_capture();
            // var bm : Bitmap = new Bitmap(snapBmd = new BitmapData(465, 465, false, 0x000000));
            // addChild(bm);

            stage.addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            tunnel.update();

            var t : Number = getTimer();
            camera.x = Math.sin(t / 1024) * 256;
            camera.y = Math.cos(t / 768) * 256;

            render();

            // if (snapBmd) renderer.queueSnapshot(snapBmd);
        }
    }
}

import away3d.containers.ObjectContainer3D;
import away3d.entities.Mesh;
import away3d.materials.TextureMaterial;
import away3d.primitives.ConeGeometry;
import away3d.textures.BitmapTexture;

import flash.display.BitmapData;
import flash.geom.Matrix3D;
import flash.geom.Point;


internal class PerlinNoizeTunnel extends ObjectContainer3D {
    private var bmd : BitmapData;
    private var ofst : Array;
    private var o0 : Point;
    private var o1 : Point;
    private var vx0 : Number;
    private var vy0 : Number;
    private var vx1 : Number;
    private var vy1 : Number;
    private var cone : Mesh;
    private var mat : TextureMaterial;

    function PerlinNoizeTunnel(maxDistance : int) {
        super();

        mat = new TextureMaterial(new BitmapTexture(bmd = new BitmapData(128, 128, false)), false);
        mat.bothSides = true;
        mat.alphaBlending = false;
        mat.repeat = true;
        mat.animateUVs = true;
        // XXX mat.addMethod(new FogMethod(maxDistance * 0.7, maxDistance, 0x0));

        var h : int = maxDistance * 1.2;


        var geo : ConeGeometry = new ConeGeometry(465, h, 16, 16, false, false);

        cone = new Mesh(geo, mat);
        cone.z = -h>>1;
        addChild(cone);

        o0 = new Point(0, 0);
        o1 = new Point(0, 0);
        vx0 = 0.0;
        vx1 = 0.0;
        vy0 = -2 * 1;
        vy1 = -2 * 2;
        ofst = [o0, o1];
        
         bmd.perlinNoise(64, 64, 2, 2222, true, false, 7, false, ofst);
    }

    public function update() : void {
        cone.subMeshes[0].offsetV -=0.01;

        cone.rotationZ++;
    }
}