/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bHyq
 */

package
{
    import Box2D.Collision.Shapes.b2PolygonDef;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.b2MouseJoint;
    import Box2D.Dynamics.Joints.b2MouseJointDef;
    import Box2D.Dynamics.b2Body;
    import Box2D.Dynamics.b2BodyDef;
    import Box2D.Dynamics.b2DebugDraw;
    import Box2D.Dynamics.b2World;
    import com.adobe.viewsource.ViewSource;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.effects.utils.BitmapDrawCommand;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    [SWF(backgroundColor="0x000000")]
    public class Box2D_PV3D3 extends BasicView
    {
        private var worldWidth : Number;
        private var worldHeight : Number;
        private var m_iterations : int;
        private var m_wallWidth : Number;
        private var m_wallHeight : Number;
        private var m_timeStep : Number;
        private var m_physScale : Number;
        private var m_world : b2World;
        private var rootNode : DisplayObject3D; 
        private var cubeSize : int;
        private var pv3d_height : Number;
        public function Box2D_PV3D3()
        {
            super(0, 0, true, true);
            cubeSize = 100;
            pv3d_height = 80;
            rootNode = scene.addChild(new DisplayObject3D("rootNode")); 
            camera.zoom = 700 / camera.focus + 1;
            camera.target = DisplayObject3D.ZERO;
            camera.y = 300;
            var light : PointLight3D = new PointLight3D(true);
            light.z = -200;
            light.y = 300;
            worldWidth = stage.stageWidth;
            worldHeight = stage.stageHeight;
            m_iterations = 30;
            m_timeStep = 1 / 20;
            m_physScale = 30;
            var worldAABB : b2AABB = new b2AABB;
            worldAABB.lowerBound.Set(-1000.0, -1000.0);
            worldAABB.upperBound.Set(1000.0, 1000.0);
            var gravity : b2Vec2 = new b2Vec2(0.0, 10.0);
            var doSleep : Boolean = true;
            m_world = new b2World(worldAABB, gravity, doSleep);
            var wallShapeDef : b2PolygonDef = new b2PolygonDef();
            var wallBodyDef : b2BodyDef = new b2BodyDef();
            var wall : b2Body;
            m_wallWidth = 500;
            m_wallHeight = 300;
            wallShapeDef.SetAsBox(10 / m_physScale, m_wallHeight / 2 / m_physScale);
            wallBodyDef.position.Set(0, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / m_physScale, m_wallHeight/2/m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallShapeDef.SetAsBox(m_wallWidth / 2 / m_physScale, 10 / m_physScale);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, m_wallHeight/m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            wall.SetMassFromShapes();
            var colorArray : Array = [0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 0xffffff];
            for (var i : int = 0; i < 5; i++)
            {
                var mat : FlatShadeMaterial = new FlatShadeMaterial(light, colorArray[i] as uint);
                mat.interactive = true;
                var matList : MaterialsList = new MaterialsList({all:mat});
                var cube : Cube = new Cube(matList, cubeSize, cubeSize, cubeSize);
                cube.extra = {width : cubeSize / 2, height : cubeSize / 2, arrayPos : i};
                cube.x = (i * 150) - 300;
                cube.y = 10;
                rootNode.addChild(cube);
                var boxShape : b2PolygonDef = new b2PolygonDef();
                boxShape.SetAsBox(cubeSize / 2 / m_physScale, cubeSize / 2 / m_physScale);
                boxShape.density = 8;
                boxShape.friction = 8;
                boxShape.restitution = 0.5;
                var bodyDef : b2BodyDef = new b2BodyDef();
                bodyDef.position.Set((cube.x + worldWidth / 2) / m_physScale, (cube.y + worldHeight/2)/m_physScale);
                var body : b2Body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxShape);
                body.SetUserData(cube);
                body.SetMassFromShapes();
                var vec : b2Vec2 = body.GetLinearVelocity();
                if (i == 3) vec.Set(50, 0); 
            }
            var dbgDraw : b2DebugDraw = new b2DebugDraw();
            dbgDraw.m_sprite = this;
            dbgDraw.m_drawScale = 10.0;
            dbgDraw.m_fillAlpha = 0.8;
            dbgDraw.m_lineThickness = 0.3;
            dbgDraw.m_alpha = 0.3;
            dbgDraw.m_xformScale = 1.0
            dbgDraw.m_drawFlags = b2DebugDraw.e_shapeBit;
            m_world.SetDebugDraw(dbgDraw);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        private function onEnterFrame(event : Event) : void
        {
            m_world.Step(m_timeStep, m_iterations);
            for (var bb : b2Body = m_world.GetBodyList(); bb; bb = bb.GetNext())
            {
                if (bb.GetUserData() is DisplayObject3D)
                {
                    bb.GetUserData().x = bb.GetPosition().x * m_physScale - worldWidth / 2;
                    bb.GetUserData().y = -bb.GetPosition().y * m_physScale + worldHeight / 2 + pv3d_height;
                    bb.GetUserData().rotationZ = -bb.GetAngle() * (180 / Math.PI);
                }
           }
           singleRender();    
        }
    }
}
