/**
 * Copyright chimad ( http://wonderfl.net/user/chimad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bHoa
 */

package {
    import com.bit101.components.Label;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    public class Main extends Sprite {
        private var white:Shape;
        private var navy:Shape;
        private var dome:Shape;
        private var particles:Vector.<Particle> = new Vector.<Particle>();
        private var screen:Sprite;
        private var background:BitmapData;
        private var surface:BitmapData;
        private var monitor:Label;
        private var frame:int = 0;
        private var tween:ITween;
        
        private const EFFECT_TIME:Number = 4.0;
        private const MAX_SCALE:Number = 5.0;
        public var framesPerRock:int = 4;
        public var particlesPerFrame:int = 20;

        public function Main() {
            graphics.beginFill(0x808080);
            graphics.drawRect(0,0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            this.screen = new Sprite();
            this.background = new BitmapData(stage.stageWidth, stage.stageHeight, false, Dome.COLOR);
            this.surface = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
            
            white = new Shape();
            white.graphics.beginFill(0xFFFFFF);
            white.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            white.graphics.endFill();
            white.alpha = 0;
            
            navy = new Shape();
            navy.graphics.beginFill(0x000010);
            navy.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            navy.graphics.endFill();
            navy.alpha = 0;
            
            screen.alpha = 0;
            screen.addChild(new Bitmap(background));
            screen.addChild(new Bitmap(surface));
            
            addChild(navy);
            addChild(screen);
            addChild(white);
            
            monitor = new Label(this, 0, 0, "Particles: ");
            
            stage.addEventListener(MouseEvent.CLICK, stage_click);
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(e:Event):void {
            frame++;
            
            if (tween == null || !tween.isPlaying)
                return;
            
            for (var i:int = 0; i < particlesPerFrame; i++) {
                var p:Particle = createParticle();
                BetweenAS3.tween(p, { y: -16 }, null, 1 / p.speed ).play();
                particles.push(p);
            }
            if (frame % framesPerRock == 0) {
                p = createParticle("rock");
                BetweenAS3.tween(p, { y: -16 }, null, 1 / p.speed ).play();
                particles.push(p);
            }
            
            monitor.text = "Particles: " + particles.length;
            
            surface.fillRect(surface.rect, 0x0);
            for (var j:int = 0; j < particles.length; j++) {
                p = particles[j];
                if (p.y < 0) {
                    particles.splice(j--, 1);
                } else {
                    if (p.bitmapData != null) {
                        surface.copyPixels(p.bitmapData, p.bitmapData.rect, new Point(p.x, p.y), null, null, true);
                    } else {
                        surface.fillRect(p.rect, p.color);
                    }
                }
            }
        }
        
        private function createParticle(type:String = "particle"):Particle {
            var domeRect:Rectangle = dome.getRect(stage);
            var x:Number = domeRect.x + Math.random() * domeRect.width;
            var y:Number = domeRect.bottom;
            
            if (type == "rock") {
                return new Rock(x, y);
            } else {
                return new Particle(x, y);
            }
        }
        
        private function stage_click(e:MouseEvent):void {
            if (tween == null || !tween.isPlaying)
                play();
        }
        
        private function play():void {
            dome = new Dome(60);
            screen.mask = dome;
            dome.x = mouseX;
            dome.y = mouseY;
            addChildAt(dome, 1);
            while (particles.length > 0)
                particles.pop();
            tween = BetweenAS3.serial(
                BetweenAS3.tween(screen, { alpha: 1 }, null, 0),
                BetweenAS3.parallel(
                    BetweenAS3.tween(navy, { alpha: 0.8 }, null, 0.2),
                    BetweenAS3.tween(this, { particlesPerFrame: 20 }, { particlesPerFrame: 2 }, EFFECT_TIME),
                    BetweenAS3.tween(this, { framesPerRock: 4 }, { framesPerRock: 12 }, EFFECT_TIME),
                    BetweenAS3.tween(dome, { scaleX: MAX_SCALE, scaleY: MAX_SCALE }, { scaleX: 0, scaleY: 0 }, EFFECT_TIME)
                ),
                BetweenAS3.tween(screen, { alpha: 0 }, null, 0),
                BetweenAS3.removeFromParent(dome),
                BetweenAS3.tween(white, { alpha: 1 }, { alpha:0 }, 0.03),
                BetweenAS3.tween(navy, { alpha: 0 }, null, 0),
                BetweenAS3.tween(white, { alpha: 0 }, { alpha:1 }, 0.25)
                );
            tween.play();
        }
    }
}

import flash.display.BitmapData;
import flash.display.Shape;
import flash.geom.Point;
import flash.geom.Rectangle;

class Dome extends Shape {
    public static const COLOR:uint = 0xFF2037CC;
    
    public function Dome(radius:Number) {
        var ellipseHeight:Number = radius * 0.8;
        graphics.beginFill(COLOR);
        graphics.drawRoundRectComplex(-radius, -radius, radius * 2, radius, radius, radius, 0, 0);
        graphics.beginFill(COLOR);
        graphics.drawEllipse(-radius, -(ellipseHeight / 2), radius * 2, ellipseHeight);
        graphics.endFill();
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var width:Number;
    public var height:Number;
    public var color:uint;
    public var speed:Number;
    public var bitmapData:BitmapData;
    
    public function get rect():Rectangle {
        return new Rectangle(x, y, width, height);
    }
    
    public function Particle(x:Number, y:Number) {
        this.x = x;
        this.y = y;
        init();
    }
    
    protected function init():void {
        this.width = 2;
        this.height = 1 + Math.random() * 12;
        this.speed = height / 6;
        
        var alpha:Number = 0.3 + Math.random() * 0.7;
        this.color = (0x100 * alpha) << 24 | 0xFFFFFF;
    }
}

class Rock extends Particle {
    private static const ALPHA:Number = 0.3;
    
    public function Rock(x:Number, y:Number) {
        super(x, y);
    }
    
    override protected function init():void {
        this.width = 12 + Math.random() * 60;
        this.height = 12 + Math.random() * 60;
        this.speed = 0.5;
        this.color = 0x0;
        
        var shape:Shape = drawIrregularShape(0, 0, width, height, width * 0.8, height * 0.8);
        bitmapData = new BitmapData(shape.width, shape.height, true, 0x0);
        bitmapData.draw(shape);
    }
    
    // コード拝借
    // http://www40.atwiki.jp/spellbound/pages/1707.html
    private function drawIrregularShape(x:Number, y:Number, width:Number, height:Number, innerWidth:Number, innerHeight:Number):Shape {
        var outerWidth:Number = (width - innerWidth) / 2;
        var outerHeight:Number = (height - innerHeight) / 2;
        
        var points /*Array*/:Array = [[], [], [], []];
        var pos:Array = [
            [outerWidth, 0, innerWidth, outerHeight],
            [outerWidth + innerWidth, outerHeight, outerWidth, innerHeight],
            [outerWidth, outerHeight + innerHeight, innerWidth, outerHeight],
            [0, outerHeight, outerWidth, innerHeight]
            ];
        
        for (var i:int = 0; i < points.length; i++) {
            var maxCount:int = Math.random() * 2 + 2;
            for (var count:int = 0; count < maxCount; count++) {
                var p:Array = pos[i];
                points[i].push(getRandomPoint(p[0], p[1], p[2], p[3]));
            }
        }
        
        points[0].sortOn("x", Array.NUMERIC);
        points[1].sortOn("y", Array.NUMERIC);
        points[2].sortOn("x", Array.NUMERIC | Array.DESCENDING);
        points[3].sortOn("y", Array.NUMERIC | Array.DESCENDING);
        
        var shape:Shape = new Shape();
        shape.graphics.beginFill(color, ALPHA);
        shape.graphics.moveTo(x + points[0][0].x, y + points[0][0].y);
        for (i = 0; i < points.length; i++) {
            for (var j:int = 0; j < points[i].length; j++) {
                shape.graphics.lineTo(x + points[i][j].x, y + points[i][j].y);
            }
        }
        shape.graphics.lineTo(x + points[0][0].x, y + points[0][0].y);
        shape.graphics.endFill();
        
        return shape;
    }
}

function getRandomPoint(x:Number, y:Number, width:Number, height:Number):Point {
    return new Point(x + width * Math.random(), y + height * Math.random());
}
