/**
 * Copyright mikelito33bdx ( http://wonderfl.net/user/mikelito33bdx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bH45
 */

package {
    import adobe.utils.CustomActions;
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Main extends Sprite {
        
        private var _red_mc:Sprite;
        private var _green_mc:Sprite;
        private var _halfMc:int = 100 / 2;
        private var _halfW:Number;
        private var _halfH:Number;
        
        public function Main() {
            
            _halfW = stage.stageWidth / 2 - 100 / 2;
            _halfH = stage.stageHeight / 2 - 100 / 2;
            _red_mc = createBox(_halfW, _halfH, 0, 0xFF0000);
            this.addChild(_red_mc);
            _green_mc = createBox(_halfW, _halfH, 0, 0x00FF00);
            this.addChild(_green_mc);
            
            _red_mc.addEventListener(Event.ENTER_FRAME, redRotate);
            _green_mc.addEventListener(Event.ENTER_FRAME, greenRotate);
        }
        
        private function createBox(xPos:Number, yPos:Number, zPos:Number, color:Number):Sprite {
            var mySp:Sprite = new Sprite();
            mySp.graphics.beginFill(color, 0.5);
            mySp.graphics.drawRect(0, 0, 100, 100);
            mySp.graphics.endFill();
            mySp.x = xPos;
            mySp.y = yPos;
            mySp.z = zPos;
            return mySp;
        }
        
        private function redRotate(e:Event):void {
            var redX:Number=_red_mc.x;
            var redY:Number=_red_mc.y;
            //trace(redX,redY);
            var nRotationY:Number = (mouseX - redX) * 0.2;
            var nRotationX:Number=(mouseY-redY)*0.2;
            var redMatrix3D:Matrix3D = _red_mc.transform.matrix3D;
            
            redMatrix3D.appendTranslation( -_halfW - _halfMc, -_halfH - _halfMc, 0);
            redMatrix3D.appendRotation(nRotationY, Vector3D.Y_AXIS);
            redMatrix3D.appendRotation(nRotationX,Vector3D.X_AXIS);
            redMatrix3D.appendTranslation( _halfW + _halfMc, _halfH + _halfMc, 0);
            
        }
        
        private function greenRotate(e:Event):void {
            var greenX:Number = _green_mc.x;
            var greenY:Number = _green_mc.y;
            var nRotationY:Number = (mouseX - greenX) * 0.2;
            var nRotationX:Number = (mouseY - greenY) * 0.2;
            var greenMatrix3D:Matrix3D = _green_mc.transform.matrix3D;
            
            greenMatrix3D.prependTranslation( _halfMc, _halfMc, 0);
            greenMatrix3D.prependRotation(nRotationY,Vector3D.Y_AXIS);
            greenMatrix3D.prependRotation(nRotationX,Vector3D.X_AXIS);
            greenMatrix3D.prependTranslation( -_halfMc, -_halfMc, 0);
        }
    }
}