/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bGSS
 */

// forked from Kushfield's flash on 2014-3-18
// forked from takasumi's soundtest

package  

{

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.media.Sound;

    import flash.media.SoundChannel;

    import flash.media.SoundLoaderContext;

    import flash.media.SoundMixer;

    import flash.net.URLRequest;

    import flash.utils.ByteArray;

    import flash.geom.ColorTransform;

    import flash.system.LoaderContext;

    /**

     * license : 詳細ActionScript3.0 2 by 大重美幸 p196-197

     * にZを加えたら楽しかった。

     */

    [SWF(width=800,height=800,backgroundColor=0x000000)]

    public class soundGrid extends Sprite

    {

        private var leftRightSpList:Array;

        private var snd:Sound;

        

        function soundGrid() 

        {

            leftRightSpList = makeLeftRightSpList();

            playSound("http://liquid.cf/music.mp3");

        }

        

        private function playSound(sndUrl:String):void

        {

            snd = new Sound();

            var context:SoundLoaderContext = new SoundLoaderContext(10,true);

            var req:URLRequest = new URLRequest(sndUrl);

            snd.load(req,context);

            var sndChannel:SoundChannel;

            sndChannel = snd.play(0, int.MAX_VALUE);

            addEventListener(Event.ENTER_FRAME, onEnterFrame);

        }

        

        private function onEnterFrame(event:Event):void {

            var sp:Sprite;

            var bytes:ByteArray = new ByteArray();

            SoundMixer.computeSpectrum(bytes, false, 0);

            var i:uint, j:uint;

            for (i = 0; i < 2; i++)

            {

                var spList:Array = leftRightSpList[i];

                for (j = 0; j < 256; j++)

                {

                    sp = spList[j];

                    var rf:Number = bytes.readFloat();

                    var scale:Number = Math.max(0.05, 1 + rf * 40);

                    sp.scaleX = sp.scaleY = scale;

                    sp.z = scale * 10;

                    

                    var colorInfo:ColorTransform = sp.transform.colorTransform;

                    colorInfo.color = 0xFFFFFF * scale;

                    sp.transform.colorTransform = colorInfo;

                }

            }

        }

        

        private function makeLeftRightSpList():Array

        {

            var spLRList:Array = new Array();

            var grid_size:Number = 20;

            var circle_r:uint = 2;

            var offsetX:uint;

            var offsetY:uint;

            var n:uint;

            var i:uint, j:uint;

            for (n = 0; n < 2; n++)

            {

                var spList:Array = new Array();

                offsetX = 80 + (20 + grid_size * 16) * n;

                offsetY = 100;

                for (i = 0; i < 16; i++)

                {

                    for (j = 0; j < 16; j++)

                    {

                        var sp:Sprite = new Sprite();

                        sp.graphics.beginFill(0xFF0000);

                        sp.graphics.drawCircle(0, 0, circle_r);

                        sp.graphics.endFill();

                        sp.x = offsetX + grid_size * i;

                        sp.y = offsetY + grid_size * j;

                        addChild(sp);

                        spList.push(sp);

                    }

                }

                spLRList.push(spList);

            }

            return spLRList;

        }

        

    }



}