/**
 * Copyright ultranoir ( http://wonderfl.net/user/ultranoir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bGKu
 */

// forked from abakane's Film2
package{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
	
	public class Film2 extends Sprite{
		private static const W:uint = 99;
		private static const H:uint = 99;
		private var _canvas:BitmapData;
		private var _perlin:BitmapData;
		private var seed:uint = Math.floor( Math.random()*0xFFFF );
		private var point:Point = new Point(0, 0);
		private var cx:Number = stage.stageWidth/2;
		private var cy:Number = stage.stageHeight/2;
		private var ct:ColorTransform = new ColorTransform( 0, 0.8, 0.9, 0.9, 0, 0, 0, 0);
		private var sibling:Particle = null;
	
		public function Film2(){
			stage.quality = StageQuality.LOW;
			_canvas = new BitmapData( stage.stageWidth, stage.stageHeight, false, 0x0);
			_perlin = new BitmapData( W, H, false, 0x0);
			addChild( new Bitmap(_canvas) );
			for(var i:uint=0; i<W*H; i++){
				var p:Particle = new Particle( i%W-W/2, 0, Math.floor(i/W)-H/2, sibling);
				sibling = p;
			}
			this.addEventListener( Event.ENTER_FRAME, update);//
		}
		
		private function update( e:Event ):void{
			point.x = point.y ++;
			_perlin.perlinNoise( 50, 50, 2, seed, false, true, 0, true, [point]);
			var last:Particle = sibling;
			_canvas.lock();
			_canvas.colorTransform( _canvas.rect, ct);
			while(sibling){
				var p:Particle = sibling;
				var col:uint = _perlin.getPixel( p.bx+W/2, p.bz+H/2);
				var _y:Number = ( (col >> 16) - 0x80 )/1.3;
				var point:Point = p.rotate();//
				_canvas.setPixel( point.x + cx, point.y + _y + cy, col);
				sibling = p.s;
			}
			_canvas.unlock();
			sibling = last;
		}
	}
}

import flash.geom.Point;
class Particle{
	public var bx:Number;
	public var by:Number;
	public var bz:Number;
	public var s:Particle;
	private static const SP:uint = 4;
	private static const FL:uint = 250;
	private static const COS:Number = Math.cos(0.5);
	private static const SIN:Number = Math.sin(0.5);
	
	function Particle( _bx:Number=0, _by:Number=0, _bz:Number=0, _s:Particle=null){
		bx = _bx;
		by = _by;
		bz = _bz;
		s = _s;
	}
	public function rotate():Point{
		var _y:Number = by*COS - bz*SIN;
		var _z:Number = bz*COS + by*SIN;
		var scale:Number = FL/( FL + _z );
		return new Point( bx*scale*SP, _y*scale*SP);
	}
}