/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/bGHs
 */

/*
 * zahirです
 * コードが汚い上ですがとりあえず参加
 *
 * バラバラに配置されたカラーチップを
 * 上のグラデーションバーを参考にして
 * 並び替えて行ってください。
 * 合格ラインは 16個中 12個を正解することです。
 *
 * レベルが上がるごとにグラデーションの色が少なくなっていき
 * 最終的には2色のグラデーションの中から色を抽出するようになります
 *
 * */
package{
	import __AS3__.vec.Vector;
	
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.*;
	import flash.geom.Matrix;
	import flash.text.TextField;
	
	import mx.containers.Box;
	
	[SWF(width=465, height=465, backgroundColor=0x333333, frameRate=60)]
	public class GradationTest1 extends Sprite{
		private var chips:Vector.<Chip>;
		private var anss:Vector.<Box>;
		private var cont:Sprite;
		private var colors:Array = [0xFF0000, 0xFFFF00, 0x00FF00, 0x00FFFF, 0x0000FF, 0xFF00FF];
		
		private var lv_txt:TextField;
		private var level:int = 1;
		private var max_lv:int = 5;
		
		private var oX:int, oY:int;
		private var target:Chip;
		
		private var pass_txt:TextField;
		private var check_Btn:Button;
		private var next_Btn:Button;
		
		private var ques_num:int = 16;
		private var passingLine:int = 12;
		
		public function GradationTest1(){
			var init_Btn:Button = new Button( "  最初に戻る  " );
			addChild(init_Btn);
			init_Btn.x = 465 - init_Btn.width - 8;
			init_Btn.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void{
				level = 0;
				init( colors.length - level );
			});
			
			check_Btn = new Button("  答え合わせ  ");
			check_Btn.textColor = check_Btn.borderColor = 0x333333;
			addChild(check_Btn);
			check_Btn.x = init_Btn.x - check_Btn.width - 10;
			
			next_Btn = new Button("  ネクストステージ  ");
			next_Btn.textColor = next_Btn.borderColor = 0x333333;
			addChild(next_Btn);
			next_Btn.x = check_Btn.x - next_Btn.width - 10;
			
			lv_txt = label("レベル " + level);
			lv_txt.x = 10;
			addChild(lv_txt);
			
			init_Btn.y = check_Btn.y = next_Btn.y = lv_txt.y = 465 - init_Btn.height - 5;
			
			addChild( cont = new Sprite() );
			
			init(colors.length - level );
		}
		
		private function init( colorNum:int):void{
			while(cont.numChildren) cont.removeChildAt(cont.numChildren - 1);
			
			var i:int = 0;
			var len:int = colors.length;
			var arr:Array = [];
			var n:int = Math.round( (len-1) * Math.random() );
			for( i = 0; i<=colorNum; i++){
				arr[arr.length] = colors[n];
				n = (n+1) >= len ? 0:n+1;
			}
			var grd:Gradation = new Gradation(0);
			grd.setColors( arr );
			
			var size:int = 16;
			var num:int = ques_num;
			var num2:Number = 1/num + num2*Math.random();;
			
			arr = [];
			var a2:Array = [];
			for(i = 0; i<num; i++) arr[arr.length] = a2[a2.length] = i/num;
			
			chips = new Vector.<Chip>();
			anss = new Vector.<Box>();
			for(i = 0; i<num; i++){
				n = Math.round( (a2.length - 1) * Math.random() );
				var pos:Number = a2[n];
				var color:Number = grd.getColor( pos );
				var chip:Chip = new Chip( color , pos, size, i*20, 80);
				chips[chips.length] = chip;
				chip.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
					target = e.target as Chip;
					target.flg = false;
					oX = target.mouseX;
					oY = target.mouseY;
					target.stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove);
					target.stage.addEventListener(MouseEvent.MOUSE_UP, onUp);
				});
				a2.splice( n, 1);
				
				color = grd.getColor( arr[i] );
				var box:Box = new Box(color, size);
				anss[anss.length] = box;
				box.x = i*20;
				box.y = 140;
				cont.addChild( box );
			}
			for(i = 0; i<num; i++)
				cont.addChild(chips[i]);
			
			var w:int = cont.width;
			cont.x = (stage.stageWidth - w) >>1;
			cont.y = 140;
			
			var l1:TextField = label("■ サンプルだよ");
			cont.addChild( l1 );
			
			var sample:Shape = new Shape();
			var g:Graphics = sample.graphics;
			cont.addChild(sample);
			sample.y = l1.height + 3;
			for(i = 0; i<w;i++){
				g.beginFill( grd.getColor( i/w ) );
				g.drawRect( i, 0, 1, 16);
				g.endFill();
			}
			
			var l2:TextField = label("■ チップを並べ替えて虹にしよう");
			cont.addChild( l2 );
			l2.y = 60;
			
			pass_txt = label("得点 : " + passingLine +" / " + ques_num);
			cont.addChild( pass_txt );
			pass_txt.x = w - pass_txt.width * 2;
			pass_txt.y = 200;
			pass_txt.htmlText = "";
		}
		
		
		private function check_ans(e:MouseEvent):void{
			var len:int = anss.length;
			var i:int=0;
			var right:int = 0;
			for(;i<len;i++){
				var a:Box = anss[i] as Box;
				if(a.right){
					right++;
					var maru:Shape = maru();
					cont.addChild(maru);
					maru.x = a.x;
					maru.y = a.y + 24;
				}else{
					var batu:Shape = batu();
					cont.addChild( batu );
					batu.x = a.x;
					batu.y = a.y + 20;
				}
			}
			check_Btn.removeEventListener(MouseEvent.CLICK, check_ans);
			check_Btn.textColor = check_Btn.borderColor = 0x333333;
			
			pass_txt.htmlText = "得点 : " + right +" / " + ques_num +  "    (合格点 : " + passingLine +" / " + ques_num + ")";
			
			if( right >= passingLine){
				next_Btn.textColor = next_Btn.borderColor= 0xCCCCCC;
				next_Btn.addEventListener(MouseEvent.CLICK, nextStage);
			}
		}
		private function nextStage(e:MouseEvent):void{
			pass_txt.htmlText = "";
			
			next_Btn.textColor = next_Btn.borderColor = 0x333333;
			level++;
			lv_txt.htmlText = "レベル" + level;
			init(colors.length - (level > max_lv ? max_lv: level))
		}
		private function onMove(e:MouseEvent):void{
			target.x += target.mouseX - oX;
			target.y += target.mouseY - oY;
			var len:int = anss.length;
			for(var i:int = 0; i<len;i++){
				var ans:Box = anss[i] as Box;
				if(ans.hitTestObject(target)){
					target.x = ans.x;
					target.y = ans.y;
					target.flg = true;
					target.box = ans;
				}
			}
		}
		private function onUp(e:MouseEvent):void{
			if(!target.flg || !target.box.hitTestObject( target )){
				target.x = target.dx;
				target.y = target.dy;
			}else{
				target.box.setTarget( target );
			}
			var count:int = 0;
			for(var i:int =0, len:int = chips.length; i<len;i++){
				if(!chips[i].flg){
					check_Btn.textColor = check_Btn.borderColor = 0x333333;
					check_Btn.removeEventListener( MouseEvent.CLICK, check_ans);
					break;
				}else{
					count++;
					if(count == len){
						check_Btn.textColor = check_Btn.borderColor= 0xCCCCCC;
						check_Btn.addEventListener( MouseEvent.CLICK, check_ans);
					}
				}
			}
			target.stage.removeEventListener( MouseEvent.MOUSE_MOVE, onMove );
			target.stage.removeEventListener( MouseEvent.MOUSE_UP, onUp );
		}
		private function label(txt:String):TextField{
			var tf:TextField = new TextField();
			tf.autoSize = "left";
			tf.textColor = 0xCCCCCC;
			tf.htmlText = txt;
			return tf;
		}
		private function maru():Shape{
			var s:Shape = new Shape();
			var g:Graphics = s.graphics;
			var m:Matrix = new Matrix();
			m.createGradientBox( 20,20, 90, -4,-4);
			g.lineStyle( 4 );
			g.lineGradientStyle("linear", [0xFF9999,0xFF0000, 0x990000], [1,1,1],[0, 64,255],m);
			g.drawCircle( 8,6,6);
			return s;
		}
		private function batu():Shape{
			var s:Shape = new Shape();
			var g:Graphics = s.graphics;
			var m:Matrix = new Matrix();
			m.createGradientBox( 20,20, 90, -4,-4);
			g.lineStyle( 5 );
			g.lineGradientStyle("linear", [0xFFFF,0x99FF, 0x33FF], [1,1,1],[0, 64,255],m);
			g.moveTo( 3,3);
			g.lineTo(13,13);
			g.moveTo( 13,3);
			g.lineTo( 3,13);
			return s;
		}
	}
}

import frocessing.color.ColorLerp;

import org.libspark.betweenas3.core.easing.IEasing;
import org.libspark.betweenas3.easing.Linear;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.display.Graphics;
import flash.display.Shape;
import flash.text.TextField;
import mx.containers.Box;

class Button extends TextField{
	public function Button( txt:String ){
		this.background = this.border = true;
		this.backgroundColor = 0x111111;
		this.borderColor = 0x666666;
		this.textColor = 0xCCCCCC;
		this.autoSize = "center";
		text = txt;
	}
}
class Box extends Sprite{
	private var _ans:uint;
	private var _size:int;
	private var _t:Chip;
	private var _right:Boolean;
	public function color():uint{
		return _ans;
	}
	public function setTarget( target:Chip ):void{
		if( _t && _t != target){
			_t.x = _t.dx;
			_t.y = _t.dy;
			_t.flg = false;
			_t.box = new Box(0,0);
		}
		_t = target;
		if(_ans == target.color){
			_right =true;
		}else _right =false;
	}
	public function get right():Boolean{
		return _right;
	}
	public function Box( ans:uint, size:int ){
		_ans = ans;
		_size = size;
		var g:Graphics = this.graphics;
		g.lineStyle( 1, 0xCCCCCC );
		g.beginFill( 0x0);
		g.drawRect(0,0, _size,_size);
		g.endFill();
	} 
}
class Chip extends Sprite{
	private var _color:uint;
	private var _pos:Number;
	private var _size:int;
	
	private var _x:int;
	private var _y:int;
	
	public var flg:Boolean = false;
	public var box:Box;
	
	private var s:Shape;
	public function get dx():int{
		return _x;
	}
	public function get dy():int{
		return _y;
	}
	public function get color():uint{
		return _color;
	}
	public function get position():uint{
		return _pos;
	}
	public function Chip( color:uint , position:Number, size:int, x:int, y:int){
		_color = color;
		_pos = position;
		_size = size;
		this.x = _x = x;
		this.y = _y = y;
		s = new Shape();
		addChild(s);
		draw();
		addEventListener( MouseEvent.MOUSE_OVER, onOver );
		addEventListener( MouseEvent.MOUSE_OUT, onOut );
	}
	
	private function draw():void{
		var g:Graphics = s.graphics;
		g.clear();
		g.lineStyle( 1 , 0 );
		g.beginFill( color );
		g.drawRect( 0, 0, _size, _size );
		g.endFill();
	}
	private function onOver(e:MouseEvent):void{
		var g:Graphics = s.graphics;
		g.clear();
		g.lineStyle( 1 , 0xFFFFFF - _color );
		g.beginFill( color );
		g.drawRect( 0, 0, _size, _size );
		g.endFill();
	}
	private function onOut(e:MouseEvent):void{
		draw();
	}
}

class Gradation {
    
	private var _colors:Array;
	private var _easing:IEasing;
	
	public function Gradation(...args) {
		_colors = args.concat();
		_easing = Linear.linear;
	}
	//　勝手に追加
	public function setColors( arr:Array ):void{
		_colors = arr;
	}
	
	public function setEasing(easing:IEasing):void {
		// インターフェイスを引数に設定してるのは
		// どんな効果があるんですか？
		// 誰か教えてください！
		
		_easing = easing;
	}
	
	public function getColor(position:Number):uint {
		position = (position < 0 ? 0 : position > 1 ? 1 : position) * (_colors.length - 1);
		var idx:int = position;
		var alpha:Number = _easing.calculate(position - idx, 0, 1, 1);
		if (alpha == 0) {
			return _colors[idx];
		} else {
			return ColorLerp.lerp(_colors[idx], _colors[idx + 1], alpha);
		}
	}
}